package com.bxm.adsmanager.web.controller.abtest;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.abtest.AbtestSceneTest;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.abtest.AbTestSceneTestDto;
import com.bxm.adsmanager.model.vo.abtest.AbTestSceneTestVo;
import com.bxm.adsmanager.model.vo.abtest.AbTestSceneVo;
import com.bxm.adsmanager.service.abtest.AbTestSceneService;
import com.bxm.adsmanager.service.abtest.AbTestSceneTestService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/abtest")
public class AbTestSceneTestController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbTestSceneTestController.class);

    @Autowired
    AbTestSceneTestService abTestSceneTestService;

    @RequestMapping(value = "/sceneTest/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "sceneCode") Integer sceneCode,
                           @RequestParam(value = "testName") String testName,
                           @RequestParam(value = "positionType") short positionType,
                           @RequestParam(value = "positionId") String positionId,
                           @RequestParam(value = "json") String json,
                           @RequestParam(value = "status", defaultValue = "1") short status,
                           @RequestParam(value = "isAllPosition", defaultValue = "0") short isAllPosition) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            AbtestSceneTest abtestSceneTest = new AbtestSceneTest();
            abtestSceneTest.setCreateTime(new Date());
            abtestSceneTest.setCreateUser(user.getUsername());
            abtestSceneTest.setStatus(status);
            abtestSceneTest.setPositionType(positionType);
            abtestSceneTest.setSceneCode(sceneCode);
            abtestSceneTest.setTestName(testName);
            abtestSceneTest.setJson(json);
            abtestSceneTest.setPositionId(positionId);
            abtestSceneTest.setIsAllPosition(isAllPosition);
            abTestSceneTestService.add(abtestSceneTest);
            //日志记录
            addLogs(user, "新增 试验的详细信息是：" + JSON.toJSONString(abtestSceneTest), "业务场景试验");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增试验出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/sceneTest/update", produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "sceneCode") Integer sceneCode,
                              @RequestParam(value = "testName") String testName,
                              @RequestParam(value = "positionType") short positionType,
                              @RequestParam(value = "positionId") String positionId,
                              @RequestParam(value = "json") String json,
                              @RequestParam(value = "id") Integer id,
                              @RequestParam(value = "isAllPosition", defaultValue = "0") short isAllPosition) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            AbtestSceneTest abtestSceneTest = new AbtestSceneTest();
            abtestSceneTest.setModifyTime(new Date());
            abtestSceneTest.setModifyUser(user.getUsername());
            abtestSceneTest.setPositionType(positionType);
            abtestSceneTest.setSceneCode(sceneCode);
            abtestSceneTest.setTestName(testName);
            abtestSceneTest.setJson(json);
            abtestSceneTest.setId(id);
            abtestSceneTest.setIsAllPosition(isAllPosition);
            abtestSceneTest.setPositionId(positionId);
            abTestSceneTestService.update(abtestSceneTest);
            //日志记录
            addLogs(user, "修改 试验的详细信息是：" + JSON.toJSONString(abtestSceneTest), "业务场景试验");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改试验出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }


    @RequestMapping(value = "/sceneTest/updateStatus", produces = "application/json")
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response,
                                    @RequestParam(value = "id") Integer id,
                                    @RequestParam(value = "status") Integer status) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            abTestSceneTestService.updateStatus(id, status, user.getUsername());
            //日志记录
            addLogs(user, "修改" + id + " 试验的状态（0开启1关闭）被修改为 ：" + status, "业务场景试验");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改试验出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }


    @RequestMapping(value = "/sceneTest/getPageList", produces = "application/json")
    public ResultModel<PageInfo<AbTestSceneTestVo>> getPageList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            AbTestSceneTestDto abTestSceneTestDto) {
        ResultModel<PageInfo<AbTestSceneTestVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(abTestSceneTestService.getPageList(pageNum, pageSize,abTestSceneTestDto));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找试验列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找试验列表出错");
        }
        return resultModel;
    }

}
