/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adapi;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adapi.facade.AdPositionMaterialService;

import com.bxm.adapi.facade.model.*;
import com.bxm.adsmanager.model.ro.AdPositionMaterialEditRo;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName AdPositionMaterialController.java
 * @Description 功能描述：
 * @author leon 2018年3月22日 上午11:21:29
 * @CopyRight 杭州微财网络科技有限公司
 */
@RefreshScope
@RestController
@RequestMapping("/adapi/adPositionMaterial")
public class AdPositionMaterialController {

    // todo adapi升级
    @Autowired(required = false)
    private AdPositionMaterialService adPositionMaterialService;

    /**
     * 新增
     * @param editRo
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<Boolean> add(AdPositionMaterialEditRo editRo) throws Exception {
        return adPositionMaterialService.add(trans2Eto(editRo));
    }

    /**
     * @Description 方法描述： 批量新增
     * @CopyRight 杭州微财网络科技有限公司
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/addBatch", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<Boolean> addBatch(AdPositionMaterialEditDto adPositionMaterialEditDto) throws Exception {
        return adPositionMaterialService.addBatch(adPositionMaterialEditDto);
    }

    /**
     * 修改状态
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> updateStatus(@RequestParam(value = "id", required = true) Long id,
                                             @RequestParam(value = "status", required = true) Integer status) throws Exception {
        return adPositionMaterialService.updateStatus(id, status);
    }

    /**
     * 修改
     * @param editRo
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/update", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> update(AdPositionMaterialEditRo editRo) throws Exception {

        return adPositionMaterialService.update(trans2Eto(editRo));
    }

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param AdPositionMaterialDto
     * @return
     */
    @RequestMapping(value = "/getList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<AdPositionMaterialRo>> getList(AdPositionMaterialDto AdPositionMaterialDto) {

        return adPositionMaterialService.getList(AdPositionMaterialDto);

    }

    @RequestMapping(value = "/updateCtr", method = RequestMethod.POST)
    public ResultModel<Boolean> updateCtr(Long id, Long clicknum, Long exposurenum, String date){
        return adPositionMaterialService.updateCtr(id, clicknum, exposurenum, date);
    }

    private AdPositionMaterialEditDto trans2Eto(AdPositionMaterialEditRo editRo) {
        AdPositionMaterialEditDto editDto = new AdPositionMaterialEditDto();
        editDto.setId(editRo.getId());
        editDto.setMaterialId(editRo.getMaterialId());
        editDto.setMediaAdPositionId(editRo.getMediaAdPositionId());
        editDto.setName(editRo.getName());
        editDto.setSize(editRo.getSize());
        editDto.setImages(JSONObject.parseArray(editRo.getImages(), ImageDto.class));
        editDto.setTitle(editRo.getTitle());
        editDto.setIntroduction(editRo.getIntroduction());
        editDto.setMaterialType(editRo.getMaterialType());
        return editDto;
    }

}
