/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adapi;

import com.bxm.adapi.facade.MediaAdPositionService;
import com.bxm.adapi.facade.model.MediaAdPositionDto;
import com.bxm.adapi.facade.model.MediaAdPositionRo;
import com.bxm.adapi.facade.model.ResultModel;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.MediaCommonConfigFacadeIntegration;
import com.bxm.adsmanager.model.enums.MediaConfigEnum;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName MediaAdPositionController.java
 * @Description 功能描述：
 * @author leon 2018年3月22日 上午11:21:29
 * @CopyRight 杭州微财网络科技有限公司
 */
@Slf4j
@EnableAutoConfiguration
@RefreshScope
@RestController
@RequestMapping("/adapi/mediaAdPosition")
@Api(description = "媒体广告位相关接口")
public class MediaAdPositionController {

    @Autowired
    private MediaAdPositionService mediaAdPositionService;
    
    @Autowired
    private MediaCommonConfigFacadeIntegration mediaCommonConfigFacadeIntegration;

    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param MediaAdPositionDto
     * @return
     */
    @RequestMapping(value = "/getList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<MediaAdPositionRo>> getList(MediaAdPositionDto mediaAdPositionDto) {
        //修改20181022
        ResultModel<PageInfo<MediaAdPositionRo>> resultModel = mediaAdPositionService.getList(mediaAdPositionDto);
        if(resultModel != null && resultModel.isSuccessed() && resultModel.getReturnValue()!=null){
            if(!CollectionUtils.isEmpty(resultModel.getReturnValue().getList())){
                Map<String, String> map = mediaCommonConfigFacadeIntegration.findMediaConfigIdToNameMap(MediaConfigEnum.POSITION_CLASS.getTypeCode());
                List<MediaAdPositionRo> list = resultModel.getReturnValue().getList();

                //字段翻译
                list.forEach(mediaAdPositionRo -> {
                    mediaAdPositionRo.setMediaClass(map.get(mediaAdPositionRo.getMediaClass()));
                    mediaAdPositionRo.setMediaChildClass(map.get(mediaAdPositionRo.getMediaChildClass()));
                });
                resultModel.getReturnValue().setList(list);
            }
        }
        return resultModel;

    }

    @RequestMapping("/updateMaterialType")
    public ResultModel<Boolean> updateMaterialType(@RequestParam(name = "positionId") String positionId,
                                                   @RequestParam(name = "materialType") String materialType) {
        boolean result = newAppEntranceFacadeIntegration.updateMaterialType(positionId, materialType);
        if (!result) {
            throw new BusinessException("修改失败！");
        }
        return new ResultModel<>();
    }

}
