package com.bxm.adsmanager.web.controller.adarpu;

import com.bxm.adsmanager.model.dto.adarpu.AdDoMainArpuDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adarpu.AdDomainArpuVo;
import com.bxm.adsmanager.service.adarpu.AdArpuService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @ClassName AdArpuController
 * @Description 礼券ARPU查询控制器
 * @Author xw
 * @Date 2018/4/17 17:14
 * @Version 1.0
 * @Modifier xw
 * @Modify Date 2018/4/17 17:14
 **/
@RestController
@RequestMapping("/adArpu")
public class AdDomainArpuController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdDomainArpuController.class);

    @Autowired
    AdArpuService adArpuService;
    /**
     * @description 新增礼券默认ARPU信息
     * @author xw  
     * @date 2018/4/17 18:46 
     * @param request
    * @param response
    * @param adArpuDto  
     * @return com.bxm.util.dto.ResultModel  
     */  
    @RequestMapping(value = "/add",method = RequestMethod.POST,produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdDoMainArpuDto adArpuDto){
        try {
            // 参数校验
            if (BeanValidator.validateGroup(adArpuDto, AdDoMainArpuDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adArpuDto,
                        AdDoMainArpuDto.Add.class).getMessage());
            }
            adArpuDto.setCreateUser(getUser(request,response).getUsername());
            adArpuDto.setModifyUser(getUser(request,response).getUsername());
            adArpuService.insert(adArpuDto);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增礼券ARPU出错",e);
            return ResultModelFactory.FAIL500("新增礼券ARPU出错");
        }
    }
    /**
     * @description 修改礼券默认ARPU信息
     * @author xw
     * @date 2018/4/17 18:46 
     * @param request
    * @param response
    * @param adArpuDto  
     * @return com.bxm.util.dto.ResultModel  
     */  
    @RequestMapping(value = "/update",method = RequestMethod.POST,produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdDoMainArpuDto adArpuDto){
        try {
            // 参数校验
            if (BeanValidator.validateGroup(adArpuDto, AdDoMainArpuDto.Update.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adArpuDto,
                        AdDoMainArpuDto.Update.class).getMessage());
            }
            adArpuDto.setModifyUser(getUser(request,response).getUsername());
            adArpuService.updateByPrimaryKey(adArpuDto);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改礼券ARPU出错",e);
            return ResultModelFactory.FAIL500("修改礼券ARPU出错");
        }
    }
    
    /**
     * @description 删除礼券默认ARPU信息
     * @author xw
     * @date 2018/4/17 18:46 
     * @param request
    * @param response
    * @param id  
     * @return com.bxm.util.dto.ResultModel  
     */  
    @RequestMapping(value = "/delete",method = RequestMethod.GET)
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, long id){
        try {
            adArpuService.deleteByPrimaryKey(id);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("删除礼券ARPU出错",e);
            return ResultModelFactory.FAIL500("删除礼券ARPU出错");
        }
    }

    /**
     * @description 查询礼券默认ARPU信息
     * @author xw
     * @date 2018/4/17 18:47 
     * @param request
    * @param response
    * @param adArpuDto  
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>  
     */  
    @RequestMapping(value = "/findAll",method = RequestMethod.GET)
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response, AdDoMainArpuDto adArpuDto){
        try {
            ResultModel<Pagination> resultModel = new ResultModel<>();
            Pagination pagination = adArpuService.findArpuPage(adArpuDto);
            resultModel.setReturnValue(pagination);
            return resultModel;
        } catch (Exception e) {
            LOGGER.error("查询礼券ARPU出错",e);
            return ResultModelFactory.FAIL500("查询礼券ARPU出错");
        }
    }
    /**
     * @description 根据ID查询礼券默认ARPU信息
     * @author xw  
     * @date 2018/4/17 18:47 
     * @param request
    * @param response
    * @param id  
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.adarpu.AdDomainArpuVo>  
     */  
    @RequestMapping(value = "/findById", method = RequestMethod.GET)
    public ResultModel<AdDomainArpuVo> findById(HttpServletRequest request, HttpServletResponse response,long id) {
        ResultModel<AdDomainArpuVo> rs = new ResultModel<>();
        try {
            AdDomainArpuVo result = adArpuService.selectByPrimaryKey(id);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (Exception e) {
            LOGGER.error("根据ID查询礼券ARPU出错" + e.getMessage(), e);
            rs.setErrorDesc("根据ID查询礼券ARPU出错");
            return rs;
        }
    }
}
