package com.bxm.adsmanager.web.controller.adflowpackage;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 流量包配置优化功能
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.web.controller.adflowpackage.AdTicketFlowNewController.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-04-20 11:05:00
 */
@RestController
public class AdTicketFlowNewController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketFlowNewController.class);

    @Autowired
    private AdTicketFlowNewService adTicketFlowNewService;


    /**
     * 编辑时候查询流量包
     *
     * @param ticketId
     * @return com.bxm.util.dto.ResultModel<java.util.List   <   java.lang.Long>>
     * @author 阿导
     * @time 2018/4/23
     * @CopyRight 杭州微财科技有限公司
     */
    @GetMapping(value = "/newpackage/findpackageMsg",produces="application/json")
    public ResultModel<List<AdFlowPackageNewVo>> findFlowPageIdByTicket(@RequestParam(value = "ticketId", required = false) Long ticketId) {
        //声明结果
        ResultModel<List<AdFlowPackageNewVo>> rs = new ResultModel<>();
        try {
            //调用服务层
            rs.setReturnValue(adTicketFlowNewService.findFlowPageIdByTicket(ticketId));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        //返回
        return rs;
    }


    /**
     * 根据流量包 ID 查询流量包
     *
     * @param ticketId
     * @param type
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo   <   com.bxm.adsmanager.model.vo.AdFlowPackageNewVo>>
     * @author 阿导
     * @time 2018/4/23
     * @CopyRight 杭州微财科技有限公司
     */
   @GetMapping(value = "/newpackage/findpackage",produces="application/json")
    public ResultModel<List<AdFlowPackageNewVo>> findPackageByCondition(@RequestParam(value = "ticketId", required = false) Long ticketId,
                                                                        @RequestParam(value = "type", defaultValue = "cpc") String type) {
        //声明结果
        ResultModel<List<AdFlowPackageNewVo>> rs = new ResultModel<>();
        try {
            //调用服务层
            rs.setReturnValue(adTicketFlowNewService.findPackageByCondition(ticketId, type));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        //返回
        return rs;
    }


//    /**
//     * 根据流量包 ID 查询流量包
//     *
//     * @param packageIdArray
//     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo   <   com.bxm.adsmanager.model.vo.AdFlowPackageNewVo>>
//     * @author 阿导
//     * @time 2018/4/23
//     * @CopyRight 杭州微财科技有限公司
//     */
//    @GetMapping(value = "/newpackage/findpackageMsg",produces="application/json")
//    public ResultModel<List<AdFlowPackageNewVo>> findPackageByCondition(@RequestParam(value = "packageIdArray") String packageIdArray) {
//        //声明结果
//        ResultModel<List<AdFlowPackageNewVo>> rs = new ResultModel<>();
//        try {
//            List<Long> packageIds = new ArrayList<>();
//            if (StringUtil.isNotEmpty(packageIdArray)) {
//                packageIds = JSON.parseArray(packageIdArray, Long.class);
//            }
//            //调用服务层
//            rs.setReturnValue(adTicketFlowNewService.findPackageByCondition(packageIds));
//            rs.setSuccessed(true);
//        } catch (Exception e) {
//            //异常处理
//            LOGGER.error(e.getMessage(), e);
//            rs.setSuccessed(false);
//            rs.setErrorDesc("system error");
//        }
//        //返回
//        return rs;
//    }

    /**
     * 新老数据同步处理
     *
     * @param request
     * @param response
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 阿导
     * @time 2018/4/23
     * @CopyRight 杭州微财科技有限公司
     */
    @GetMapping(value = "/newpackage/oldtonew",produces="application/json")
    public ResultModel<Boolean> oldToNew(HttpServletRequest request, HttpServletResponse response) {
        //声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            //调用服务层
            adTicketFlowNewService.oldToNew(getUserName(request, response));
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setReturnValue(false);
            rs.setErrorDesc("system error");
        }
        //返回
        return rs;
    }


    /**
     * 获取操作者的用户名
     *
     * @param request
     * @param response
     * @return java.lang.String
     * @author 阿导
     * @time 2018/3/23
     * @CopyRight 杭州微财科技有限公司
     */
    private String getUserName(HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        if (user == null) {
            return "用户不明";
        }
        return user.getUsername();
    }
}
