package com.bxm.adsmanager.web.controller.adkeeper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAppIdPackageDTO;
import com.bxm.adsmanager.model.dto.AdAppIdPackageSearchDTO;
import com.bxm.adsmanager.model.vo.AdAppIdPackageListVO;
import com.bxm.adsmanager.service.adkeeper.AdAppIdPackageService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 广告券AppId包.</br>
 * Created by zhengwangeng on 2021/12/20
 */
@RestController
@RequestMapping("/adAppIdPackage")
public class AdAppIdPackageController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAppIdPackageController.class);

    @Autowired
    private AdAppIdPackageService adAppIdPackageService;

    /**
     * 新增
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType="/adAppIdPackage/add",keyName="AppIdPackage新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(@Validated @RequestBody AdAppIdPackageDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        adAppIdPackageService.add(dto);
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 修改
     *
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAppIdPackage/update", keyName = "AppIdPackage修改")
    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    public ResultModel updateStatus(@Validated @RequestBody AdAppIdPackageDTO dto,
                                    HttpServletRequest request, HttpServletResponse response) {
        if (dto.getId() == null) {
            return ResultModelFactory.FAIL500("ID不能为空");
        }
        User user = getUser(request, response);
        try {
            adAppIdPackageService.update(dto);
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 分页查询
     *
     * @param request
     * @param response
     * @param searchDTO
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel<PageInfo> findPage(HttpServletRequest request, HttpServletResponse response,
                                                 AdAppIdPackageSearchDTO searchDTO) {
        ResultModel<PageInfo> rs = new ResultModel<>();
        try {
            PageInfo<AdAppIdPackageListVO> page = adAppIdPackageService.findPage(searchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(page);
        } catch (Exception e) {
            LOGGER.error("根据条件查找AppIdPackage出错" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据条件查找AppIdPackage出错");
        }
        return rs;
    }

}
