package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dto.AdAssetsAdxDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsAdxService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

/**
 * ADX素材
 * Created by zhengwangeng on 2019/7/30 14:01.
 */
@RestController
@RequestMapping("/adAssetsAdx")
public class AdAssetsAdxController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsAdxController.class);

    @Autowired
    private AdTicketAssetsAdxService adTicketAssetsAdxService;

    /**
     * 根据素材ids查找所有广告素材,这里没有做分页处理
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List<AdAssetsAdx> list = adTicketAssetsAdxService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("获取数据为空");
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据素材ids查找所有广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据素材ids查找所有广告素材出错");
        }
        return rs;
    }

    /**
     * 根据广告券id查找广告素材,这里没有做分页处理
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/findAllAssetsById", method = RequestMethod.GET)
    public ResultModel findAllAssetsById(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400("id不能为空");
        }

        try {
            List<AdAssetsAdx> list = adTicketAssetsAdxService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据广告券id查找广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return rs;
    }


    /**
     * 根据广告券id查找广告素材,这里没有做分页处理
     *
     * @param request
     * @param response
     * @param adAssetsAdxDto
     * @return
     */
    @RequestMapping(value = "/findAllAssetsListByParams", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsAdxDto adAssetsAdxDto) {
        ResultModel<Pagination> rs = new ResultModel<>();
        if (adAssetsAdxDto.getTicketId() == null) {
            return ResultModelFactory.FAIL400("礼券id不能为空");
        }
        try {
            Pagination list = adTicketAssetsAdxService.findAllAssetsListByParams(adAssetsAdxDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据广告券id查找广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return rs;
    }

}
