package com.bxm.adsmanager.web.controller.adkeeper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsConfigUid;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsConfigUidDTO;
import com.bxm.adsmanager.model.dto.AdAssetsConfigUidSearchDTO;
import com.bxm.adsmanager.model.vo.AdAssetsConfigUidVo;
import com.bxm.adsmanager.service.adkeeper.AdAssetsConfigUidService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 广告素材配置用户出价.</br>
 * Created by zhengwangeng on 2021/11/25
 */
@RestController
@RequestMapping("/adAssetsConfigUid")
public class AdAssetsConfigUidController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsConfigUidController.class);

    @Autowired
    private AdAssetsConfigUidService adAssetsConfigUidService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @LogBefore(operType = "/adAssetsConfigUid/add", keyName = "广告素材配置用户出价新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(@Validated @RequestBody AdAssetsConfigUidDTO dto, HttpServletRequest request,
                           HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adAssetsConfigUidService.add(dto, user);
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 修改状态
     *
     * @param id
     * @param status
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsConfigUid/updateStatus", keyName = "广告素材配置用户出价状态修改")
    @RequestMapping(value = "/updateStatus", method = RequestMethod.PUT)
    public ResultModel updateStatus(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Long id,
                                    @NotNull(message = "状态不能为空！") @RequestParam(value = "status") Short status,
                                    HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adAssetsConfigUidService.updateStatus(id, status, user.getUsername());
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 根据条件查询所有广告素材配置用户出价
     *
     * @param request
     * @param response
     * @param searchDTO
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel<PageInfo> findAll(HttpServletRequest request, HttpServletResponse response,
                                                 AdAssetsConfigUidSearchDTO searchDTO) {
        ResultModel<PageInfo> rs = new ResultModel<>();
        try {
            PageInfo<AdAssetsConfigUid> result = adAssetsConfigUidService.findPage(searchDTO);
            return ResultModelFactory.SUCCESS(result);
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/get", method = RequestMethod.GET)
    public ResultModel<AdAssetsConfigUidVo> get(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Long id) {
        ResultModel<AdAssetsConfigUidVo> rs = new ResultModel<>();
        try {
            AdAssetsConfigUidVo result = adAssetsConfigUidService.get(id);
            return ResultModelFactory.SUCCESS(result);
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 修改
     *
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsConfigUid/update", keyName = "广告素材配置用户出价修改")
    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    public ResultModel updateStatus(@Validated @RequestBody AdAssetsConfigUidDTO dto,
                                    HttpServletRequest request, HttpServletResponse response) {
        if (dto.getId() == null) {
            return ResultModelFactory.FAIL500("ID不能为空");
        }
        User user = getUser(request, response);
        try {
            adAssetsConfigUidService.update(dto, user);
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @LogBefore(operType = "/adAssetsConfigUid/delete", keyName = "广告素材配置用户出价删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResultModel delete(Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adAssetsConfigUidService.delete(id, user);
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }
}
