package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AssetsPopupVo;
import com.bxm.adsmanager.model.vo.TicketAssetsCopyListVo;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UploadImg;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-12-07 16:04:00
 * @Description 广告素材
 */
@RestController
@RequestMapping("/adAssets")
public class AdAssetsController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsController.class);

	@Autowired
	private AdTicketAssetsService adTicketAssetsService;
	@Autowired
	private UploadImg uploadImg;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdAssetsMapper adAssetsMapper;


	/**
	 * @description 添加广告素材
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/add",keyName="广告")
	@RequestMapping(value = "/add", method = RequestMethod.POST)
	public ResultModel addAssets(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets)  {

		ResultModel rs = new ResultModel();
		try {
			if(adAssets ==null){
				return ResultModelFactory.FAIL400("参数不可以为空");
			}

			rs = checkParam(rs,adAssets);
			if(!rs.isSuccessed()){
				return rs;
			}

			adAssets.setCreateUser(getUser(request,response).getUsername());
			Object id = adTicketAssetsService.add(adAssets);
			rs.setReturnValue(id);
		}catch (Exception e){
			LOGGER.error("添加广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加广告素材出错");
		}
		return  rs;
	}

	/**
     * @description 添加广告素材
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    @LogBefore(operType="/adAssets/addNew",keyName="广告")
    @RequestMapping(value = "/addNew", method = RequestMethod.POST)
    public ResultModel<Boolean> addNew(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets,Long ticketId)  {

        ResultModel<Boolean> rs = new ResultModel();
        try {
            if(adAssets ==null){
                return ResultModelFactory.FAIL400("参数不可以为空");
            }

            rs = checkParam(rs,adAssets);
            if(!rs.isSuccessed()){
                return rs;
            }

            adAssets.setCreateUser(getUser(request,response).getUsername());
            // 产品邮件去掉此功能
//             if(adTicketAssetsService.findAssetsByTicket(ticketId, adAssets)) {
//                 return ResultModelFactory.FAIL400("必须有一张开启状态的不限弹窗的素材图！");
//             }
            adTicketAssetsService.addNew(adAssets,ticketId);
            rs.setReturnValue(true);
        }catch (Exception e){
            LOGGER.error("添加广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告素材出错");
        }
        return  rs;
    }
	/**
	 * @description 添加广告素材图片 换个权限校验方式
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/uploadImg",keyName="广告")
	@RequestMapping(value = "/uploadImg", method = RequestMethod.POST)
	@Deprecated
	public ResultModel uploadImg(HttpServletRequest request, HttpServletResponse response) {

		ResultModel rs = new ResultModel();
		try {
			//上传图片，使用的方法，地址和老系统一致
			JSONArray urlString = (JSONArray)uploadImg.uploadImg(response, request, "certificate", LOGGER);
			if(urlString!=null){
				JSONObject urlJson =  urlString.getJSONObject(0);
				String url = (String)urlJson.get("url");
				rs.setReturnValue(url);
			}
		}catch (Exception e){
			LOGGER.error("添加添加广告素材图片出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加添加广告素材图片出错");
		}
		return  rs;
	}

	/**
	 * @description 根据素材ids查找所有广告素材,这里没有做分页处理
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel findAllAssets(String ids) {

		ResultModel rs = new ResultModel();
		try {
			List<AdAssets> list = adTicketAssetsService.findAll(ids);
			if(null == list){
				rs.setSuccessed(false);
				rs.setErrorCode("5031");
				rs.setErrorDesc("获取数据为空");
			}
			rs.setReturnValue(list);
		}catch (Exception e){
			LOGGER.error("根据素材ids查找所有广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("根据素材ids查找所有广告素材出错");
		}
		return  rs;
	}

	/**
	 * @description 根据广告券id查找广告素材,这里没有做分页处理
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAllAssetsById", method = RequestMethod.GET)
	public ResultModel findAllAssetsById(Long id) {

		ResultModel rs = new ResultModel();

		if(id==null){
			return ResultModelFactory.FAIL400("id不能为空");
		}

		try {
			List<AdAssets> list = adTicketAssetsService.findAllAssetsById(id);
			if(list!=null){
				rs.setSuccessed(true);
			}
			rs.setReturnValue(list);
		}catch (Exception e){
			LOGGER.error("根据广告券id查找广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
		}
		return  rs;
	}



	/**
	 * @description 更新广告素材
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/update",keyName="广告")
	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public ResultModel updateAllAssets(HttpServletRequest request, HttpServletResponse response,AdAssets adAssets,Long ticketId) {
		ResultModel rs = new ResultModel();
        Object result = null;
		try {
			if(adAssets ==null|| adAssets.getId()==null){
				return ResultModelFactory.FAIL400("id不能为空");
			}

			rs = checkParam(rs,adAssets);
			if(!rs.isSuccessed()){
				return rs;
			}
//			if(adTicketAssetsService.findAssetsByTicket(ticketId, adAssets)) {
//                return ResultModelFactory.FAIL400("必须有一张开启状态的不限弹窗的素材图！");
//            }
			adAssets.setModifyUser(getUser(request,response).getUsername());
			//增加是否需要审核的判断
            // 新版本不在需要判断审核开关
//            String checkFlag = adTicketService.getIsCheck();
//			if(StringUtils.isNotBlank(checkFlag) && checkFlag.length() != 9&& "1".equals(checkFlag)){
           /* if (adTicketService.checkTagNeedAudit(ticketId.intValue())){
                //调用审核的修改券素材的接口
			    result = adTicketAssetsService.updateAndAudit(adAssets,getUser(request,response));
            }else{*/
                result = adTicketAssetsService.update(adAssets);
            //}
			if(result!=null){
				rs.setSuccessed(true);
			}
		}catch (Exception e){
			LOGGER.error("更新广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告素材出错");
		}
		rs.setReturnValue(result);
		return  rs;
	}

	@LogBefore(operType="/adAssets/updateStatus",keyName="广告素材状态修改")
	@RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
	public ResultModel<Boolean> updateStatus(HttpServletRequest request, HttpServletResponse response,
									@RequestParam(name = "id") Long id,
									@RequestParam( name = "status") Integer status ) {
		ResultModel<Boolean> rs = new ResultModel();
		try {
			adTicketAssetsService.updateStatus(id,status);
		}catch (Exception e){
			LOGGER.error("更新广告素材状态"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
		rs.setReturnValue(true);
		return  rs;
	}

	/**
	 * @description 删除广告券素材
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@Deprecated
	@LogBefore(operType="/adAssets/delete",keyName="广告")
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	public ResultModel deleteAssets(HttpServletRequest request, HttpServletResponse response,
									 @RequestParam(required = true, name = "ids") String ids) {

		ResultModel rs = new ResultModel();
		Integer result = null;
		if(ids == null){
		    return ResultModelFactory.FAIL400("ids不能为空");
        }
		try {
            Integer ticketId = adTicketAssetsService.findTicketByAssetIds(ids);
            //直接删除了
			//增加是否需要审核的判断
//            String checkFlag = adTicketService.getIsCheck();
//			if(StringUtils.isNotBlank(checkFlag) && checkFlag.length() != 9 && "1".equals(checkFlag)){
            /*if (adTicketService.checkTagNeedAudit(ticketId)){
		        result = adTicketAssetsService.deleteBatchAndAudit(ids);
            }else{*/
                result = adTicketAssetsService.delete(ids);
            //}
			if(result!=null){
				rs.setReturnValue(result);
			}
		}catch (Exception e){
			LOGGER.error("删除广告券素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("删除广告券素材出错");
		}
		return  rs;
	}


	/**
	 * @description 素材参数校验
	 * @author hcmony
	 * @time 2017/12/29
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param rs
	 * @param adAssets
	 * @return com.bxm.util.dto.ResultModel
	 */
	public <T> ResultModel checkParam(ResultModel<T> rs ,AdAssets adAssets){

		if(AdAssets.VARS_NO==adAssets.getVars()&& StringUtil.isBlank(adAssets.getName())){
			return ResultModelFactory.FAIL400("不显示省市的时候name不能为空");
		}

		if(AdAssets.VARS_NO!=adAssets.getVars()&& StringUtil.isBlank(adAssets.getContent())){
			return ResultModelFactory.FAIL400("显示省市的时候素材内容不能为空");
		}

		//参数校验
		if (BeanValidator.validateGroup(adAssets, AdAssets.Add.class) != null) {
			return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adAssets, AdAssets.Add.class).getMessage());
		}
		return  rs;
	}
	
	/**
     * @description 根据广告券id查找广告素材,这里没有做分页处理
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    @RequestMapping(value = "/findAllAssetsListByParams", method = RequestMethod.GET,produces = "application/json")
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsDto adAssetsDto) {

        ResultModel<Pagination> rs = new ResultModel<Pagination>();

        if(adAssetsDto.getTicketId()==null){
            return ResultModelFactory.FAIL400("礼券id不能为空");
        }
        try {
            Pagination list = adTicketAssetsService.findAllAssetsListByParams(adAssetsDto);
            if(list!=null){
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        }catch (Exception e){
            LOGGER.error("根据广告券id查找广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return  rs;
    }


    @RequestMapping(value = "/getAssetsPopupList", method = RequestMethod.GET)
    public ResultModel getAssetsPopupList(@RequestParam(value = "popupName", required = false) String popupKeyWord) {
        ResultModel resultModel = new ResultModel();

        try {
            List<AssetsPopupVo> list = adTicketAssetsService.getAssetsPopupList(popupKeyWord);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
            return resultModel;
        }catch (Exception e){
            LOGGER.error("查找素材弹窗出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找素材弹窗出错");
        }
    }

    /**
     * 更新素材流量占比
     * @return
     */
    @LogBefore(operType="/adAssets/updateFlowRate",keyName="素材流量占比")
    @RequestMapping(value = "/updateFlowRate", method = RequestMethod.POST)
    public ResultModel updateFlowRate(@RequestParam("assetsId") Long assetsId, @RequestParam("rate") Double rate) {
        if (rate < 0) {
            return ResultModelFactory.FAIL400("流量占比输入错误");
        }
        try {
            adTicketAssetsService.updateFlowRate(assetsId, rate);
            return ResultModelFactory.SUCCESS();
        }catch (Exception e){
            LOGGER.error("更新素材流量占比出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("更新素材流量占比出错");
        }
    }


    /**
     * 更新素材选择类型
     * @return
     */
    @LogBefore(operType="/adAssets/updateAssetsSelectType",keyName="素材人工控制或算法")
    @RequestMapping(value = "/updateAssetsSelectType", method = RequestMethod.POST)
    public ResultModel updateAssetsSelectType(@RequestParam("ticketId") Long ticketId, @RequestParam("assetsSelectType") Short assetsSelectType) {
        if (assetsSelectType != 1 && assetsSelectType != 0) {
            return ResultModelFactory.FAIL400("参数不正确");
        }
        try {
            adTicketAssetsService.updateAssetsSelectType(ticketId, assetsSelectType);
            return ResultModelFactory.SUCCESS();
        }catch (Exception e){
            LOGGER.error("更新素材选择类型出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("更新素材选择类型出错");
        }
    }

    /**
     * 获取素材选择类型
     * @return
     */
    @RequestMapping(value = "/getAssetsSelectType", method = RequestMethod.GET)
    public ResultModel getAssetsSelectType(@RequestParam("ticketId") Long ticketId) {
        try {
            Short assetsSelectType = adTicketAssetsService.getAssetsSelectType(ticketId);
            return ResultModelFactory.SUCCESS(assetsSelectType);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        }catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("服务器错误");
        }

    }

    /**
     * 获取券可复制的素材
     * @return
     */
    @RequestMapping(value = "/getTicketAssetsCopyList", method = RequestMethod.GET)
    public ResultModel getTicketAssetsCopyList(@RequestParam("ticketKeyword") String ticketKeyword,
                                               @RequestParam("ticketType") Short ticketType,
                                               HttpServletRequest request, HttpServletResponse response) {
        try {
            ResultModel resultModel = new ResultModel();
            User user = getUser(request, response);
            List<TicketAssetsCopyListVo> vos = adTicketAssetsService.getTicketAssetsCopyList(ticketKeyword, ticketType, user.getUsername());
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(vos);
            return resultModel;
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        }catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("服务器错误");
        }
    }


    /**
     * 复制券下的所有素材 到指定券
     * @return
     */
    @RequestMapping(value = "/copyTicketAssets", method = RequestMethod.GET)
    public ResultModel copyTicketAssets(@RequestParam("copyTicketId") Long copyTicketId,
                                           @RequestParam("targetTicketId") Long targetTicketId,
                                           HttpServletRequest request,
                                           HttpServletResponse response) {
        // 判断是同类型
        // 判断券下有素材
        AdTicket copyTicket = adTicketMapper.selectByPrimaryKey(copyTicketId);
        AdTicket targetTicket = adTicketMapper.selectByPrimaryKey(targetTicketId);
        if (copyTicket == null || targetTicket == null) {
            return ResultModelFactory.FAIL500("复制的券不存在");
        }
        if (!ObjectUtils.equals(copyTicket.getType(), targetTicket.getType())) {
            return ResultModelFactory.FAIL500("复制的券不是同类型");
        }
        List<AdAssets> allAssetsById = adTicketAssetsService.findAllAssetsById(copyTicketId);
        if (CollectionUtils.isEmpty(allAssetsById)) {
            return ResultModelFactory.FAIL500("复制的券下没有素材");
        }
        int pass = 0;
        int resuse = 0;
        for (AdAssets assets : allAssetsById) {
            if (assets.getStatus() != null && assets.getStatus() == 2) {
                continue;
            }
			if (assets.getAuditStatus() != null && assets.getAuditStatus() == AdAssets.STATUS_AUTDIT_REFUSE) {
				resuse++;
				continue;
			}
			pass++;
            assets.setId(null);
            assets.setStatus((short) 0);
            assets.setAuditStatus(AdAssets.STATUS_AUDIT_WAIT);
            assets.setRefuseReason(null);
            ResultModel<Boolean> resultModel = addNew(request, response, assets, targetTicketId);
            if (resultModel != null && resultModel.getReturnValue() == null) {
                LOGGER.warn("复制券素材时出错，copyTicketId:{}, targetTicketId:{}, assetsId:{}", copyTicketId, targetTicketId, assets.getId());
            }
        }
		String message = "成功复制素材" + pass + "条，"+ resuse + "条处于审核拒绝状态复制失败";
        return ResultModelFactory.SUCCESS(message);
    }

}
