package com.bxm.adsmanager.web.controller.adkeeper;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsInspireVideoDto;
import com.bxm.util.AliOSSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo;
import com.bxm.adsmanager.model.dto.AdAssetsInspireVideoSearchDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsInspireVideoService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

/**
 * 激励视频素材
 * Created by zhengwangeng on 2019/8/5 14:01.
 */
@RestController
@RequestMapping("/adAssetsInspireVideo")
public class AdAssetsInspireVideoController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsInspireVideoController.class);

    @Autowired
    private AdTicketAssetsInspireVideoService adTicketAssetsInspireVideoService;

    // OSS上传文件配置
    // @Value("${oss.bucketName}")
    private String bucketName ="bxm-guide";
    //@Value("${oss.fileHost}")
    private String fileHost ="https://buyimg.bianxianmao.com/";
    // @Value("${oss.accessKeyId}")
    private String accessKeyId ="LTAIdRl4etA0hXJt";
    // @Value("${oss.secret}")
    private String secret ="oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    /**
     * 新增激励视频素材
     * @param dto
     * @return
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(@Validated AdAssetsInspireVideoDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        dto.setCreateUser(user.getUsername());
        adTicketAssetsInspireVideoService.add(dto);
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 编辑激励视频素材
     * @param dto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultModel update(@Validated AdAssetsInspireVideoDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        dto.setModifyUser(user.getUsername());
        adTicketAssetsInspireVideoService.update(dto);
        return ResultModelFactory.SUCCESS();
    }


    /**
     * 修改状态
     * @param id
     * @param status
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    public ResultModel updateStatus(Long id , Integer status, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adTicketAssetsInspireVideoService.updateStatus(id, status, user.getUsername());
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
        return ResultModelFactory.SUCCESS();
    }


    /**
     * 删除素材（逻辑）

     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResultModel delete(Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adTicketAssetsInspireVideoService.delete(id, user.getUsername());
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 根据素材ids查找所有广告素材,这里没有做分页处理
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List<AdAssetsInspireVideo> list = adTicketAssetsInspireVideoService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("获取数据为空");
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据素材ids查找所有广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据素材ids查找所有广告素材出错");
        }
        return rs;
    }

    /**
     * 根据广告券id查找广告素材,这里没有做分页处理
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/findAllAssetsById", method = RequestMethod.GET)
    public ResultModel findAllAssetsById(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400("id不能为空");
        }

        try {
            List<AdAssetsInspireVideo> list = adTicketAssetsInspireVideoService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据广告券id查找广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return rs;
    }


    /**
     * 根据广告券id查找广告素材,这里没有做分页处理
     *
     * @param request
     * @param response
     * @param adAssetsInspireVideoSearchDto
     * @return
     */
    @RequestMapping(value = "/findAllAssetsListByParams", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsInspireVideoSearchDto adAssetsInspireVideoSearchDto) {
        ResultModel<Pagination> rs = new ResultModel<>();
        if (adAssetsInspireVideoSearchDto.getTicketId() == null) {
            return ResultModelFactory.FAIL400("礼券id不能为空");
        }
        try {
            Pagination list = adTicketAssetsInspireVideoService.findAllAssetsListByParams(adAssetsInspireVideoSearchDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据广告券id查找广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return rs;
    }


    /**
     * 文件上传
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/upload", method = { RequestMethod.POST })
    public ResultModel<List<String>> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultModel<List<String>> resultModel = new ResultModel<List<String>>();

        // 创建一个通用的多部分解析器
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<String> files = new ArrayList<>();
        // 判断 request 是否有文件上传,即多部分请求
        if (multipartResolver.isMultipart(request)) {
            // 转换成多部分request
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            // 取得request中的所有文件名
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                // 取得上传文件
                MultipartFile file = multiRequest.getFile(iter.next());
                if (file != null) {
                    // 取得当前上传文件的文件名称
                    String fileName = file.getOriginalFilename();
                    // 如果名称不为空,说明该文件存在，否则说明该文件不存在
                    if (fileName.trim() != "") {
                        File newFile = new File(fileName);
                        FileOutputStream outStream = new FileOutputStream(newFile); // 文件输出流用于将数据写入文件
                        outStream.write(file.getBytes());
                        outStream.close(); // 关闭文件输出流
                        file.transferTo(newFile);
                        // 上传到阿里云
                        files.add(AliOSSUtil.upload(accessKeyId, secret, newFile, bucketName, fileHost, null));
                        newFile.delete();
                    }
                }
            }
        }
        //上传失败提示
        if(files.isEmpty()){
            resultModel.setErrorDesc("系统异常,上传图片失败");
            resultModel.setReturnValue(null);
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(files);
        return resultModel;
    }
}
