package com.bxm.adsmanager.web.controller.adkeeper;

import java.io.File;
import java.io.FileOutputStream;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsDto;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsSearchDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsUpdateStatusDTO;
import com.bxm.adsmanager.model.dto.AdTicketCheckInfokDto;
import com.bxm.adsmanager.model.enums.PanguAdxEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.TicketAssetsCopyListVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsTemplateAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.audit.AdAuditService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;

/**
 * 素材模板素材.</br>
 * Created by zhengwangeng on 2021/6/16
 */
@RestController
@RequestMapping("/adAssetsTemplateAssets")
public class AdAssetsTemplateAssetsController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsTemplateAssetsController.class);

    @Autowired
    private AdTicketAssetsTemplateAssetsService adTicketAssetsTemplateAssetsService;
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;

    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdAuditService adAuditService;

    @Autowired
    private AdShopIntegration adShopIntegration;

    @Autowired
    private ProdService prodService;

    // OSS上传文件配置
    // @Value("${oss.bucketName}")
    private String bucketName = "bxm-guide";
    //@Value("${oss.fileHost}")
    private String fileHost = "https://buyimg.bianxianmao.com/";
    // @Value("${oss.accessKeyId}")
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    // @Value("${oss.secret}")
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    /**
     * 新增素材
     *
     * @param dto
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/add", keyName = "素材模板素材新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(@Validated AdAssetsTemplateAssetsDto dto, HttpServletRequest request,
                           HttpServletResponse response) {
        User user = getUser(request, response);
        dto.setCreateUser(user.getUsername());
        Long ticketId = dto.getTicketId();
        try {
            Long assetId = adTicketAssetsTemplateAssetsService.add(dto);
            afterHandle(user, ticketId, assetId);
            // 再推送更新广告券数据到prod
            prodService.pushAdTicketToProdPre(ticketId);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
        return ResultModelFactory.SUCCESS();
    }

    private void afterHandle(User user, Long ticketId, Long assetId) throws Exception {
        //ADX券，加白的广告主，自动审核通过
        AdTicket adTicket = adTicketService.find(ticketId);
        if (AdTicket.AdTicketType.isNotNewAdx(adTicket.getType())) {
            return;
        }
        AdvertiserDto advertiserDto = adShopIntegration.findAdShopMsg(adTicket.getAdvertiser());
        if (AdvertiserDto.ASSET_AUDIT_STATUS_WHITE == advertiserDto.getAssetAuditWhiteStatus()) {
            boolean unAuditTicket = false;
            //判断是否是新建的券
            if (AdTicket.WAIT_AUDIT == adTicket.getStatus()) {
                // 模拟风控审核广告券通过
                AdTicketCheckInfokDto adTicketCheckInfokDto = adTicketService.getTicketInfoAndAssetsModify(ticketId);
                Integer status = 1;//风控审核通过
                String refuseReason = null;
                String tags = adTicketCheckInfokDto.getTags();
                String domainCode = adTicketCheckInfokDto.getDomainCode();
                Boolean success = adTicketService.ticketCheck(ticketId, status, refuseReason, tags, domainCode,
                        "SYSTEM_AUDIT");
                unAuditTicket = true;
            }
            //广告列表: AND status in(1,2,3,-2,-3) and last_status >0
            boolean mayAuditPass = unAuditTicket || (AdTicket.STATUS_OPEN == adTicket.getStatus()
                    || AdTicket.STATUS_PAUSE == adTicket.getStatus() || AdTicket.STATUS_CLOSE == adTicket.getStatus());
            if (mayAuditPass) {
                //素材也审核通过：ids=329&ticketType=3&auditStatus=2&refuseReason=
                int ticketType = CommonConstant.AssetType.TICKET_TYPE_ASSETS_TEMPLATE_ASSETS;
                short auditStatus = CommonConstant.AssetAuditStatus.AUDIT_STATUS_PASS;
                adAuditService.asstesAudit(null, Arrays.asList(assetId), auditStatus, null,
                        ticketType, CommonConstant.AssetCheckStatus.CHECK_STATUS_WAIT, user.getUsername());

            }
        }
    }

    /**
     * 编辑素材
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/update", keyName = "素材模板素材修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultModel update(@Validated AdAssetsTemplateAssetsDto dto, HttpServletRequest request,
                              HttpServletResponse response) {
        User user = getUser(request, response);
        dto.setModifyUser(user.getUsername());
        Long ticketId = dto.getTicketId();
        try {
            Long assetId = adTicketAssetsTemplateAssetsService.update(dto);
            afterHandle(user, ticketId, assetId);
            // 再推送更新广告券数据到prod
            prodService.pushAdTicketToProdPre(ticketId);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("更新失败");
        }
        return ResultModelFactory.SUCCESS();
    }


    /**
     * 修改状态=投放控制
     *
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/updateStatus", keyName = "素材模板素材状态修改")
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    public ResultModel updateStatus(@Validated @RequestBody AdAssetsTemplateAssetsUpdateStatusDTO dto,
                                    HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        dto.setModifyUser(user.getUsername());
        try {
            adTicketAssetsTemplateAssetsService.updateStatus(dto);
            //根据券id推送数据到prod
            prodService.pushAdTicketToProdPre(dto.getTicketId());
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
        return ResultModelFactory.SUCCESS();
    }


    /**
     * 删除素材（逻辑）
     * @param id
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/delete", keyName = "素材模板素材删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResultModel delete(Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adTicketAssetsTemplateAssetsService.delete(id, user.getUsername());
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 根据素材ids查找所有广告素材,这里没有做分页处理
     * 在添加素材页面时需要所有素材
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List<AdAssetsTemplateAssets> list = adTicketAssetsTemplateAssetsService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("获取数据为空");
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据素材ids查找所有广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据素材ids查找所有广告素材出错");
        }
        return rs;
    }

    /**
     * 根据广告券id查找广告素材,这里没有做分页处理
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/findAllAssetsById", method = RequestMethod.GET)
    public ResultModel findAllAssetsByTicketId(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400("id不能为空");
        }

        try {
            List<AdAssetsTemplateAssets> list = adTicketAssetsTemplateAssetsService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据广告券id查找广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return rs;
    }


    /**
     * 根据广告券id查找广告素材
     * 券素材列表就是用的这个
     *
     * @param request
     * @param response
     * @param adAssetsTemplateAssetsSearchDto
     * @return
     */
    @RequestMapping(value = "/findAllAssetsListByParams", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsTemplateAssetsSearchDTO adAssetsTemplateAssetsSearchDto) {
        ResultModel<Pagination> rs = new ResultModel<>();
        if (adAssetsTemplateAssetsSearchDto.getTicketId() == null) {
            adAssetsTemplateAssetsSearchDto.setPageNum(1);
            adAssetsTemplateAssetsSearchDto.setPageSize(20);
        }
        try {
            Pagination list =
                    adTicketAssetsTemplateAssetsService.findAllAssetsListByParams(adAssetsTemplateAssetsSearchDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据广告券id查找广告素材出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return rs;
    }


    /**
     * 文件上传
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/upload", method = {RequestMethod.POST})
    public ResultModel<List<String>> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultModel<List<String>> resultModel = new ResultModel<List<String>>();

        // 创建一个通用的多部分解析器
        CommonsMultipartResolver multipartResolver =
                new CommonsMultipartResolver(request.getSession().getServletContext());
        List<String> files = new ArrayList<>();
        // 判断 request 是否有文件上传,即多部分请求
        if (multipartResolver.isMultipart(request)) {
            // 转换成多部分request
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            // 取得request中的所有文件名
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                // 取得上传文件
                MultipartFile file = multiRequest.getFile(iter.next());
                if (file != null) {
                    // 取得当前上传文件的文件名称
                    String fileName = file.getOriginalFilename();
                    // 如果名称不为空,说明该文件存在，否则说明该文件不存在
                    if (fileName.trim() != "") {
                        File newFile = new File(fileName);
                        FileOutputStream outStream = new FileOutputStream(newFile); // 文件输出流用于将数据写入文件
                        outStream.write(file.getBytes());
                        outStream.close(); // 关闭文件输出流
                        file.transferTo(newFile);
                        // 上传到阿里云
                        files.add(AliOSSUtil.upload(accessKeyId, secret, newFile, bucketName, fileHost, null));
                        newFile.delete();
                    }
                }
            }
        }
        //上传失败提示
        if (files.isEmpty()) {
            resultModel.setErrorDesc("系统异常,上传图片失败");
            resultModel.setReturnValue(null);
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(files);
        return resultModel;
    }


    /**
     * 获取券可复制的素材
     * @param ticketKeyword
     * @return
     */
    @RequestMapping(value = "/getTicketAssetsCopyList", method = RequestMethod.GET)
    public ResultModel getTicketAssetsCopyList(@RequestParam("ticketKeyword") String ticketKeyword) {
        try {
            ResultModel resultModel = new ResultModel();
            List<TicketAssetsCopyListVo> vos =
                    adTicketAssetsTemplateAssetsService.getTicketAssetsCopyList(ticketKeyword);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(vos);
            return resultModel;
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("服务器错误");
        }
    }


    /**
     * 复制券下的所有素材 到指定券
     * @param copyTicketId
     * @param targetTicketId
     * @param ids
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/copyTicketAssets", keyName = "素材模板素材复制")
    @RequestMapping(value = "/copyTicketAssets", method = RequestMethod.GET)
    public ResultModel copyTicketAssets(@RequestParam("copyTicketId") Long copyTicketId,
                                        @RequestParam("targetTicketId") Long targetTicketId,
                                        @RequestParam(value = "ids", required = false) List<Long> ids,
                                        HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        List<String> tips = new ArrayList<>();
        try {
            List<Long> assetIds = adTicketAssetsTemplateAssetsService.copyTicketAssets(copyTicketId, targetTicketId,
                    ids, user, tips, null);
            if (CollectionUtils.isNotEmpty(assetIds)) {
                for (Long assetId : assetIds) {
                    afterHandle(user, targetTicketId, assetId);
                }
            }
            //根据券id推送数据到prod
            prodService.pushAdTicketToProdPre(targetTicketId);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("复制失败");
        }
        boolean hasSuccess = tips.size() < ids.size();
        if (hasSuccess) {
            return ResultModelFactory.SUCCESS(StringUtils.join(tips, CommonConstant.BaseCharacter.COMMA + "\n"));
        } else {
            return ResultModelFactory.FAIL400(StringUtils.join(tips, CommonConstant.BaseCharacter.COMMA + "\n"));
        }
    }

    /**
     * 提交素材到oppo审核
     *
     * @param ids
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/submitToOppoAudit", keyName = "提交素材模板素材到oppo审核")
    @RequestMapping(value = "/submitToOppoAudit", method = RequestMethod.POST)
    public ResultModel submitToOppoAudit(@RequestParam(value = "ids", required = false) List<Long> ids,
                                        HttpServletRequest request, HttpServletResponse response) {
        if (ids.size() > 30) {
            return ResultModelFactory.FAIL500("最多提交30个素材");
        }
        User user = getUser(request, response);
        try {
            String auditMessage = adTicketAssetsTemplateAssetsService.submitToAdxAudit(PanguAdxEnum.OPPO, ids, user);
            if (StringUtils.isNotBlank(auditMessage)) {
                return ResultModelFactory.FAIL400(auditMessage);
            }
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("操作失败");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 提交素材到美团审核
     *
     * @param ids
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/submitToMeiTuanAudit", keyName = "提交素材模板素材到美团审核")
    @RequestMapping(value = "/submitToMeiTuanAudit", method = RequestMethod.POST)
    public ResultModel submitToMeiTuanAudit(@RequestParam(value = "ids", required = false) List<Long> ids,
                                         HttpServletRequest request, HttpServletResponse response) {
        if (ids.size() > 30) {
            return ResultModelFactory.FAIL500("最多提交30个素材");
        }
        User user = getUser(request, response);
        try {
            String auditMessage = adTicketAssetsTemplateAssetsService.submitToAdxAudit(PanguAdxEnum.MEI_TUAN, ids, user);
            if (StringUtils.isNotBlank(auditMessage)) {
                return ResultModelFactory.FAIL400(auditMessage);
            }
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("操作失败");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 同步券下的素材 到指定券
     *
     * @return
     */
    @LogBefore(operType = "/adAssetsTemplateAssets/syncTicketAssets", keyName = "素材模板素材同步")
    @RequestMapping(value = "/syncTicketAssets", method = RequestMethod.GET)
    public ResultModel syncTicketAssets(@RequestParam("copyTicketId") Long copyTicketId,
                                        @RequestParam("targetTicketIds") String targetTicketIds,
                                        @RequestParam(value = "ids", required = false) List<Long> ids,
                                        HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        String[] targetTicketArray = targetTicketIds.split(",");

        List<String> assetsTips = new ArrayList<>();
        Map<String, HashSet<String>> existDuplicateTicketMap = new HashMap<>();

        List<String> ticketMessage = new ArrayList();
        boolean hasSuccess = false;
        try {
            for (String targetTicketId : targetTicketArray) {
                if (doCopy(copyTicketId, Long.parseLong(targetTicketId), ids, user, assetsTips, existDuplicateTicketMap)) {
                    hasSuccess = true;
                }
            }
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("操作失败");
        }


        // 处理重复的提示
        if (MapUtils.isNotEmpty(existDuplicateTicketMap)) {
            existDuplicateTicketMap.forEach((assetsId, ticketIds) -> {
                String join = StringUtils.join(ticketIds);
                ticketMessage.add(String.format("%s在券%s中已存在", assetsId, join));
            });
        }
        String duplicateMessage = "";
        duplicateMessage += StringUtils.join(ticketMessage, ",");
        if (CollectionUtils.isNotEmpty(assetsTips)) {
            duplicateMessage += ";\n " + StringUtils.join(assetsTips, ",\n");
        }
        // 有成功的记录就返回success  没有一条成功就返回400
        if (hasSuccess) {
            return ResultModelFactory.SUCCESS(duplicateMessage.replace("，请勿重复添加", ""));
        } else {
            return ResultModelFactory.FAIL400(duplicateMessage.replace("，请勿重复添加", ""));
        }
    }

    private boolean doCopy(Long copyTicketId, Long targetTicketId, List<Long> ids, User user, List<String> tips, Map<String, HashSet<String>> ticketTips) throws Exception{
        List<Long> assetIds = adTicketAssetsTemplateAssetsService.copyTicketAssets(copyTicketId, targetTicketId,
                ids, user, tips, ticketTips);
        if (CollectionUtils.isNotEmpty(assetIds)) {
            for (Long assetId : assetIds) {
                afterHandle(user, targetTicketId, assetId);
            }
        }
        prodService.pushAdTicketToProdPre(targetTicketId);
        return CollectionUtils.isNotEmpty(assetIds);
    }


    ///**
    // * 订正老数据
    // * @param request
    // * @param response
    // * @return
    // */
    //@RequestMapping(value = "/updateOldData", method = RequestMethod.GET)
    //public ResultModel updateOldData(HttpServletRequest request, HttpServletResponse response) {
    //    try {
    //        adTicketAssetsTemplateAssetsService.updateOldData();
    //    } catch (BusinessException e) {
    //        return ResultModelFactory.FAIL500(e.getMessage());
    //    } catch (Exception e) {
    //        LOGGER.error(e.getMessage(), e);
    //        return ResultModelFactory.FAIL500("操作失败");
    //    }
    //    return ResultModelFactory.SUCCESS();
    //}

    /**
     * 获取素材填充率
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/findAssetsFillRate", method = RequestMethod.GET)
    public ResultModel findAssetsFillRate(@RequestParam("ticketId") Long ticketId,
                                     HttpServletRequest request, HttpServletResponse response) {
        try {
            return ResultModelFactory.SUCCESS(adTicketAssetsTemplateAssetsService.findAssetsFillRate(ticketId));
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("获取素材填充率失败:" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("获取素材填充率失败");
        }
    }
}
