package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplate;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateSearchDTO;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateVO;
import com.bxm.adsmanager.service.adkeeper.AdAssetsTemplateService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 素材模板.</br>
 * Created by zhengwangeng on 2021/6/15
 */
@RestController
@RequestMapping("/adAssetsTemplate")
public class AdAssetsTemplateController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsTemplateController.class);

    @Autowired
    private AdAssetsTemplateService adAssetsTemplateService;

    /**
     * 新增素材模板
     * @param dto
     * @return
     */
    @LogBefore(operType="/adAssetsTemplate/add",keyName="素材模板新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(@Validated @RequestBody AdAssetsTemplateDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        dto.setCreateUser(user.getUsername());
        return ResultModelFactory.SUCCESS(adAssetsTemplateService.add(dto));
    }

    /**
     * 修改状态
     * @param id
     * @param status
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType="/adAssetsTemplate/updateStatus",keyName="素材模板状态修改")
    @RequestMapping(value = "/updateStatus", method = RequestMethod.PUT)
    public ResultModel updateStatus(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Long id,
                                    @NotNull(message = "状态不能为空！") @RequestParam(value = "status") Short status,
                                    HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            adAssetsTemplateService.updateStatus(id, status, user.getUsername());
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 查找素材模板(激活),这里没有做分页处理
     *
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel findAll() {
        ResultModel<List> rs = new ResultModel();
        try {
            AdAssetsTemplateSearchDTO searchDTO = new AdAssetsTemplateSearchDTO();
            searchDTO.setStatus(CommonConstant.StatusType.STATUS_ACTIVATE);
            searchDTO.setPageNum(1);
            searchDTO.setPageSize(Integer.MAX_VALUE);
            PageInfo<AdAssetsTemplate> pageInfo = adAssetsTemplateService.findPage(searchDTO);
            if (pageInfo != null) {
                rs.setSuccessed(true);
            }
            List list = pageInfo.getList();
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("获取数据为空");
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("查找素材模板出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找素材模板出错");
        }
        return rs;
    }

    /**
     * 查找券定向的广告位上配置的模板列表
     * 选择模版时，数字展示为该券下素材列表中未删除的使用该模版的素材数量
     * @return
     */
    @RequestMapping(value = "/findAllByTicketPositionAssociations", method = RequestMethod.GET)
    public ResultModel findAllByTicketPositionAssociations(@NotNull(message = "券Id不能为空！") @RequestParam(value = "ticketId") Long ticketId) {
        ResultModel<List> rs = new ResultModel();
        try {
            List list = adAssetsTemplateService.findAllByTicketPositionAssociations(ticketId);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("获取数据为空");
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("查找素材模板出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找素材模板出错");
        }
        return rs;
    }

    /**
     * 根据条件查询所有素材模板
     *
     * @param request
     * @param response
     * @param searchDTO
     * @return
     */
    @RequestMapping(value = "/findAllByParams", method = RequestMethod.GET)
    public ResultModel<PageInfo> findAllByParams(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsTemplateSearchDTO searchDTO) {
        ResultModel<PageInfo> rs = new ResultModel<>();
        try {
            PageInfo<AdAssetsTemplate> page = adAssetsTemplateService.findPage(searchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(page);
        } catch (Exception e) {
            LOGGER.error("根据条件查找素材模板出错" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据条件查找素材模板出错");
        }
        return rs;
    }

    /**
     * 查询模板所有关联的广告位信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/findAssociationsPositionList", method = RequestMethod.GET)
    public ResultModel<List<AppEntranceAdRO>> findAssociationsPositionList(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Long id) {
        ResultModel<List<AppEntranceAdRO>> rs = new ResultModel<>();
        try {
            List<AppEntranceAdRO> list = adAssetsTemplateService.findAssociationsPositionList(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("根据条件查找素材模板出错" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据条件查找素材模板出错");
        }
        return rs;
    }

    /**
     * 获取模板详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/get", method = RequestMethod.GET)
    public ResultModel<AdAssetsTemplateVO> get(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Long id) {
        ResultModel<AdAssetsTemplateVO> rs = new ResultModel<>();
        try {
            AdAssetsTemplateVO adAssetsTemplateVo = adAssetsTemplateService.get(id);
            if (adAssetsTemplateVo != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(adAssetsTemplateVo);
        } catch (Exception e) {
            LOGGER.error("根据条件查找素材模板出错" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据条件查找素材模板出错");
        }
        return rs;
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @LogBefore(operType="/adAssetsTemplate/delete",keyName="素材模板删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResultModel delete(Long id) {
        try {
            adAssetsTemplateService.delete(id);
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("删除素材模板出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("该人群包已被广告使用，无法删除。");
        }
    }
}
