package com.bxm.adsmanager.web.controller.adkeeper;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdGetuiLabelService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <h3>个推标签</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/12 15:00
 */
@RequestMapping("/adGetuiLabel")
@RestController
public class AdGetuiLabelController {

	private static final Logger LOGGER = LoggerFactory.getLogger(AdGetuiLabelController.class);

	@Autowired
	private AdGetuiLabelService adGetuiLabelService;


	/**
	 * @description 个推标签查询
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response,
										   BaseDto baseDto) {

		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {
			Pagination result = adGetuiLabelService.findAll(baseDto);
			if(result!=null){
				rs.setReturnValue(result);
				rs.setSuccessed(true);
			}
		}catch (Exception e){
			LOGGER.error("个推标签查询错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("个推标签查询错误");
		}
		return  rs;
	}

}
