package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.adkeeper.AdPositionAssetSize;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdPositionAssetSizeDto;
import com.bxm.adsmanager.model.dto.AdPositionAssetSizeSearchDto;
import com.bxm.adsmanager.model.vo.AdPositionAssetSizeVo;
import com.bxm.adsmanager.service.adkeeper.AdPositionAssetSizeService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 广告位尺寸.</br>
 * @author zhengwangeng
 * @date 2019年05月17日下午03:08:28
 */
@RestController
@RequestMapping("/adPositionAssetSize")
public class AdPositionAssetSizeController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionAssetSizeController.class);

	@Autowired
	private AdPositionAssetSizeService adPositionAssetSizeService;

	@LogBefore(operType = "/adPositionAssetSize/add", keyName = "广告位素材尺寸添加")
	@RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
	public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdPositionAssetSizeDto adPositionAssetSizeDto) {
		try {
			//参数校验
			if (BeanValidator.validateGroup(adPositionAssetSizeDto, AdPositionAssetSizeDto.Add.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adPositionAssetSizeDto, AdPositionAssetSizeDto.Add.class).getMessage());
			}
			User user = getUser(request, response);
			Long positionAssetSizeId = adPositionAssetSizeService.add(adPositionAssetSizeDto, user.getUsername());

			return ResultModelFactory.SUCCESS(positionAssetSizeId);
		} catch (Exception e) {
			LOGGER.error("添加广告位素材尺寸出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加广告位素材尺寸出错");
		}
	}

	@LogBefore(operType = "/adPositionAssetSize/update", keyName = "广告位素材尺寸更新")
	@RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
	public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdPositionAssetSizeDto adPositionAssetSizeDto) {
		ResultModel rs = new ResultModel();
		if (adPositionAssetSizeDto == null || adPositionAssetSizeDto.getId() == null) {
			return ResultModelFactory.FAIL400("广告位素材尺寸id不能为空");
		}

		try {
			//参数校验
			if (BeanValidator.validateGroup(adPositionAssetSizeDto, AdPositionAssetSizeDto.Update.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adPositionAssetSizeDto, AdPositionAssetSizeDto.Update.class).getMessage());
			}
			User user = getUser(request, response);
            Integer result = adPositionAssetSizeService.update(adPositionAssetSizeDto, user.getUsername());
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("更新广告位素材尺寸出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告位素材尺寸出错");
		}
		return rs;
	}

	/**
	 * 查找广告位素材尺寸
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/find", method = RequestMethod.GET)
	public ResultModel<AdPositionAssetSizeVo> find(Long id) {
		ResultModel<AdPositionAssetSizeVo> rs = new ResultModel<>();
		if (id == null) {
			return ResultModelFactory.FAIL400("广告位素材尺寸id不能为空");
		}
		try {
			AdPositionAssetSizeVo result = adPositionAssetSizeService.findById(id);
			rs.setReturnValue(result);
		} catch (ValidateException v) {
			LOGGER.error(v.getMessage(), v);
			return ResultModelFactory.FAIL400(v.getMessage());
		} catch (Exception e) {
			LOGGER.error("查找广告位素材尺寸出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找广告位素材尺寸出错");
		}
		return rs;
	}

	/**
	 * 获取启用的所有广告位素材尺寸信息
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/findAllByActivate", method = RequestMethod.GET)
	public ResultModel<List<AdPositionAssetSizeVo>> findBykeywords(HttpServletRequest request, HttpServletResponse response) {
		ResultModel<List<AdPositionAssetSizeVo>> rs = new ResultModel<>();
		try {
			List<AdPositionAssetSizeVo> result = adPositionAssetSizeService.findAllByActive();
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找广告位素材尺寸出错" + e.getMessage(), e);
			rs.setErrorDesc(e.getMessage());
		}
		return rs;
	}

	/**
	 * 查找所有广告位素材尺寸
	 * @param searchDto
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<PageInfo<AdPositionAssetSizeVo>> findAll(AdPositionAssetSizeSearchDto searchDto, HttpServletRequest request,
										 HttpServletResponse response) {
		ResultModel<PageInfo<AdPositionAssetSizeVo>> rs = new ResultModel<>();

		try {
			PageInfo<AdPositionAssetSizeVo> result = adPositionAssetSizeService.findAll(searchDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找所有广告位素材尺寸出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找所有广告位素材尺寸出错");
		}
		return rs;
	}


	/**
	 * 更新状态
	 * @param request
	 * @param response
	 * @param id
	 * @param status
	 * @return
	 */
	@LogBefore(operType = "/adPositionAssetSize/updateStatus", keyName = "广告位素材尺寸状态更新")
	@RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id") Long id,
							  @RequestParam(required = true, name = "status") Short status) {
		//状态。0 停用、1 启用
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			User user = getUser(request, response);
			AdPositionAssetSizeDto adPositionAssetSizeDto = new AdPositionAssetSizeDto();
			adPositionAssetSizeDto.setId(id.intValue());
			adPositionAssetSizeDto.setStatus(status);
			Object result = adPositionAssetSizeService.updateStatus(adPositionAssetSizeDto, user.getUsername());
			//日志记录
			addLogs(user, JSON.toJSONString(AdPositionAssetSize.AdPositionAssetSizeStatus.getName(status) + "广告位素材尺寸"), String.valueOf(id));

			rs.setReturnValue(result);
		} catch (ValidateException v) {
			return ResultModelFactory.FAIL400(v.getMessage());
		} catch (Exception e) {
			LOGGER.error("更新广告位素材尺寸状态出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告位素材尺寸状态出错");
		}
		return rs;
	}
}