package com.bxm.adsmanager.web.controller.adkeeper;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.utils.*;
import com.bxm.commons.currency.Money;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsInfo;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dao.adkeeper.TblAdTicketModify;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdFlowPackageNewDto;
import com.bxm.adsmanager.model.dto.AdTicketCheckDto;
import com.bxm.adsmanager.model.dto.AdTicketCheckInfokDto;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageAddBatchDto;
import com.bxm.adsmanager.model.dto.AdTicketPositionAddBatchDto;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.enums.AdxPriceTypeEnum;
import com.bxm.adsmanager.model.enums.PageTypeEnum;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.AdTicketAppEntranceVo;
import com.bxm.adsmanager.model.vo.AdTicketPositionTimesLimitConfigVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.PaginationTemp;
import com.bxm.adsmanager.service.adflowpackage.AdFlowPackageService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsCouponsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.TblAdTicketModifyService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.DateHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @author hcmony
 * @Created 2017-12-07 16:04:00
 * @Description
 */
@RestController
@RequestMapping("/adTicket")
public class AdTicketController extends BaseController{

	private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketController.class);
	private final Map<Integer,String> ticketModifyUsers = Maps.newConcurrentMap();

	@Autowired
	private AdTicketService adTicketService;
	@Autowired
	private AdShopIntegration adShopIntegration;
	@Autowired
	private TblAdTicketModifyService tblAdTicketModifyService;
	@Autowired
	private AdTicketAssetsService adTicketAssetsService;
	@Autowired
	private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
	@Autowired
	private AdTicketAssetsCouponsService adTicketAssetsCouponsService;
	@Autowired
	private AdFlowPackageService adFlowPackageService;

	@Autowired
	private JedisUpdater jedisUpdater;

	/**
	 * @description 添加广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType = "/adTicket/add", keyName = "广告")
	@RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
	public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketDto adTicketDto) {
		try {
			//校验券的相关参数配置
			ResultModel resultModel = validateTicketConfig(adTicketDto, AdTicketDto.Add.class);
			if (resultModel != null) {
				return resultModel;
			}
			//增加是否需要审核的判断
/*			String checkFlag = adTicketService.getIsCheck();
			if (StringUtils.isNotBlank(checkFlag) && checkFlag.length() != 9 && "1".equals(checkFlag)) {
				//设置待审核状态
				adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
			}*/
            // 20200623新版本不再需要判断全局开关 除了adx的券 其他都要审核
            if (AdTicket.AdTicketType.isNotAdx(adTicketDto.getType())) {
                adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
            }

			User user = getUser(request, response);
			if (StringUtil.isBlank(adTicketDto.getAe())) {
				adTicketDto.setAe(user.getUsername());
			}
			Long ticketId = adTicketService.add(adTicketDto, user.getUsername());
			try {
				if (ticketId != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())) {
					jedisUpdater.hupdate(RedisKeys.getPddTickets(), String.valueOf(ticketId), adTicketDto.getAdvertiser());
				}
			} catch (Exception e) {
				LOGGER.error("券入Redis失败:" + e.getMessage(), e);
			}
			AdTicketVo adTicketVo = adTicketService.findById(ticketId);
			if (adTicketVo.getStatus() == AdTicket.WAIT_AUDIT) {
				//嵌入链接测试表数据
				AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
				adTicketUrlTest.setTicketId(ticketId);
				adTicketUrlTest.setActionType((short) 0);
				adTicketUrlTest.setDealStatus((short) 0);
				adTicketUrlTest.setCreateTime(new Date());
				adTicketUrlTest.setModifyTime(new Date());
				adTicketService.addTicketUrlTest(adTicketUrlTest);
			}
//			if (StringUtils.isNotBlank(checkFlag) && checkFlag.length() != 9) {
			try {
				//添加日志diysite
				tblAdTicketModifyService.addLog(adTicketDto);
			} catch (Exception e) {
				LOGGER.error("新增广告券操作日志失败");
				e.printStackTrace();
			}
			//日志记录
			addLogs(user, "新增：" + JSON.toJSONString(adTicketDto), String.valueOf(ticketId));

			//自动审核券
			afterHandle(ticketId);
			return ResultModelFactory.SUCCESS(ticketId);
		} catch (PushProdException p) {
			LOGGER.error("添加广告券出错:" + p.getMessage(), p);
			return ResultModelFactory.FAIL500("推送数据到前端异常");
		} catch (Exception e) {
			LOGGER.error("添加广告券出错:" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加广告券出错");
		}
	}

	/**
	 * 新增和编辑券时的参数检查校验
	 * @param adTicketDto
	 * @param classz
	 * @return
	 */
	private ResultModel validateTicketConfig(AdTicketDto adTicketDto, Class classz) {
		//基础参数校验
		if (BeanValidator.validateGroup(adTicketDto, classz) != null) {
			return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketDto, classz).getMessage());
		}

		try {
			Double budgetDailyDouble = adTicketDto.getBudgetDaily();
			Short settleType = adTicketDto.getSettleType();
			TicketUtil.checkBudgetDaily(budgetDailyDouble, settleType);
		} catch (ValidateException e) {
			return ResultModelFactory.FAIL400(e.getMessage());
		}

		//各种类型券的相关参数校验
		AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType(adTicketDto.getType());
		if (adTicketType == null) {
			return ResultModelFactory.FAIL400("广告券类型非法！");
		}
		if (AdTicket.AdTicketType.isNotAdx(adTicketDto.getType())) {
			ResultModel resultModel = validateTicketAppExtendArgs(adTicketDto);
			if (null != resultModel) {
				return resultModel;
			}
		}
		ResultModel resultModel = null;
		switch (adTicketType) {
			case TYPE_NORMALS:
			case TYPE_STANDBYS:
			case TYPE_PUSH:
				//【常规券、备用券】根据素材id判断有没有开启的不禁用弹窗的素材
//				if (StringUtils.isNotBlank(adTicketDto.getAssetsids()) && adTicketAssetsService.findAssetsByAssetIds(adTicketDto.getAssetsids())) {
//					resultModel = ResultModelFactory.FAIL400("必须有一张开启状态的不限弹窗的素材图！");
//				}
				break;
			case TYPE_ENCOURAGE:
				//激励券不处理，不需要校验参数
				break;
			case TYPE_DSP:
				break;
			case TYPE_RTA:
				break;
			case TYPE_COUPON:
				//【券码类】票券需要额外的参数校验
				resultModel = validateCouponsArgs(adTicketDto);
				break;
			case TYPE_ADX_DIRECT:
			case TYPE_ADX_INTERACT:
				//【ADX直投，ADX互动】验证逻辑
				resultModel = validateAdxArgs(adTicketDto);
				break;
			case TYPE_INSPIRE_VIDEO:
			case TYPE_INSPIRE_VIDEO_STANDBYS:
				//【激励视频,激励视频备用券】验证逻辑
//				resultModel = validateInspireVideoArgs(adTicketDto);
				break;
			case TYPE_ACTIVITY:
			case TYPE_DIRECT:
				resultModel = validateActivityAndDirectArgs(adTicketDto);
				break;
			default:
				return ResultModelFactory.FAIL400("未处理的广告券类型！");
		}
		if (resultModel != null) {
			return resultModel;
		}

		//额外的验证
		//ADX广告券在新增的时候要校验落地页是否包含特定参数
		if (AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) {
			if (AdTicketDto.Add.class == classz) {
				if (adTicketDto.getUrl().contains(CommonConstant.ADX_TICKET_URL_ARGS_NAME)) {
					return ResultModelFactory.FAIL400("落地页不能存在" + CommonConstant.ADX_TICKET_URL_ARGS_NAME + "参数！");
				}
			}
		}

		//流量控制校验，广告位配置和流量包配置只能存在一个，否则后续保存会有问题
		////TODO flowPackageArray前端有可能传递过来的是字符串"[]"
		//if ((StringUtils.isNotBlank(adTicketDto.getFlowPackageArray()) && adTicketDto.getFlowPackageArray().length() > 2)
		//		&& StringUtils.isNotBlank(adTicketDto.getPositionTimesLimitConfig())) {
		//	return ResultModelFactory.FAIL400("流量控制：广告位配置和流量包配置只能存在一个！");
		//}
		if (StringUtils.isNotBlank(adTicketDto.getPositionTimesLimitConfig())) {
			//校验时间是否有重合的
			List<AdTicketPositionTimesLimitConfigVo> adTicketPositionTimesLimitConfigVos =
					JSON.parseArray(adTicketDto.getPositionTimesLimitConfig(), AdTicketPositionTimesLimitConfigVo.class);
			ArrayList<String> dateString = new ArrayList<>();
			for (AdTicketPositionTimesLimitConfigVo adTicketPositionTimesLimitConfigVo :
					adTicketPositionTimesLimitConfigVos) {
				if (adTicketPositionTimesLimitConfigVo.getStartHour() > adTicketPositionTimesLimitConfigVo.getEndHour()){
					return ResultModelFactory.FAIL400("开始的时间必须小于结束时间。");
				}
				dateString.add(adTicketPositionTimesLimitConfigVo.getStartHour() + CommonConstant.BaseCharacter.BAR
						+ adTicketPositionTimesLimitConfigVo.getEndHour());
			}
			List<String> errorList = DateUtils.validatedDateOverlap(dateString, CommonConstant.BaseCharacter.BAR, "HH");
			if (CollectionUtils.isNotEmpty(errorList)) {
				return ResultModelFactory.FAIL400(errorList.toString());
			}
		}
		return null;
	}

	private ResultModel validateAdxArgs(AdTicketDto adTicketDto) {
		AdTicketDto.AdxConfDto adxConfDto = adTicketDto.getAdxConfDto();
		if(adxConfDto == null) {
            return ResultModelFactory.FAIL400("ADX配置信息不能为空！");
        }
		if(adxConfDto.getClickMaximum() == null && adxConfDto.getShowMaximum() == null) {
            return ResultModelFactory.FAIL400("每日最多曝光次数,每日最多点击次数必须填写其中一项！");
        }
		if(adxConfDto.getSpeed() == null) {
            //投放速度：1- 加速投放、2- 匀速投放
            return ResultModelFactory.FAIL400("投放速度必须填写！");
        }
		if(StringUtils.isBlank(adTicketDto.getAdxConfDto().getAssetsAdxArray())) {
			return ResultModelFactory.FAIL400("广告位素材必须填写！");
		}
		return null;
	}

	private ResultModel validateInspireVideoArgs(AdTicketDto adTicketDto) {
		AdTicketDto.InspireVideoConfDto inspireVideoConfDto = adTicketDto.getInspireVideoConfDto();
		if(inspireVideoConfDto == null) {
            return ResultModelFactory.FAIL400("激励视频配置信息不能为空！");
        }
		if(inspireVideoConfDto.getPageType() == null) {
			return ResultModelFactory.FAIL400("落地页类型必须填写！");
		}
		if(StringUtils.isBlank(inspireVideoConfDto.getAssetsInspireVideoArray())) {
			return ResultModelFactory.FAIL400("广告位素材必须填写！");
		}
		return null;
	}

    private ResultModel validateTicketAppExtendArgs(AdTicketDto adTicketDto) {
        AdTicketDto.TicketAppExtendDto ticketAppExtendDto = adTicketDto.getTicketAppExtendDto();
        if(ticketAppExtendDto == null) {
            return ResultModelFactory.FAIL400("ticketAppExtendDto配置信息不能为空！");
        }
        if(ticketAppExtendDto.getPageType() == null) {
            return ResultModelFactory.FAIL400("落地页类型必须填写！");
        }
        if(ticketAppExtendDto.getAppPackageRate() == null) {
            return ResultModelFactory.FAIL400("appPackageRate必须填写！");
        }
        return null;
    }

    private ResultModel validateActivityAndDirectArgs(AdTicketDto adTicketDto) {
        AdTicketDto.TicketAppExtendDto ticketAppExtendDto = adTicketDto.getTicketAppExtendDto();
        if(ticketAppExtendDto == null) {
            return ResultModelFactory.FAIL400("ticketAppExtendDto配置信息不能为空！");
        }
        if(StringUtils.isBlank(ticketAppExtendDto.getBdTags())) {
            return ResultModelFactory.FAIL400("百度BES广告标签类型必须填写！");
        }
        if(ticketAppExtendDto.getAdxBudgetDaily() == null) {
            return ResultModelFactory.FAIL400("ADX成本日预算必须填写！");
        }
		if (AdTicket.AdTicketType.TYPE_ADX_DIRECT.getType() == adTicketDto.getType()) {
			if (StringUtils.isBlank(ticketAppExtendDto.getLandingPageEndJumpUrl())) {
				return ResultModelFactory.FAIL400("落地页最后一跳地址必须填写！");
			}
		}
        Double adxPrice = ticketAppExtendDto.getAdxPrice();
        if(adxPrice == null) {
            return ResultModelFactory.FAIL400("ADX CPM成本必须填写！");
        }

        // 校验adx出价
        // adx出价类型是cpc时，出价范围是0-0.3 。 针对特定用户放开限制到0-0.5
        if (Objects.equals(AdxPriceTypeEnum.CPC.getType(), ticketAppExtendDto.getAdxPriceType())) {
            if (RequestUtils.isAdxPriceLimitUserName()) {
                if (adxPrice <= 0 || adxPrice > 0.5) {
                    return ResultModelFactory.FAIL400("adx出价请输入大于0且不大于0.5的数字，最多支持两位小数");
                }
            }
            else {
                if (adxPrice <= 0 || adxPrice > 0.3) {
                    return ResultModelFactory.FAIL400("adx出价请输入大于0且不大于0.3的数字，最多支持两位小数");
                }
            }
        }

        return null;
    }

	private ResultModel validateCouponsArgs(AdTicketDto adTicketDto) {
		if(StringUtils.isBlank(adTicketDto.getAssetscouponsids())) {
            return ResultModelFactory.FAIL400("票券码票券素材不能为空！");
        }

		AdTicketDto.CouponsInfoDto couponsInfoDto = adTicketDto.getCouponsInfoDto();
		if(couponsInfoDto == null) {
            return ResultModelFactory.FAIL400("票券码基本信息不能为空！");
        }
		if(couponsInfoDto.getUseType() == null) {
            //票券使用类型，0单次唯一码，1多次唯一码，2限时码，3限量码
            return ResultModelFactory.FAIL400("票券码票券使用类型不能为空！");
        }
		if(StringUtils.isBlank(couponsInfoDto.getContent())) {
            return ResultModelFactory.FAIL400("票券码票券礼包内容不能为空！");
        }
		if(StringUtils.isBlank(couponsInfoDto.getIntro())) {
            return ResultModelFactory.FAIL400("票券码票券礼包兑换方式说明不能为空！");
        }
		if(StringUtils.isBlank(couponsInfoDto.getPackageName())) {
            return ResultModelFactory.FAIL400("票券码票券下载安装包的AppID/包名不能为空！");
        }

        AdTicketCouponsInfo.AdCouponsUseType adCouponsUseType = AdTicketCouponsInfo.AdCouponsUseType.getByType(couponsInfoDto.getUseType());
        if (adCouponsUseType == null) {
            return ResultModelFactory.FAIL400("票券使用类型非法！");
        }

        switch (adCouponsUseType) {
            case USETYPE_SINGLE:
            	//0单次唯一码
                break;
            case USETYPE_MULTIPLE:
            	//1多次唯一码
                break;
            case USETYPE_LIMITED_TIME:
            	//2限时码
                if(StringUtils.isBlank(couponsInfoDto.getCode())) {
                    return ResultModelFactory.FAIL400("票券码不能为空！");
                }
                if(couponsInfoDto.getCodeStartTime() == null || couponsInfoDto.getCodeEndTime() == null) {
                    return ResultModelFactory.FAIL400("票券码票券开始使用时间和结束使用时间不能为空！");
                }
                if(couponsInfoDto.getCodeStartTime().getTime() >= couponsInfoDto.getCodeEndTime().getTime()) {
                    return ResultModelFactory.FAIL400("票券码票券开始使用时间必须小于结束使用时间！");
                }
                break;
            case USETYPE_LIMITED_NUM:
            	//3限量码
                if(StringUtils.isBlank(couponsInfoDto.getCode())) {
                    return ResultModelFactory.FAIL400("票券码不能为空！");
                }
                if(couponsInfoDto.getCodeLimitNum() == null || couponsInfoDto.getCodeLimitNum() < 1) {
                    return ResultModelFactory.FAIL400("票券码票券限制使用数不能为空且必须大于0！");
                }
                break;
            default:
                return ResultModelFactory.FAIL400("未处理的票券使用类型！");

        }

		//广告位定向校验
		AdTicketDto.ControlDto controlDto = adTicketDto.getControlDto();
		List<AppEntranceAdRO> appEntranceAdRos = null;
		if (StringUtil.isBlank(controlDto.getBanners())) {
			//如果为空，则前端设置的是"不限"
            //查询所有开启券码投放的广告位
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            Byte couponsPutinFlag = 1;
            paramDTO.setCouponsPutinFlag(couponsPutinFlag);
            appEntranceAdRos = newAppEntranceFacadeIntegration.getAllList(paramDTO);
        }else {
            String[] bannersArray = controlDto.getBanners().split(",");
			if(bannersArray.length > 0){
				//第一个的格式是：黑白名单-广告位ID
				//第二个及以后的是格式是：广告位ID
				bannersArray[0] = bannersArray[0].substring(bannersArray[0].indexOf("-") + 1);
			}
            List<String> positionIds = Arrays.asList(bannersArray);

            //广告位定向 先调用查询所有的广告位接口，传参数type=类型。1- 白名单、2- 黑名单position=广告位ID
            if (controlDto.getBanners().startsWith(CommonConstant.Rule.POSITION_WHITE_PREFIX)) {
            	//1- 白名单
                //查询券所对应的广告位
                QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
                paramDTO.setPositionIds(positionIds);
                appEntranceAdRos = newAppEntranceFacadeIntegration.getAllList(paramDTO);
            } else if(controlDto.getBanners().startsWith(CommonConstant.Rule.POSITION_BLACK_PREFIX)) {
            	//2- 黑名单
                //查询券所对应的广告位
                QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
                paramDTO.setPositionIds(positionIds);
				//这是黑名单的
				List<AppEntranceAdRO> appEntranceAdRosTemp = newAppEntranceFacadeIntegration.getAllList(paramDTO);
                //剩下的广告位
                paramDTO = new QueryAppEntranceParamDTO();
				//排除黑名单，剩下的就是需要校验的
				paramDTO.setNotInIds(appEntranceAdRosTemp.stream().map(AppEntranceAdRO::getId).collect(Collectors.toList()));
                appEntranceAdRos = newAppEntranceFacadeIntegration.getAllList(paramDTO);
            } else {
				return ResultModelFactory.FAIL400("广告位定向配置非法！");
			}
        }
		if(CollectionUtils.isEmpty(appEntranceAdRos)){
            //广告
            return ResultModelFactory.FAIL400("没有找到开启券码投放的广告位！");
        }
		//广告位定向需要判断的广告位素材的Id
		Set<Long> appEntranceCouponsSizeIds = new HashSet<>();
		for (AppEntranceAdRO appEntranceAdRo : appEntranceAdRos) {
            appEntranceCouponsSizeIds.add(appEntranceAdRo.getCouponsIconSize());
            appEntranceCouponsSizeIds.add(appEntranceAdRo.getCouponsCreativeSize());
        }

		List<AdAssetsCoupons> assetsCoupons = adTicketAssetsCouponsService.findByIds(adTicketDto.getAssetscouponsids());
		//所有广告位素材的Id
		List<Long> assetsCouponsSizeIds = new ArrayList<>();
		for (AdAssetsCoupons assetsCoupon : assetsCoupons) {
			if(assetsCoupon.getStatus() == CommonConstant.StatusType.STATUS_ACTIVATE){
				//获得所有活跃的
				assetsCouponsSizeIds.add(assetsCoupon.getPositionAssetSizeId());
			}
		}
		if(assetsCouponsSizeIds.containsAll(appEntranceCouponsSizeIds) == Boolean.FALSE){
            return ResultModelFactory.FAIL400("券码投放的广告位素材尺寸必须全部添加对应的素材！");
        }
		return null;
	}

	//新的日志记录-记录券价格变化
	private void addTicketModifyLogs(User user, AdTicketDto adTicketDto){
		try {
			StringBuffer log = new StringBuffer();
			//出价判断
			Double oldPrice = adTicketDto.getOldPrice();
			Double price = adTicketDto.getPrice();
			if(oldPrice != null && price != null){
				String oldPriceStr = String.valueOf(oldPrice);
				String priceStr = String.valueOf(price);
				if(!oldPriceStr.equals(priceStr)){
					log.append("出价从").append(oldPriceStr).append("调整为").append(priceStr).append(";");
				}
			}
			//预期CPA判断
			AdTicketDto.OcpcConfDto ocpcConf = adTicketDto.getOcpcConf();
			if (null != ocpcConf) {
				Double cpaExpectPrice = ocpcConf.getCpaExpectPrice();
				Double oldCpaPrice = ocpcConf.getOldCpaPrice();
				if(cpaExpectPrice != null && oldCpaPrice != null){
					String cpaExpectPriceStr = String.valueOf(cpaExpectPrice);
					String oldCpaPriceStr = String.valueOf(oldCpaPrice);
					if(!cpaExpectPriceStr.equals(oldCpaPriceStr)){
						log.append("预期cpa从").append(oldCpaPriceStr).append("调整为").append(cpaExpectPriceStr).append(";");
					}
				}
			}
			//流量包出价判断
			//流量包->出价和限额
			if(StringUtil.isNotEmpty(adTicketDto.getFlowPackageArray())){
				List<AdFlowPackageNewDto> packages = null;
				packages = JSON.parseArray(adTicketDto.getFlowPackageArray(),AdFlowPackageNewDto.class);
				if(CollectionUtils.isNotEmpty(packages)){
					for(AdFlowPackageNewDto record : packages){
						String oldPackagePrice = record.getOldPrice();
						String newPackagePrice = record.getPrice();
						if(StringUtils.isNotBlank(oldPackagePrice) && StringUtils.isNotBlank(newPackagePrice) &&
								!oldPackagePrice.equals(newPackagePrice)){
							log.append("流量包：").append(record.getPackageName()).append("出价从").append(oldPackagePrice).append("调整为").append(newPackagePrice).append(";");
						}
					}
				}
			}
			String logStr = log.toString();
			//入MongoDB
			if(StringUtils.isNotBlank(logStr)){
				addNewLogs(user,"编辑：" + logStr , String.valueOf(adTicketDto.getId()));
			}
		} catch (Exception e) {
			LOGGER.error("券操作日志入库出错"+e.getMessage(), e);
		}
	}

	/**
	 * 全新客户化日志记录
	 * 背景：现有的操作日志运营看不懂
	 * 范围：常规券、直投广告、活动广告
	 * 券编辑若触发以下修改展示按照以下模版，以下的操作日志为新增信息，不改变现有的操作日志内容
	 * @param user
	 * @param adTicketDto
	 * @param adTicket
	 * @throws Exception
	 */
	private void addTicketModifyLogs(User user, AdTicketDto adTicketDto, AdTicket adTicket) throws Exception {
        //范围：常规券、直投广告、活动广告
        List<Short> needAddLogTicketType = Arrays.asList(AdTicket.AdTicketType.TYPE_NORMALS.getType(),
                AdTicket.AdTicketType.TYPE_DIRECT.getType(), AdTicket.AdTicketType.TYPE_ACTIVITY.getType());
        if (needAddLogTicketType.contains(adTicket.getType()) == false) {
            return;
        }
        boolean isNewAdx = AdTicket.AdTicketType.isNewAdx(adTicket.getType());

        AdTicketVo adTicketVo = adTicketService.findById(adTicket.getId());
        //1、落地页修改
        //* 落地页从网页/下载类xxxxxxxxxxxxURL修改成网页/下载类xxxxxxxxxxxxURL
        {
            int compare = NumberUtils.compare(adTicketDto.getTicketAppExtendDto().getPageType(),
                    adTicketVo.getTicketAppExtendVo().getPageType());
            boolean urlEqual = StringUtils.equals(adTicketDto.getUrl(), adTicket.getUrl());
            if (compare != 0 || !urlEqual) {
                PageTypeEnum newType = PageTypeEnum.getByType(adTicketDto.getTicketAppExtendDto().getPageType());
                PageTypeEnum oldType = PageTypeEnum.getByType(adTicketVo.getTicketAppExtendVo().getPageType());
                // 日志系统记录日志
                addLogs(user, "落地页从" + oldType.getDesc() + adTicket.getUrl() + "修改成 " + newType.getDesc() + adTicketDto.getUrl(), adTicket.getId().toString());
            }
        }

        //2、Deeplink的修改
        //* Deeplink从xxxxxxx修改成xxxxxxxxxx（若Deeplinlk从无到有或从有到无的修改xxx展示为无，如：Deeplink从无修改成xxxxxxxxxx 或Deeplink从xxxxxxx修改成无）
        {
            String newJumpUrl = adTicketDto.getTicketAppExtendDto().getJumpUrl();
            String oldJumpUrl = adTicketVo.getTicketAppExtendVo().getJumpUrl();
            boolean jumpUrlEqual = StringUtils.equals(newJumpUrl, oldJumpUrl);
            if (!jumpUrlEqual) {
                String content = null;
                if (StringUtils.isNoneBlank(newJumpUrl, oldJumpUrl)) {
                    //都有值
                    content = "Deeplink从" + oldJumpUrl + "修改成" + newJumpUrl;
                } else if (StringUtils.isBlank(oldJumpUrl)) {
                    content = "Deeplink从无修改成" + newJumpUrl;
                } else {
                    content = "Deeplink从" + oldJumpUrl + "修改成无";
                }
                addLogs(user, content, adTicket.getId().toString());
            }
        }

        //* 3、ADX出价修改
        //* ADX出价从cpc0.01元修改成cpm3元（展示修改前后的ADX出价类型和出价）
        if (isNewAdx) {
            Short newAdxPriceType = adTicketDto.getTicketAppExtendDto().getAdxPriceType();
            Short oldAdxPriceType = adTicketVo.getTicketAppExtendVo().getAdxPriceType();
            Double newAdxPrice = adTicketDto.getTicketAppExtendDto().getAdxPrice();
            Double oldAdxPrice = adTicketVo.getTicketAppExtendVo().getAdxPrice();
            int adxPriceTypeCompare = NumberUtils.compare(newAdxPriceType, oldAdxPriceType);

            BigDecimal data1 = new BigDecimal(newAdxPrice.toString());
            BigDecimal data2 = new BigDecimal(oldAdxPrice.toString());
            if (data1.compareTo(data2) != 0 || adxPriceTypeCompare != 0) {
                AdxPriceTypeEnum newAdxPriceTypeEnum = AdxPriceTypeEnum.getByType(newAdxPriceType);
                AdxPriceTypeEnum oldAdxPriceTypeEnum = AdxPriceTypeEnum.getByType(oldAdxPriceType);
                addLogs(user, "ADX出价从" + oldAdxPriceTypeEnum.getDesc() + oldAdxPrice + "元修改成" + newAdxPriceTypeEnum.getDesc() + newAdxPrice + "元", adTicket.getId().toString());
            }
        }

        //* 4、百度标签定向修改
        //* 百度标签从白名单：xxxxxxx黑名单：xxxxxxxx修改成白名单：xxxxxxx黑名单：xxxxxxxx
        if (isNewAdx) {
            String newBdTagsOrientatio = StringUtils.defaultIfBlank(adTicketDto.getTicketAppExtendDto().getBdTagsOrientation(), StringUtils.EMPTY);
            String oldBdTagsOrientatio = StringUtils.defaultIfBlank(adTicketVo.getTicketAppExtendVo().getBdTagsOrientation(), StringUtils.EMPTY);
            boolean bdTagsOrientatioEqual = StringUtils.equals(newBdTagsOrientatio, oldBdTagsOrientatio);
            if (!bdTagsOrientatioEqual) {
                String[] newBdTagsOrientatioArray = newBdTagsOrientatio.split("&");
                String[] oldBdTagsOrientatioArray = oldBdTagsOrientatio.split("&");

                String newWhitelistTag = "";
                String newBlacklistTag = "";
                String oldWhitelistTag = "";
                String oldBlacklistTag = "";
                if (newBdTagsOrientatioArray.length == 1) {
                    newWhitelistTag = newBdTagsOrientatioArray[0];
                } else if (newBdTagsOrientatioArray.length == 2) {
                    newWhitelistTag = newBdTagsOrientatioArray[0];
                    newBlacklistTag = newBdTagsOrientatioArray[1];
                }

                if (oldBdTagsOrientatioArray.length == 1) {
                    oldWhitelistTag = oldBdTagsOrientatioArray[0];
                } else if (oldBdTagsOrientatioArray.length == 2) {
                    oldWhitelistTag = oldBdTagsOrientatioArray[0];
                    oldBlacklistTag = oldBdTagsOrientatioArray[1];
                }
                if (!newWhitelistTag.equals(oldBlacklistTag)) {
                    String content = String.format("百度标签从白名单：%s黑名单：%s修改成白名单：%s黑名单：%s", oldWhitelistTag, oldBlacklistTag, newWhitelistTag, newBlacklistTag);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }

        //* 5、RTA定向修改
        //* RTA定向从否修改成淘宝 100989
        {
            Integer oldRta = adTicketVo.getTicketAppExtendVo().getRta();
            Integer newRta = adTicketDto.getTicketAppExtendDto().getRta();
            String oldRtaParam = StringUtils.defaultIfBlank(adTicketVo.getTicketAppExtendVo().getRtaParam(), StringUtils.EMPTY);
            String newRtaParam = StringUtils.defaultIfBlank(adTicketDto.getTicketAppExtendDto().getRtaParam(), StringUtils.EMPTY);
            if (!Objects.equals(newRta, oldRta) || !oldRtaParam.equals(newRtaParam)) {
                String oldRtaStr = "";
                String newRtaStr = "";
                if (oldRta == null) {
                    oldRtaStr = "否";
                    oldRtaParam = "";
                } else {
                    oldRtaStr = String.valueOf(oldRta);
                    oldRtaParam = " RTA广告ID" + oldRtaParam;
                }

                if (newRta == null) {
                    newRtaStr = "否";
                    newRtaParam = "";
                } else {
                    newRtaStr = String.valueOf(newRta);
                    newRtaParam = " RTA广告ID" + newRtaParam;
                }
                String content = "RTA定向从" + oldRtaStr + oldRtaParam + "修改成RTA定向" + newRtaStr + newRtaParam;
                addLogs(user, content, adTicket.getId().toString());
            }
        }

        //* 6、频次控制修改
        //* 频次控制从每人每x天曝光不超过x次，每人每x天点击不超过x次修改成每人每x天曝光不超过x次，每人每x天点击不超过x次
        // （若修改成不限展示为：每人每x天曝光不超过x次，每人每x天点击不超过x次修改成不限）
        {
            String oldFrequencys = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getFrequencys(), StringUtils.EMPTY);
            String newFrequencys = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getFrequencys(), StringUtils.EMPTY);
            boolean frequencysEqual = StringUtils.equals(oldFrequencys, newFrequencys);
            if (!frequencysEqual) {
                String oldFrequencysDesc = "";
                String newFrequencysDesc = "";

                if (StringUtils.isBlank(oldFrequencys)) {
                    oldFrequencysDesc = "不限";
                } else {
                    oldFrequencysDesc = getFrequencysDesc(oldFrequencys);
                }
                if (StringUtils.isBlank(newFrequencys)) {
                    newFrequencysDesc = "不限";
                } else {
                    newFrequencysDesc = getFrequencysDesc(newFrequencys);
                }
                if (!oldFrequencysDesc.equals(newFrequencysDesc)) {
                    String content = String.format("频次控制从%s修改成%s", oldFrequencysDesc, newFrequencysDesc);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }

        //* 7、已安装APP包名定向修改
        //* 已安装APP包名定向从不限修改为白名单taobao.com未获取到App列表时投放配率0%
        {
            String oldAppPackageRule = StringUtils.defaultIfBlank(adTicketVo.getTicketAppExtendVo().getAppPackageRule(), StringUtils.EMPTY);
            String newAppPackageRule = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getAppPackageRule(), StringUtils.EMPTY);
            Integer oldAppPackageRate = adTicketVo.getTicketAppExtendVo().getAppPackageRate();
            Integer newAppPackageRate = adTicketDto.getTicketAppExtendDto().getAppPackageRate();
            boolean appPackageRuleEqual = StringUtils.equals(oldAppPackageRule, newAppPackageRule);
            if (!appPackageRuleEqual || !Objects.equals(oldAppPackageRate, newAppPackageRate)) {
                String oldAppPackageRuleDesc = "";
                String newAppPackageRuleDesc = "";
                String noDeliveryRateDesc = "未获取到App列表时投放配率";

                //2-123   1白，2黑 123为包名
                if (StringUtils.isBlank(oldAppPackageRule)) {
                    oldAppPackageRuleDesc = "不限";
                } else {
                    String rate = oldAppPackageRate == null ? StringUtils.EMPTY : String.valueOf(oldAppPackageRate);
                    oldAppPackageRuleDesc = getAppPackageRuleDesc(oldAppPackageRule, noDeliveryRateDesc, rate);
                }
                if (StringUtils.isBlank(newAppPackageRule)) {
                    newAppPackageRuleDesc = "不限";
                } else {
                    String rate = newAppPackageRate == null ? StringUtils.EMPTY : String.valueOf(newAppPackageRate);
                    newAppPackageRuleDesc = getAppPackageRuleDesc(newAppPackageRule, noDeliveryRateDesc, rate);
                }
                if (!oldAppPackageRuleDesc.equals(newAppPackageRuleDesc)) {
                    String content = String.format("已安装APP包名定向从%s修改成%s", oldAppPackageRuleDesc, newAppPackageRuleDesc);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }

        //* 8、媒体app包名定向修改
        //* 媒体app包名定向从白名单taobao.com未获取到App列表时投放配率0%修改成黑名单taobao.com未获取到App列表时投放配率0%
        if (isNewAdx) {
            String oldMediaAppPackageRule = StringUtils.defaultIfBlank(adTicketVo.getTicketAppExtendVo().getMediaAppPackageRule(), StringUtils.EMPTY);
            String newMediaAppPackageRule = StringUtils.defaultIfBlank(adTicketDto.getTicketAppExtendDto().getMediaAppPackageRule(), StringUtils.EMPTY);
            Integer oldMediaAppPackageRate = adTicketVo.getTicketAppExtendVo().getMediaAppPackageRate();
            Integer newMediaAppPackageRate = adTicketDto.getTicketAppExtendDto().getMediaAppPackageRate();
            boolean mediaAppPackageRuleEqual = StringUtils.equals(oldMediaAppPackageRule, newMediaAppPackageRule);
            if (!mediaAppPackageRuleEqual || !Objects.equals(oldMediaAppPackageRate, newMediaAppPackageRate)) {
                String oldMediaAppPackageRuleDesc = "";
                String newMediaAppPackageRuleDesc = "";
                String noDeliveryRateDesc = "未获取到App列表时投放配率";

                //2-123   1白，2黑 123为包名
                if (StringUtils.isBlank(oldMediaAppPackageRule)) {
                    oldMediaAppPackageRuleDesc = "不限";
                } else {
                    String rate = oldMediaAppPackageRate == null ? StringUtils.EMPTY : String.valueOf(oldMediaAppPackageRate);
                    oldMediaAppPackageRuleDesc = getAppPackageRuleDesc(oldMediaAppPackageRule, noDeliveryRateDesc, rate);
                }
                if (StringUtils.isBlank(newMediaAppPackageRule)) {
                    newMediaAppPackageRuleDesc = "不限";
                } else {
                    String rate = newMediaAppPackageRate == null ? StringUtils.EMPTY : String.valueOf(newMediaAppPackageRate);
                    newMediaAppPackageRuleDesc = getAppPackageRuleDesc(newMediaAppPackageRule, noDeliveryRateDesc, rate);
                }
                if (!oldMediaAppPackageRuleDesc.equals(newMediaAppPackageRuleDesc)) {
                    String content = String.format("媒体app包名定向从%s修改成%s", oldMediaAppPackageRuleDesc, newMediaAppPackageRuleDesc);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }

        //* 9、ADX App ID 定向
        //* 同上
        if (isNewAdx) {
            String oldAdxAppIdRule = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getAdxAppIdRule(), StringUtils.EMPTY);
            String newAdxAppIdRule = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getAdxAppIdRule(), StringUtils.EMPTY);
            Integer oldAdxAppIdRate = adTicketVo.getTicketAppExtendVo().getAdxAppIdRate();
            Integer newAdxAppIdRate = adTicketDto.getTicketAppExtendDto().getAdxAppIdRate();
            boolean adxAppIdRuleEqual = StringUtils.equals(oldAdxAppIdRule, newAdxAppIdRule);
            if (!adxAppIdRuleEqual || !Objects.equals(oldAdxAppIdRate, newAdxAppIdRate)) {
                String oldAdxAppIdRuleDesc = "";
                String newAdxAppIdRuleDesc = "";
                String noDeliveryRateDesc = "无 App ID 投放配率";

                //2-123   1白，2黑 123为包名
                if (StringUtils.isBlank(oldAdxAppIdRule)) {
                    oldAdxAppIdRuleDesc = "不限";
                } else {
                    String rate = oldAdxAppIdRate == null ? StringUtils.EMPTY : String.valueOf(oldAdxAppIdRate);
                    oldAdxAppIdRuleDesc = getAppPackageRuleDesc(oldAdxAppIdRule, noDeliveryRateDesc, rate);
                }
                if (StringUtils.isBlank(newAdxAppIdRule)) {
                    newAdxAppIdRuleDesc = "不限";
                } else {
                    String rate = newAdxAppIdRate == null ? StringUtils.EMPTY : String.valueOf(newAdxAppIdRate);
                    newAdxAppIdRuleDesc = getAppPackageRuleDesc(newAdxAppIdRule, noDeliveryRateDesc, String.valueOf(adTicketDto.getTicketAppExtendDto().getAdxAppIdRate()));
                }
                if (!oldAdxAppIdRuleDesc.equals(newAdxAppIdRuleDesc)) {
                    String content = String.format("ADX App ID 定向从%s修改成%s", oldAdxAppIdRuleDesc, newAdxAppIdRuleDesc);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }

        //* 10、投放日期修改
        //* 投放日期从xxxxxxx修改成xxxxxxx
        String oldValidDate = DateUtil.dateTo8String(adTicketVo.getValidStartDate()) + "-" + DateUtil.dateTo8String(adTicketVo.getValidEndDate());
        String newValidDate = DateUtil.dateTo8String(adTicketDto.getValidStartDate()) + "-" + DateUtil.dateTo8String(adTicketDto.getValidEndDate());
        boolean validDateEqual = StringUtils.equals(oldValidDate, newValidDate);
        if (!validDateEqual) {
            String content = String.format("投放日期从%s修改成%s", oldValidDate, newValidDate);
            addLogs(user, content, adTicket.getId().toString());
        }

        //* 11、投放时段预算修改
        //* 投放时段预算从300元10:00～12:00 200元13:00～15:00修改成全部时段
        // 0-1-10000.0,1-24-20000.0
        {
            String newTimes = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getTimes(), StringUtils.EMPTY);
            ;
            String oldTimes = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getTimes(), StringUtils.EMPTY);
            ;
            boolean timesEqual = StringUtils.equals(newTimes, oldTimes);
            if (!timesEqual) {
                String oldTimesDesc = "";
                String newTimesDesc = "";
                String unit = adTicket.getSettleType().intValue() == 2 ? "张" : "元";

                //2-123   1白，2黑 123为包名
                if (StringUtils.isBlank(oldTimes)) {
                    oldTimesDesc = "全部时段";
                } else {
                    oldTimesDesc = getTimesDesc(oldTimes, unit);
                }
                if (StringUtils.isBlank(newTimes)) {
                    newTimesDesc = "全部时段";
                } else {
                    newTimesDesc = getTimesDesc(newTimes, unit);
                }
                if (!oldTimesDesc.equals(newTimesDesc)) {
                    String content = String.format("投放时段预算从%s修改成%s", oldTimesDesc, newTimesDesc);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }

        //* 12、绑定广告组修改
        //* 绑定广告组从否修改成美团频控
        {
            Long oldGroupId = adTicketVo.getGroupId();
            Long newGroupId = adTicketDto.getGroupId();
            if (!Objects.equals(newGroupId, oldGroupId)) {
                String oldStr = oldGroupId == null ? "否" : String.valueOf(oldGroupId);
                String newStr = newGroupId == null ? "否" : String.valueOf(newGroupId);
                addLogs(user, "绑定广告组从" + oldStr + "修改成" + newStr, adTicket.getId().toString());
            }
        }

        //* 手机品牌定向
        //* 手机品牌从不限改为xxxxx
        if (isNewAdx) {
            String oldPhoneBrand = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getPhoneBrand(), StringUtils.EMPTY);
            String newPhoneBrand = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getPhoneBrand(), StringUtils.EMPTY);

            String oldPhoneBrandDesc = "";
            String newPhoneBrandDesc = "";

            if (!Objects.equals(oldPhoneBrand, newPhoneBrand)) {
                String[] oldPhoneBrandArray = oldPhoneBrand.split("-");
                String[] newPhoneBrandArray = newPhoneBrand.split("-");
                Set<String> oldBrandSet = Collections.EMPTY_SET;
                Set<String> newBrandSet = Collections.EMPTY_SET;
                if (oldPhoneBrandArray.length == 1) {
                    oldBrandSet = Sets.newHashSet(oldPhoneBrandArray[0]);
                    oldPhoneBrandDesc = "不限";
                } else if (oldPhoneBrandArray.length == 2) {
                    oldPhoneBrandDesc = CommonConstant.PhoneBrandType.getNamesByTypes(oldPhoneBrandArray[1]);
                    oldBrandSet = Sets.newHashSet(oldPhoneBrandArray[1].split(","));
                }
                if (newPhoneBrandArray.length == 1) {
                    newPhoneBrandDesc = "不限";
                    newBrandSet = Sets.newHashSet(newPhoneBrandArray[0]);
                } else if (newPhoneBrandArray.length == 2) {
                    newPhoneBrandDesc = CommonConstant.PhoneBrandType.getNamesByTypes(newPhoneBrandArray[1]);
                    String newBrand = newPhoneBrandArray[1];
                    newBrandSet = Sets.newHashSet(newBrand.split(","));
                }

                if (!SetUtils.isEqualSet(oldBrandSet, newBrandSet)) {
                    addLogs(user, "手机品牌从" + oldPhoneBrandDesc + "修改成" + newPhoneBrandDesc, adTicket.getId().toString());
                }
            }
        }

        //* 网络类型
        //* 网络类型从不限改为xxxxx；
        {
            String oldNetworkType = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getNetworkType(), StringUtils.EMPTY);
            String newNetworkType = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getNetworkType(), StringUtils.EMPTY);
            if (!Objects.equals(oldNetworkType, newNetworkType)) {
                String[] oldNetworkArray = oldNetworkType.split("-");
                String[] newNetworkArray = newNetworkType.split("-");
                String oldNetworkDesc = "";
                String newNetworkDesc = "";
                if (oldNetworkArray.length == 1) {
                    oldNetworkDesc = "不限";
                } else if (oldNetworkArray.length == 2) {
                    oldNetworkDesc = CommonConstant.NetworkType.getNamesByTypes(oldNetworkArray[1]);
                }
                if (newNetworkArray.length == 1) {
                    newNetworkDesc = "不限";
                } else if (newNetworkArray.length == 2) {
                    newNetworkDesc = CommonConstant.NetworkType.getNamesByTypes(newNetworkArray[1]);
                }
                if (!Objects.equals(oldNetworkDesc, newNetworkDesc)) {
                    addLogs(user, "网络类型从" + oldNetworkDesc + "改为" + newNetworkDesc, adTicket.getId().toString());
                }
            }

        }

        //* 广告位修改
        //* 广告位定向从不限改为xxxxx；
        {
            String oldPosition = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getBanners(), StringUtils.EMPTY);
            String newPosition = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getBanners(), StringUtils.EMPTY);
            if (!Objects.equals(oldPosition, newPosition)) {
                String[] oldPositionArray = oldPosition.split("-");
                String[] newPositionArray = newPosition.split("-");
                String oldPositionDesc = "";
                String newPositionDesc = "";
                if (oldPositionArray.length == 1) {
                    oldPositionDesc = "不限";
                } else if (oldPositionArray.length > 1) {
                    oldPositionDesc = StringUtils.replace(oldPosition, "1-", "");
                }
                if (newPositionArray.length == 1) {
                    newPositionDesc = "不限";
                } else if (newPositionArray.length > 1) {
                    newPositionDesc = StringUtils.replace(newPosition, "1-", "");
                }
                if (!Objects.equals(oldPositionDesc, newPositionDesc)) {
                    addLogs(user, "广告位定向从 " + oldPositionDesc + "\r\n修改成\r\n" + newPositionDesc, adTicket.getId().toString());
                }
            }
        }

        //* 人群包定向修改
        //* 白名单：xxxxxxx黑名单：xxxxxxxx修改成白名单：xxxxxxx黑名单：xxxxxxxx
        {
            String oldCrowdPackage = StringUtils.defaultIfBlank(adTicketVo.getTicketAppExtendVo().getCrowdPackageOrientation(), StringUtils.EMPTY);
            String newCrowdPackage = StringUtils.defaultIfBlank(adTicketDto.getTicketAppExtendDto().getCrowdPackageOrientation(), StringUtils.EMPTY);
            if (!Objects.equals(oldCrowdPackage, newCrowdPackage)) {
                String[] oldCrowdPackageArray = oldCrowdPackage.split("&");
                String[] newCrowdPackageArray = newCrowdPackage.split("&");
                String oldWhiteCrowdPackageDesc = "";
                String oldBlackCrowdPackageDesc = "";
                String newWhiteCrowdPackageDesc = "";
                String newBlackCrowdPackageDesc = "";
                if (oldCrowdPackageArray.length == 2) {
                    oldWhiteCrowdPackageDesc = oldCrowdPackageArray[0];
                    oldBlackCrowdPackageDesc = oldCrowdPackageArray[1];
                }
                if (newCrowdPackageArray.length == 2) {
                    newWhiteCrowdPackageDesc = newCrowdPackageArray[0];
                    newBlackCrowdPackageDesc = newCrowdPackageArray[1];
                }
                if (!Objects.equals(oldBlackCrowdPackageDesc, newBlackCrowdPackageDesc) || !Objects.equals(oldWhiteCrowdPackageDesc, newWhiteCrowdPackageDesc)) {
                    addLogs(user, "人群包定向从白名单：" + oldWhiteCrowdPackageDesc + " 黑名单：" + oldBlackCrowdPackageDesc
                            + " 修改成" + "白名单：" + newWhiteCrowdPackageDesc + " 黑名单：" + newBlackCrowdPackageDesc, adTicket.getId().toString());
                }
            }
        }

        //* AppId包定向修改
        //* ADX AppID包定向从不限修改为白名单xxxxx
        if (isNewAdx) {
            String oldAppIdPackage = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getAppIdPackage(), StringUtils.EMPTY);
            String newAppIdPackage = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getAppIdPackage(), StringUtils.EMPTY);
            if (!Objects.equals(oldAppIdPackage, newAppIdPackage)) {
                String[] oldAppIdPackageArray = oldAppIdPackage.split("-");
                String[] newAppIdPackageArray = newAppIdPackage.split("-");
                String oldAppIdPackageDesc = "";
                String newAppIdPackageDesc = "";
                String oldBlackOrWhiteDesc = "";
                String newBlackOrWhiteDesc = "";
                if (oldAppIdPackageArray.length == 1) {
                    oldAppIdPackageDesc = "不限";
                } else if (oldAppIdPackageArray.length == 2) {
                    oldBlackOrWhiteDesc = "1".equals(oldAppIdPackageArray[0]) ? "白名单" : "黑名单";
                    oldAppIdPackageDesc = oldAppIdPackageArray[1];
                }
                if (newAppIdPackageArray.length == 1) {
                    newAppIdPackageDesc = "不限";
                } else if (newAppIdPackageArray.length == 2) {
                    newBlackOrWhiteDesc = "1".equals(newAppIdPackageArray[0]) ? "白名单" : "黑名单";
                    newAppIdPackageDesc = newAppIdPackageArray[1];
                }
                addLogs(user, "ADX AppID包定向从" + oldBlackOrWhiteDesc + oldAppIdPackageDesc + " 修改成 " + newBlackOrWhiteDesc + newAppIdPackageDesc, adTicket.getId().toString());
            }
        }

        //* ADX投放时段预算修改
        //* ADX投放时段从300元10:00～12:00 200元13:00～15:00修改成全部时段
        // 0-1-10000.0,1-24-20000.0
        {
            String newTimes = StringUtils.defaultIfBlank(adTicketDto.getControlDto().getTimeBidding(), StringUtils.EMPTY);
            String oldTimes = StringUtils.defaultIfBlank(adTicketVo.getControlVo().getTimeBidding(), StringUtils.EMPTY);
            boolean timesEqual = StringUtils.equals(newTimes, oldTimes);
            if (!timesEqual) {
                String oldTimesDesc = "";
                String newTimesDesc = "";
                String unit = adTicket.getSettleType().intValue() == 2 ? "张" : "元";

                //2-123   1白，2黑 123为包名
                if (StringUtils.isBlank(oldTimes)) {
                    oldTimesDesc = "全部时段";
                } else {
                    oldTimesDesc = getTimesBiddingDesc(oldTimes, unit);
                }
                if (StringUtils.isBlank(newTimes)) {
                    newTimesDesc = "全部时段";
                } else {
                    newTimesDesc = getTimesBiddingDesc(newTimes, unit);
                }
                if (!oldTimesDesc.equals(newTimesDesc)) {
                    String content = String.format("ADX投放时段从%s修改成 %s", oldTimesDesc, newTimesDesc);
                    addLogs(user, content, adTicket.getId().toString());
                }
            }
        }
    }


	public static void test() {
        String oldTimes = "4-6-0-1.0,1-3-0-2";
        String newTimes = "";
        boolean timesEqual = StringUtils.equals(newTimes, oldTimes);
        if (!timesEqual) {
            String oldTimesDesc = "";
            String newTimesDesc = "";
            String unit = 1 == 2 ? "张" : "元";

            //2-123   1白，2黑 123为包名
            if (StringUtils.isBlank(oldTimes)) {
                oldTimesDesc = "全部时段";
            } else {
                oldTimesDesc = getTimesBiddingDesc(oldTimes, unit);
            }
            if (StringUtils.isBlank(newTimes)) {
                newTimesDesc = "全部时段";
            } else {
                newTimesDesc = getTimesBiddingDesc(newTimes, unit);
            }
            if (!oldTimesDesc.equals(newTimesDesc)) {
                String content = String.format("ADX投放时段从%s修改成%s", oldTimesDesc, newTimesDesc);
                System.out.println(content);
            }
        }
    }

    public static void main(String[] args) {
	    test();
    }

	//投放时段预算从300元10:00～12:00 200元13:00～15:00修改成全部时段
	private static String getTimesDesc(String times, String unit) {
		StringBuffer desc = new StringBuffer();
		String[] timesConfigArray = times.split(",");
		for (int i = 0; i < timesConfigArray.length; i++) {
			String[] signConfig = timesConfigArray[i].split("-");
			//0-1-10000.0,1-24-20000.0
			desc.append(signConfig[2]+ unit +signConfig[0]).append(":00～").append(signConfig[1]).append(":00～").append(" ");
		}
		if (desc.length() > 0) {
			desc.deleteCharAt(desc.length() - 2);
		}
		return desc.toString();
	}

    //投放时段预算从300元10:00～12:00 200元13:00～15:00修改成全部时段
    private static String getTimesBiddingDesc(String times, String unit) {
        StringBuffer desc = new StringBuffer();
        String[] timesConfigArray = times.split(",");
        for (int i = 0; i < timesConfigArray.length; i++) {
            String[] signConfig = timesConfigArray[i].split("-");
            //0-1-10000.0,1-24-20000.0
            desc.append("预算:" + signConfig[2]+ unit + " 出价:" + signConfig[3] + " " +signConfig[0]).append(":00～").append(signConfig[1]).append(":00～").append(" ");
        }
        if (desc.length() > 0) {
            desc.deleteCharAt(desc.length() - 2);
        }
        return desc.toString();
    }

	//已安装APP包名定向从 不限修改为白名单taobao.com未获取到App列表时投放配率0%
	private String getAppPackageRuleDesc(String appPackageRule, String noDeliveryRateDesc, String rate) {
		StringBuffer frequencysDesc = new StringBuffer();
		String[] frequencysConfigArray = appPackageRule.split("-");
		if (appPackageRule.startsWith("1")) {
			frequencysDesc.append("白名单");
		} else if (appPackageRule.startsWith("2")) {
			frequencysDesc.append("黑名单");
		}
		frequencysDesc.append(frequencysConfigArray[1]).append(noDeliveryRateDesc).append(rate).append("%");
		return frequencysDesc.toString();
	}

	private String getFrequencysDesc(String frequencys) {
		StringBuffer frequencysDesc = new StringBuffer();
		String[] frequencysConfigArray = frequencys.split(",");
		for (int i = 0; i < frequencysConfigArray.length; i++) {
			String[] frequencysSignConfig = frequencysConfigArray[i].split("-");
			//1-1-1000,2-2-2000,3-4-3000
			switch (frequencysSignConfig[1]) {
				case "1":
					//曝光
					frequencysDesc.append("每人每"+frequencysSignConfig[0]+"天曝光不超过"+frequencysSignConfig[2]).append("次,");
					break;
				case "2":
					//点击
					frequencysDesc.append("每人每"+frequencysSignConfig[0]+"天点击不超过"+frequencysSignConfig[2]).append("次,");
					break;
				case "3":
					//请求
					frequencysDesc.append("每人每"+frequencysSignConfig[0]+"天请求不超过"+frequencysSignConfig[2]).append("次,");
					break;
				case "4":
					//开屏请求
					frequencysDesc.append("每人每"+frequencysSignConfig[0]+"天开屏请求不超过"+frequencysSignConfig[2]).append("次,");
					break;
				case "5":
					//IP曝光
					frequencysDesc.append("每IP每"+frequencysSignConfig[0]+"天IP曝光不超过"+frequencysSignConfig[2]).append("次,");
					break;
				case "6":
					//IP点击
					frequencysDesc.append("每IP每"+frequencysSignConfig[0]+"天IP点击不超过"+frequencysSignConfig[2]).append("次,");
					break;
			}
		}
		if (frequencysDesc.length() > 0) {
			frequencysDesc.deleteCharAt(frequencysDesc.length() - 1);
		}
		return frequencysDesc.toString();
	}

	/**
	 * 新增、编辑券后自动审核券
	 * @param ticketId
	 * @throws Exception
	 */
	private void afterHandle(Long ticketId) throws Exception {
		//ADX券，加白的广告主，自动审核通过
		AdTicket adTicket = adTicketService.find(ticketId);
		if (AdTicket.AdTicketType.isNotNewAdx(adTicket.getType())) {
			return;
		}
		if (AdTicket.WAIT_AUDIT == adTicket.getStatus() || AdTicket.AUDIT_REJECTION == adTicket.getStatus()) {
			AdvertiserDto advertiserDto = adShopIntegration.findAdShopMsg(adTicket.getAdvertiser());
			if (AdvertiserDto.ASSET_AUDIT_STATUS_WHITE == advertiserDto.getAssetAuditWhiteStatus()) {
				// 模拟风控审核广告券通过
				AdTicketCheckInfokDto adTicketCheckInfokDto = adTicketService.getTicketInfoAndAssetsModify(ticketId);
				Integer status = 1;//风控审核通过
				String refuseReason = null;
				String tags = adTicketCheckInfokDto.getTags();
				String domainCode = adTicketCheckInfokDto.getDomainCode();
				Boolean success = adTicketService.ticketCheck(ticketId, status, refuseReason, tags, domainCode, "SYSTEM_AUDIT");
			}
		}
	}

	/**
	 * @description 更新广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType = "/adTicket/update", keyName = "广告")
	@RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
	public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdTicketDto adTicketDto) {
		try {
			if (adTicketDto == null || adTicketDto.getId() == null) {
				return ResultModelFactory.FAIL400("广告券id不能为空");
			}
			//广告主后台给定了默认值,修改的时候必须改
			if (StringUtils.isNotBlank(adTicketDto.getDomainCode()) && "-1".equals(adTicketDto.getDomainCode())) {
				return ResultModelFactory.FAIL400("广告分类不能为默认");
			}
			//校验券的相关参数配置
			ResultModel resultModel = validateTicketConfig(adTicketDto, AdTicketDto.Update.class);
			if (resultModel != null) {
				return resultModel;
			}

			List<AdTicket> adTickets = adTicketService.findByIds(String.valueOf(adTicketDto.getId()));
			if (CollectionUtils.isEmpty(adTickets)) {
				return ResultModelFactory.FAIL400("广告券不存在");
			}
			//记录当前券的状态
			AdTicket adTicket = adTickets.get(0);

			//修改时间判断
			if (adTicketDto.getModifyTime() != null){
				if (!"前端系统判断".equals(adTicket.getModifyUser()) && DateUtil.isAfter(adTicketDto.getModifyTime(), adTicket.getModifyTime())) {
					String msg = String.format("广告券已经被 %s 修改了，请刷新后再试。",
							adTicket.getModifyUser()
							//DateHelper.format(adTicket.getModifyTime(), "yyyy-MM-dd HH:mm:ss"),
							//DateHelper.format(adTicketDto.getModifyTime(), "yyyy-MM-dd HH:mm:ss")
					);
					return ResultModelFactory.FAIL400(msg);
				}
				////判断广告位定向中的流量包是否有修改
				//if (StringUtils.isNotBlank(adTicketDto.getFlowPackageIdArray())) {
				//	// 下面是流量包的控制
				//	List<Long> packageIds = JSON.parseArray(adTicketDto.getFlowPackageIdArray(), Long.class);
				//	Date maxModifyTime = adFlowPackageService.getMaxModifyTimeByIds(packageIds);
				//	if (DateUtil.isAfter(adTicketDto.getModifyTime(), maxModifyTime)) {
				//		return ResultModelFactory.FAIL400("广告位定向中的流量包已经有修改，请刷新后再试。");
				//	}
				//}
			}

			User user = getUser(request, response);
			if (!user.getRoleCodes().contains(RoleEnum.AELEADER.getCode())
					&& !adTicket.getAe().equals(user.getUsername()) && user.getRoleCodes().contains(RoleEnum.AE.getCode())) {
				return ResultModelFactory.FAIL400("你没有修改该券的权限");
			}

			//
//			final String userName = ticketModifyUsers.get(adTicketDto.getId());
//			if (StringUtils.isNotBlank(userName)){
//				return ResultModelFactory.FAIL400(userName +"正在修改该广告券,请稍后再提交");
//			}
//			ticketModifyUsers.put(adTicketDto.getId(),user.getUsername());

			//记录当前券状态大于0
			if (adTicket.getStatus() != null && adTicket.getStatus() > 0) {
				//此处判断如果是带启用状态的券 不存lastStatus
				if (!(adTicket.getStatus() == AdTicket.STATUS_CLOSE && adTicket.getLastStatus() <= 0)) {
					adTicketDto.setLastStatus(adTicket.getStatus());
					//暂停状态时获取库中的 暂停理由 再次设置进去防止置空
					if (adTicket.getStatus() == AdTicket.STATUS_PAUSE) {
						adTicketDto.setPauseReason(adTicket.getPauseReason());
					}
				}
			}
			if (adTicket.getStatus() != null && adTicket.getStatus() == AdTicket.WAIT_AUDIT) {
				adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
			}
            if (StringUtils.isNotBlank(adTicketDto.getUrl()) && !adTicket.getUrl().equals(adTicketDto.getUrl())) {
                // 日志系统记录日志
                addLogs(user, "券落地页从"+ adTicket.getUrl() + "修改成 " + adTicketDto.getUrl(), adTicket.getId().toString());
            }
			//增加是否需要审核的判断
            // 20200623新版本不在需要判断审核全局变量
//			String checkFlag = adTicketService.getIsCheck();
//			if (StringUtils.isNotBlank(checkFlag) && checkFlag.length() != 9 && "1".equals(checkFlag)) {

            // 修改时怎样才会进入审核？ 1.判断不是Adx券 2.判断券的属性标签（行业）有修改 3.判断券的属性标签中没有在行业审核中配置 且 落地页或素材有修改。 2和3其中有一条true就审核
            if (AdTicket.AdTicketType.isNotAdx(adTicketDto.getType())){
				//设置待审核状态
				if ( adTicketService.checkTagModify(adTicketDto.getId(), adTicketDto.getTags()) ||
                        (adTicketService.checkTagNeedAudit(adTicketDto.getId()) && adTicketService.checkTicketAssets(adTicketDto, adTicket, user))) {
					adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
					//根据券id查询是否存在记录  存在修改 不存在插入
					AdTicketUrlTest result = adTicketService.findTicketUrlTest(adTicketDto.getId().longValue());
					if (null == result) {
						//嵌入链接测试表数据
						AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
						adTicketUrlTest.setTicketId(adTicketDto.getId().longValue());
						adTicketUrlTest.setActionType((short) 1);
						adTicketUrlTest.setDealStatus((short) 0);
						adTicketUrlTest.setCreateTime(new Date());
						adTicketUrlTest.setModifyTime(new Date());
						adTicketService.addTicketUrlTest(adTicketUrlTest);
					} else {
						result.setModifyTime(new Date());
						result.setActionType((short) 1);
						result.setDealStatus((short) 0);
						adTicketService.updateTicketUrlTest(result);
					}
				} else {
					//如果是强制提交审核，且当前状态是审核拒绝时，则修改状态为待审核
					if (adTicket.getStatus() != null && adTicket.getStatus() == AdTicket.AUDIT_REJECTION) {
						if (adTicketDto.getResubmitReview()) {
							adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
						}
					}
					if (adTicket.getStatus() != null && adTicket.getStatus() == AdTicket.WAIT_OPTIMIZED) {
						adTicketDto.setStatus(AdTicket.STATUS_CLOSE);
					}
				}
			} else {
				if (adTicket.getStatus() != null && adTicket.getStatus() == AdTicket.WAIT_OPTIMIZED) {
					adTicketDto.setStatus(AdTicket.STATUS_CLOSE);
				}
			}
			try {
				addTicketModifyLogs(user, adTicketDto, adTicket);
			} catch (Exception e) {
				LOGGER.error("新日志记录失败:" + e.getMessage(), e);
			}
			Long ticketId = adTicketService.update(CommonConstant.Opera.Platform.ADSMANAGER, adTicketDto, user.getUsername());
			try {
				if (adTicketDto.getId() != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())) {
					jedisUpdater.hupdate(RedisKeys.getPddTickets(), String.valueOf(adTicketDto.getId()),
							adTicketDto.getAdvertiser());
				}
			} catch (Exception e) {
				LOGGER.error("券入Redis失败:" + e.getMessage(), e);
			}
			//日志记录
			addLogs(user, "编辑：" + JSON.toJSONString(adTicketDto), String.valueOf(adTicketDto.getId()));
			//新的日志记录-记录券价格变化
			addTicketModifyLogs(user, adTicketDto);
			//自动审核券
			afterHandle(ticketId);
			return ResultModelFactory.SUCCESS(ticketId);
		} catch (Exception e) {
			LOGGER.error("更新广告券出错:" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告券出错");
		}finally {
//			ticketModifyUsers.remove(adTicketDto.getId());
		}
	}

	/**
	 * @description 查找广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/find", method = RequestMethod.GET)
	public ResultModel<AdTicketVo> find(Long id) {
		if(id == null){
			return ResultModelFactory.FAIL400("广告券id不能为空");
		}
		try {
			AdTicketVo result = adTicketService.findById(id);
			LOGGER.info("查找广告券结果:"+JSON.toJSONString(result));
			ResultModel<AdTicketVo> rs = new ResultModel<>();
			rs.setReturnValue(result);
			return rs;
		}catch (ValidateException v){
			LOGGER.error(v.getMessage(), v);
			return ResultModelFactory.FAIL400(v.getMessage());
		}catch (Exception e){
			LOGGER.error("查找广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找广告券出错");
		}
	}

	/**
     * @description 查找广告券
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    @RequestMapping(value = "/findBykeywords", method = RequestMethod.GET)
    public ResultModel<List<AdTicketVo>> findBykeywords(AdTicketSearchDto condition) {
        ResultModel<List<AdTicketVo>> rs = new ResultModel<>();
        try {
            List<AdTicketVo> result = adTicketService.findBykeywords(condition);
            rs.setReturnValue(result);
        }catch (ValidateException v){
            LOGGER.error(v.getMessage(), v);
             rs.setErrorDesc(v.getMessage());
        }catch (Exception e){
            LOGGER.error("查找广告券出错"+e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }

	/**
	 * @description 删除广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/delete",keyName="广告")
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	public ResultModel delete(HttpServletRequest request, HttpServletResponse response, Long id) {
		if(id == null){
			return ResultModelFactory.FAIL400("广告券id不能为空");
		}
		try {
			User user = getUser(request,response);
			//查询券  判断是否有权限删除这个券
			List<AdTicket> adTickets = adTicketService.findByIds(String.valueOf(id));
			if(adTickets == null || adTickets.isEmpty()){
				return ResultModelFactory.FAIL500("广告券不存在");
			}
			AdTicket adTicket = adTickets.get(0);
			if(!user.getRoleCodes().contains(RoleEnum.AELEADER.getCode())
					&&!adTicket.getAe().equals(user.getUsername()) && user.getRoleCodes().contains(RoleEnum.AELEADER.getCode())){
				return ResultModelFactory.FAIL500("你没有删除该券的权限");
			}
			Integer result = adTicketService.delete(id,user.getUsername());
			//日志记录
			addLogs(user, JSON.toJSONString("删除广告券"),id+"");
			ResultModel rs = new ResultModel();
			rs.setReturnValue(result);
			return rs;
		}catch (Exception e){
			LOGGER.error("更新广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告券出错");
		}
	}

	/**
	 * @description 查找所有广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<PaginationTemp> findAll(AdTicketSearchDto searchDto,HttpServletRequest request,HttpServletResponse response) {
        if(StringUtils.isBlank(searchDto.getPvStartTime()) || StringUtils.isBlank(searchDto.getPvEndTime())){
            return ResultModelFactory.FAIL500("查询时间不能为空");
        }
		try {
        	User user = getUser(request,response);
			PaginationTemp<AdTicketAllVo> result = adTicketService.findAll(searchDto,user);
			ResultModel<PaginationTemp> rs = new ResultModel<>();
			rs.setReturnValue(result);
			return rs;
		}catch (Exception e){
			LOGGER.error("查找所有广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找所有广告券出错");
		}
	}


	/**
	 * 查询ADX券需要的票券包的券数据
	 * @param searchDto
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/findAdxTicketPackage", method = RequestMethod.GET)
	public ResultModel<PaginationTemp> findAdxTicketPackage(AdTicketSearchDto searchDto, HttpServletRequest request, HttpServletResponse response) {
		//前一天
		searchDto.setPvStartTime(DateUtil.dateTo8String(DateUtil.increaseDate(new Date(), -1)));
		searchDto.setPvEndTime(DateUtil.dateTo8String(DateUtil.increaseDate(new Date(), -1)));
		//查询已经存在的
		if (StringUtils.isNotBlank(searchDto.getTicketStrIds())) {
			List<Long> ticketIds = new ArrayList<>();
			String[] ticketStrIds = searchDto.getTicketStrIds().split(",");
			for (String ticketId : ticketStrIds) {
				ticketIds.add(Long.valueOf(ticketId));
			}
			searchDto.setTicketIds(ticketIds);
			searchDto.setTagCode(null);
		}
		ResultModel<PaginationTemp> rs = new ResultModel<>();
		try {
			User user = getUser(request,response);
			PaginationTemp result = adTicketService.findAdxTicketPackage(searchDto, user);
			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("查找所有ADX券需要的票券包的券数据出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找所有ADX券需要的票券包的券数据出错");
		}
		return rs;
	}

	/**
	 * @description 更新广告券状态
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/updateStatus",keyName="广告")
	@RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id") Long id,
							  @RequestParam(required = true, name = "status") Short status) {
		//状态。0 停止、1 正常、2 暂停、-1 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			User user = getUser(request,response);
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setModifyUser(getUser(request,response).getUsername());
			Object result = adTicketService.updateStatus(adTicket);
			//日志记录
			addLogs(user, JSON.toJSONString(AdTicket.AdTicketStatus.getName(status)+"广告券"),id+"");

			rs.setReturnValue(result);
		}catch (ValidateException v){
			return ResultModelFactory.FAIL400(v.getMessage());
		}catch (PushProdException e){
			return ResultModelFactory.FAIL500(e.getMessage());
		}catch (Exception e){
			LOGGER.error("更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告券状态出错");
		}
		return rs;
	}

	/**
	 * @description 获取广告主列表
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "queryAdvertiser", method = RequestMethod.GET)
	public ResultModel<Pagination> queryAdvertiser(HttpServletRequest request, HttpServletResponse response){
		ResultModel<Pagination> rs = new ResultModel<>();
		try {
			Map<String, Object> param = new HashMap<>(4);
			Integer pageNum = 1;
			Integer pageSize = 20;
			String pageNumStr = request.getParameter("pageNum");
			if(StringUtils.isNotBlank(pageNumStr)){
				pageNum=Integer.parseInt(pageNumStr);
			}
			String pageSizeStr = request.getParameter("pageSize");
			if(StringUtils.isNotBlank(pageSizeStr)){
				pageSize=Integer.parseInt(pageSizeStr);
			}
			param.put("pageNum", pageNum);
			param.put("pageSize",pageSize);
			if(StringUtils.isNotBlank(request.getParameter("id"))){
				param.put("id", request.getParameter("id"));
			}
			if(StringUtils.isNotBlank(request.getParameter("keywords"))){
				param.put("keywords", request.getParameter("keywords"));
			}
			Pagination pageBean = adShopIntegration.getAdvertiserPage(param);
			rs.setReturnValue(pageBean);
		} catch (Exception e) {
			LOGGER.error("获取广告主列表出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("获取广告主列表出错");
		}
		return rs;
	}

	/**
	 * 用缓存操作全局的券是否需要审核
	 *	isCheck 1-需要审核   0-不需要审核
	 * @CopyRright  (c) 2018-微财科技有限公司
	 * @author sunzhongshu
	 * @created 2018/7/2 14:25
	 * @modifier sunzhongshu
	 */
	@RequestMapping(value = "/isCheck")
	public ResultModel isCheck(@RequestParam(name = "isCheck",required = true) String isCheck){
		ResultModel resultModel = new ResultModel();
		resultModel.setReturnValue(adTicketService.isCheck(isCheck));
		return resultModel;
	}

	/**
	 * 用缓存操作全局的券是否需要审核
	 *	isCheck 1-需要审核   0-不需要审核
	 * @CopyRright  (c) 2018-微财科技有限公司
	 * @author sunzhongshu
	 * @created 2018/7/2 14:25
	 * @modifier sunzhongshu
	 */
	@RequestMapping(value = "/getIsCheck")
	public ResultModel getIsCheck(){
		ResultModel resultModel = new ResultModel();
		resultModel.setReturnValue(adTicketService.getIsCheck());
		return resultModel;
	}

	/**
	* 审核管理列表
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/2 19:00
	* @modifier sunzhongshu
	*/
	@RequestMapping(value = "/getList", method = RequestMethod.GET)
		public  ResultModel getList(@RequestParam(name = "keyWord") String keyWord,
									@RequestParam(name = "sale") String sale,
									@RequestParam(name = "ae") String ae,
									@RequestParam(name = "pageNum")Integer pageNum,
									@RequestParam(name = "pageSize")Integer pageSize){
		ResultModel resultModel = new ResultModel();
		Map<String,Object> map;
		try {
			map = adTicketService.getList(keyWord,sale,ae,pageNum,pageSize);
			resultModel.setReturnValue(map);
		} catch (Exception e) {
			LOGGER.error("查找审核列表出错"+e.getMessage(), e);
			e.printStackTrace();
		}
		return resultModel;
	}

	/**
	*  资质管理查询
	*  20180731修改--只查审核通过的资质信息
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/2 19:18
	* @modifier sunzhongshu
	*/
	@RequestMapping(value = "/getQualify")
	public ResultModel getQualify(@RequestParam(name = "advertiserId",required = true) Integer advertiserId){
		ResultModel resultModel = new ResultModel<>();
		resultModel.setReturnValue(adTicketService.findQualifyList(advertiserId));
		return resultModel;
	}

	/**
	* 广告主资质添加、修改
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/3 14:11
	* @modifier sunzhongshu
	*/
	@LogBefore(operType="/adTicket/updateQualify",keyName="添加、修改广告主资质")
	@RequestMapping(value = "/updateQualify",method = RequestMethod.POST)
	public ResultModel updateQualify(@RequestParam(name = "advertiserId") Integer advertiserId,
									 @RequestParam(name = "json") String json,
									 @RequestParam(name = "deleteIds")String deleteIds){
		ResultModel resultModel = new ResultModel<>();
		if (StringUtils.isBlank(json)){
			resultModel.setReturnValue("资质修改不能传空");
			resultModel.setSuccessed(false);
			return resultModel;
		}
		try {
		    List<TblAdQualify> list = JSON.parseArray(json,TblAdQualify.class);
            resultModel.setReturnValue(adTicketService.updateQualify(list,deleteIds,advertiserId));
        } catch (Exception e) {
            LOGGER.error("广告主修改资质信息出错"+e.getMessage(), e);
            resultModel.setReturnValue("广告主修改资质信息出错");
            resultModel.setSuccessed(false);
            return resultModel;
        }
		return resultModel;
	}

	/**
	* 待审核、审核拒绝列表 -2待审核 -3审核拒绝
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/2 19:32
	* @modifier sunzhongshu
	*/
	@RequestMapping(value = "/getCheckList", method = RequestMethod.GET)
	public ResultModel getCheckList(@RequestParam(name = "advertiserId",required = true) Integer advertiserId,
							 		@RequestParam(name = "status",required = true) Integer status,
									@RequestParam(name = "keyWord") String keyWord,
									@RequestParam(name = "pageNum") Integer pageNum,
									@RequestParam(name = "pageSize") Integer pageSize){
		ResultModel resultModel = new ResultModel();
		try {
			Map<String,Object> map = adTicketService.getCheckList(advertiserId,status,keyWord,pageNum,pageSize);
			resultModel.setReturnValue(map);
		} catch (Exception e) {
			LOGGER.error("券待审核、审核拒绝列表查询失败"+e.getMessage(), e);
			e.printStackTrace();
		}
		return resultModel;
	}

	/**
	 *
	* @Title: getWaitCheckList
	* @Description: 查询待审核的广告券列表
	* @return ResultModel
	 */
	@RequestMapping(value = "/getWaitCheckList", method = RequestMethod.GET)
    @Deprecated
    public ResultModel<PageInfo<AdTicketCheckDto>>getWaitCheckList(
                                                             @RequestParam(name = "advertiser",required = false) String advertiser,
                                                             @RequestParam(name = "keyWord",required = false) String keyWord,
                                                             @RequestParam(name = "sale",required = false) String sale,
                                                             @RequestParam(name = "ae",required = false) String ae,
                                                             @RequestParam(name = "createUser",required = false) String createUser,
                                                             @RequestParam(name = "pageNum",defaultValue= "1")Integer pageNum,
                                                             @RequestParam(name = "pageSize",defaultValue="20")Integer pageSize){
	    ResultModel<PageInfo<AdTicketCheckDto>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(adTicketService.getWaitCheckList(advertiser,keyWord, sale,ae,createUser, pageNum, pageSize));
        } catch (Exception e) {
            LOGGER.error("查询待审核券列表信息出错"+ e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询待审核券列表信息出错");
        }
        return resultModel;
    }

	/**
	 * 审核后台审核
	* 券审核操作  推缓存  0 -拒绝 1 -通过
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/2 19:40
	* @modifier sunzhongshu
	*/
	@LogBefore(operType="/adTicket/ticketCheck",keyName="广告券单条审核")
	@RequestMapping(value = "/ticketCheck")
	public ResultModel ticketCheck(@RequestParam(name = "status",required = true) Integer status,
							@RequestParam(name = "ticketId",required = true) Long ticketId,
							@RequestParam(name = "refuseReason") String refuseReason,
							@RequestParam(name = "tags") String tags,
							@RequestParam(name = "domainCode") String domainCode,
								   HttpServletRequest request,HttpServletResponse response){
		ResultModel resultModel = new ResultModel();
		try {
			User user =	getUser(request,response);
			Boolean success = adTicketService.ticketCheck(ticketId,status,refuseReason,tags,domainCode,user.getUsername());
			resultModel.setReturnValue(success);
		}catch (Exception e){
			LOGGER.error("券审核失败"+e.getMessage(), e);
			e.printStackTrace();
		}
		return resultModel;
	}

	/**
	 * 0 -拒绝 1 -通过
	 * @Title: auditTicketBatch
	 * @Description: 批量审核广告券(成功或失败)
	 * @param request
	 * @param ticketIds
	 * @param status
	 * @param refuseReason
	 * @return
	 */
	@LogBefore(operType = "/adTicket/auditTicketBatch", keyName = "广告券批量审核")
	@RequestMapping(value = "/auditTicketBatch", method = RequestMethod.POST)
	public ResultModel<String> auditTicketBatch(HttpServletRequest request, HttpServletResponse response,
												@RequestParam(name = "ticketIds", required = true) String ticketIds,
												@RequestParam(name = "status", required = true) Integer status,
												@RequestParam(name = "refuseReason", required = false) String
															refuseReason) {
		ResultModel<String> resultModel = new ResultModel<>();
        User user = getUser(request, response);
        //审核拒绝的状态为0
		if (status == 0 && StringUtils.isBlank(refuseReason)) {
			return ResultModelFactory.FAIL500("请填写审核拒绝原因");
		}
		try {
			//资质ID集合
			List<Long> tickeIdList = JSON.parseArray(ticketIds, Long.class);
			//审核失败的券集合
			List<Long> auditFailTicketIds = new ArrayList<>();
			if (CollectionUtils.isNotEmpty(tickeIdList)) {
				for (Long ticketId : tickeIdList) {
					//根据券ID查询广告分类和广告标签
					AdTicketCheckInfokDto ticketInfo = adTicketService.getTicketInfoAndAssetsModify(ticketId);
					if (status == 1 && ticketInfo == null) {
						return ResultModelFactory.FAIL500("券ID:" + ticketId + "," + "审核信息为空，请完善");
					}
					if (status == 1 && ticketInfo != null && StringUtils.isBlank(ticketInfo.getTags())) {
						return ResultModelFactory.FAIL500("券ID:" + ticketId + "," + "广告标签不能为空");
					}
					if (status == 1 && ticketInfo != null && StringUtils.isBlank(ticketInfo.getDomainCode())) {
						return ResultModelFactory.FAIL500("券ID:" + ticketId + "," + "广告分类不能为空");
					}
					//1:审核通过
					Boolean success = adTicketService.ticketCheck(ticketId, status, refuseReason, ticketInfo.getTags()
							, ticketInfo.getDomainCode(), user.getUsername());
					//审核没通过
					if (!success) {
						auditFailTicketIds.add(ticketId);
					}
				}
			}
			if (CollectionUtils.isNotEmpty(auditFailTicketIds)) {
				resultModel.setReturnValue(auditFailTicketIds.toString());
			}
		} catch (Exception e) {
			LOGGER.error("审核广告券信息出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("审核广告券信息出错");
		}
		return resultModel;
	}

	/**
	* 	券素材或url操作日志获取接口
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/3 15:46
	* @modifier sunzhongshu
	*/
	@RequestMapping(value = "/getTicketLog",method = RequestMethod.GET)
	public ResultModel getTicketLog(@RequestParam(name = "ticketId") Long ticketId) {
		ResultModel resultModel = new ResultModel();
		TblAdTicketModify tblAdTicketModify =  adTicketService.getTicketLog(ticketId);
		resultModel.setReturnValue(tblAdTicketModify);
		return resultModel;
	}

	/**
	*  审核券信息查询
	* @CopyRright  (c) 2018-微财科技有限公司
	* @author sunzhongshu
	* @created 2018/7/6 11:36
	* @modifier sunzhongshu
	*/
	@RequestMapping(value = "/getTicketInfo",method = RequestMethod.GET)
	public ResultModel getTicketInfo(@RequestParam(name = "ticketId") Long ticketId) {
		AdTicketCheckInfokDto adTicketCheckInfokDto = null;
        try {
            adTicketCheckInfokDto = adTicketService.getTicketInfoAndAssetsModify(ticketId);
        } catch (Exception e) {
            LOGGER.error("审核广告券信息出错"+ e.getMessage(), e);
            return ResultModelFactory.FAIL500("审核广告券信息出错");
        }
		ResultModel resultModel = new ResultModel();
		resultModel.setReturnValue(adTicketCheckInfokDto);
		return resultModel;
	}

	/**
	 *
	 * 功能描述:
	 * @fileName:连接测试列表查询
	 * @param: AdTicketSearchDto
	 * @return: java.util.List<com.bxm.adsmanager.model.vo.AdTicketVo>
	 * @auther: sunzs
	 * @date: 2018/9/7 10:31
	 */
	@RequestMapping(value = "/getUrlTestList",method = RequestMethod.GET)
	public ResultModel<PaginationTemp> getUrlTestList(AdTicketSearchDto adTicketSearchDto) {
		ResultModel<PaginationTemp> rs = new ResultModel<>();
		try {
			PaginationTemp result = adTicketService.findUrlTestList(adTicketSearchDto);
			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("查找链接测试列表出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找链接测试列表出错");
		}
		return rs;

	}

	/**
	 *
	 * 功能描述:
	 * @fileName: 券链接测试结果提交
	 * @param: [adTicketUrlTest]
	 * @return: com.bxm.util.dto.ResultModel
	 * @auther: sunzs
	 * @date: 2018/9/10 17:26
	 */
	@RequestMapping(value = "/addUrlTestResult",method = RequestMethod.GET)
	public ResultModel addUrlTestResult(AdTicketUrlTest adTicketUrlTest) {
		if (StringUtils.isBlank(adTicketUrlTest.getUrlTestResult())) {
			return ResultModelFactory.FAIL500("链接测试结果不能为空");
		}
		ResultModel rs = new ResultModel<>();
		adTicketUrlTest.setDealStatus((short) 1);
		Integer result = adTicketService.updateTicketUrlTest(adTicketUrlTest);
		if (result != 1) {
			rs.setSuccessed(false);
			rs.setReturnValue("链接测试结果提交失败");
		}
		return rs;
	}

	/**
	 * @description 更新广告券状态
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/updateStatusBySentinel",keyName="监控项目修改状态")
	@RequestMapping(value = "/updateStatusBySentinel", method = RequestMethod.GET)
	public ResultModel<Boolean> update(@RequestParam(required = true, name = "id") Long id) {
		//状态。0 停止、1 正常、2 暂停、-1 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		ResultModel rs = new ResultModel();
		try {
			Boolean flag=  adTicketService.updateStatus(id);
			rs.setReturnValue(flag);
		}catch (ValidateException v){
			rs.setReturnValue(false);
			rs.setErrorDesc("查找不到广告券或者该广告券已经删除");
			return rs;
		}catch (PushProdException e){
			rs.setReturnValue(false);
			rs.setErrorDesc("广告券"+id+"推送失败");
			return rs;
		}catch (Exception e){
			rs.setReturnValue(false);
			rs.setErrorDesc(e.getMessage());
			return rs;
		}
		return rs;
	}

	/**
	 * @description 根据券id获取ae
	 * @author lala
	 * @time 2019/5/27
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/getAeCodeByTicketId", method = RequestMethod.GET)
	public ResultModel<String> getAeCodeByTicketId(@RequestParam(required = true, name = "id") Long id) {
		ResultModel rs = new ResultModel();
		try {
			String ae = adTicketService.getAeCodeByTicketId(id);
			rs.setReturnValue(ae);
		} catch (Exception e){
			rs.setReturnValue(null);
			rs.setErrorDesc(e.getMessage());
			return rs;
		}
		return rs;
	}

	/**
	 * @description 批量添加流量包ID到多个广告券
	 * @author zhengwangeng
	 * @time 2019-11-5 14:00
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType = "/adTicket/addBatchFlowPackage", keyName = "批量添加流量包ID到多个广告券")
	@RequestMapping(value = "/addBatchFlowPackage", method = RequestMethod.POST)
	public ResultModel<Boolean> addBatchFlowPackage(@RequestParam(name = "flowPackageArrayConfs") String flowPackageArrayConfs,
													HttpServletRequest request, HttpServletResponse response) {
		List<AdTicketFlowPackageAddBatchDto> flowPackageAddBatchDtos = JSON.parseArray(flowPackageArrayConfs, AdTicketFlowPackageAddBatchDto.class);
		ResultModel rs = new ResultModel();
		try {
			User user = getUser(request, response);
			Boolean flag = adTicketService.addBatchFlowPackage(flowPackageAddBatchDtos, user.getUsername());
			rs.setReturnValue(flag);
		} catch (Exception e) {
			rs.setReturnValue(null);
			rs.setErrorDesc(e.getMessage());
			return rs;
		}
		return rs;
	}

	/**
	 * @description 批量添加广告位ID到多个广告券
	 * @author zhengwangeng
	 * @time 2019-11-5 14:00
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType = "/adTicket/addBatchPosition", keyName = "批量添加广告位ID到多个广告券")
	@RequestMapping(value = "/addBatchPosition", method = RequestMethod.POST)
	public ResultModel<Boolean> addBatchPosition(@RequestParam(required = true, name = "positionArrayConfs") String positionArrayConfs,
					HttpServletRequest request, HttpServletResponse response) {
		List<AdTicketPositionAddBatchDto> flowPackageAddBatchDtos = JSON.parseArray(positionArrayConfs, AdTicketPositionAddBatchDto.class);
		ResultModel rs = new ResultModel();
		try {
			User user = getUser(request, response);
			Boolean flag = adTicketService.addBatchPosition(flowPackageAddBatchDtos, user.getUsername());
			rs.setReturnValue(flag);
		} catch (Exception e) {
			rs.setReturnValue(null);
			rs.setErrorDesc(e.getMessage());
			return rs;
		}
		return rs;
	}


	/**
	 * @description 批量添加黑白名单到多个广告券
	 * @author 拉拉
	 * @time 2020-08-05 14:00
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType = "/adTicket/addBatchFlowPackagesByTickets", keyName = "批量添加广告位ID到多个广告券")
	@RequestMapping(value = "/addBatchFlowPackagesByTickets", method = RequestMethod.POST)
	public ResultModel<Boolean> addBatchPositionByTickets(
			@RequestParam(name = "ticketIds") String ticketIds,
			@RequestParam(name = "flowPackages") String flowPackages,
			@RequestParam(name = "type") String type,
			HttpServletRequest request, HttpServletResponse response) {
		ResultModel rs = new ResultModel();
		try {
			User user = getUser(request, response);
			String msg= adTicketService.addBatchFlowPackagesByTickets(ticketIds,flowPackages,type,user.getUsername());
			rs.setReturnValue(msg);
		} catch (Exception e) {
			LOGGER.error("批量添加黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
		return rs;
	}


	/**
	 * 根据参数查找券列表
	 * @return
	 */
	@RequestMapping(value = "/findTicketByParams", method = RequestMethod.GET)
	public ResultModel<PageInfo<AdTicketAppEntranceVo>> findTicketByParams(AdTicketSearchDto adTicketSearchDto) {

		try {
			ResultModel<PageInfo<AdTicketAppEntranceVo>> rs = new ResultModel<>();
			PageInfo<AdTicketAppEntranceVo> pageInfo = adTicketService.queryTicketsByParams(adTicketSearchDto);
			rs.setReturnValue(pageInfo);
			return rs;
		} catch (ValidateException v) {
			LOGGER.error(v.getMessage(), v);
			return ResultModelFactory.FAIL400(v.getMessage());
		} catch (Exception e) {
			LOGGER.error("查找广告券出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找广告券出错");
		}
	}
}
