package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.dto.TicketCosWarnDto;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/** 券消耗实时记录
 * @author sunzs
 * created on 2018/9/10
 */
@RestController
@RequestMapping("/adTicket/cost")
public class AdTicketCostController {

    private final static Logger LOG = LoggerFactory.getLogger(AdTicketCostController.class);

    @Autowired
    private AdTicketCostService adTicketCostService;

    /**
     *
     * 功能描述: 券消耗提醒列表
     * @fileName:
     * @param: [adTicketSearchDto]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/9/12 17:51
     */
    @RequestMapping(value = "/findAll",method = RequestMethod.GET)
    public ResultModel findAll(AdTicketSearchDto adTicketSearchDto){
        ResultModel resultModel = new ResultModel<>();

        try {
            resultModel.setReturnValue(adTicketCostService.findAll(adTicketSearchDto,null));

        } catch (Exception e) {
            resultModel.setSuccessed(false);
            e.printStackTrace();
        }
        return resultModel;
    }

    /**
     *
     * 功能描述: 记录删除接口
     * @fileName:
     * @param: [id]AdTicketCostLogMapper
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/9/12 17:52
     */
    @RequestMapping(value = "/remove",method = RequestMethod.GET)
    public ResultModel remove(@RequestParam("id")Long id){
        ResultModel resultModel = new ResultModel<>();

        try {
           resultModel.setReturnValue(adTicketCostService.remove(id));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return resultModel;
    }


    /**
     *
     * 功能描述:
     * @fileName:
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/9/25 16:28
     */
    @RequestMapping(value = "/saveOrUpdate")
    public ResultModel saveOrUpdate(TicketCosWarnDto ticketCosWarnDto){
        try {
           adTicketCostService.saveOrUpdate(ticketCosWarnDto);
        }catch (Exception e){
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return ResultModelFactory.SUCCESS();

    }


    /**
     *
     * 功能描述: 删除券提醒值
     * @fileName:
     * @param: [ids]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/9/12 11:13
     */
    @RequestMapping(value = "/delete",method = RequestMethod.GET)
    public ResultModel delete(@RequestParam(name = "id") String id){
        ResultModel resultModel = new ResultModel<>();
        try {
            resultModel.setSuccessed(adTicketCostService.delete(id));
        }catch (Exception e){
            return ResultModelFactory.FAIL500("券提醒值删除失败");
        }
        return resultModel;
    }

    @RequestMapping(value = "/deleteMany",method = RequestMethod.GET)
    public ResultModel deleteMany(@RequestParam(name = "ids") String ids){
        ResultModel resultModel = new ResultModel<>();
        try {
            if (StringUtils.isBlank(ids)){
                return ResultModelFactory.FAIL500("id不能为空");
            }
            List<Long> list = JSON.parseArray(ids,Long.class);
            if (CollectionUtils.isNotEmpty(list)){
                adTicketCostService.deleteByIds(list);
                /*for (String id: list){
                    adTicketCostService.delete(id);
                }*/
            }
            resultModel.setSuccessed(true);
        }catch (Exception e){
            return ResultModelFactory.FAIL500("券提醒值删除失败");
        }
        return resultModel;
    }

    /**
     *
     * 功能描述:
     * @fileName:
     * @param: [adTicketSearchDto, mark] mark 1-券提醒列表加载 2-券新增列表加载 3-多个id查询券列表
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/9/12 20:09
     */
    @RequestMapping(value = "/findTicket",method = RequestMethod.GET)
    public ResultModel findTicket(AdTicketSearchDto adTicketSearchDto,
                                  @RequestParam(value = "mark",required = true) Integer mark,
                                  @RequestParam("json") String json){

        ResultModel resultModel = new ResultModel<>();
        resultModel.setReturnValue(adTicketCostService.findTicket(adTicketSearchDto,mark,json));
        return resultModel;
    }
    @RequestMapping(value = "/findTicketConsumeRemindList",method = RequestMethod.GET ,produces="application/json")
    public ResultModel findTicketConsumeRemindList(AdTicketSearchDto adTicketSearchDto){
        ResultModel resultModel = new ResultModel<>();
        resultModel.setReturnValue(adTicketCostService.findTicketConsumeRemindList(adTicketSearchDto));
        return resultModel;
    }
    /**
     *
     * 功能描述:
     * @fileName:
     * @param: 编辑操作数据回显接口
     * @return:
     * @auther: sunzs
     * @date: 2018/9/25 11:22
     */
    @RequestMapping(value = "/editShow",method = RequestMethod.GET)
    public ResultModel editShow(@RequestParam("ticketIds") String ticketIds){

        if (StringUtils.isBlank(ticketIds) || "[]".equals(ticketIds)){
            return ResultModelFactory.FAIL500("券ID不能传空");
        }
        ResultModel resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(adTicketCostService.editShow(ticketIds));
        }catch (Exception e){
            LOG.error("编辑数据回显失败",e);
            return ResultModelFactory.FAIL500("编辑数据回显失败");
        }
        return resultModel;
    }
    /**
     *
     * 功能描述:
     * @fileName:根据券分类添加消耗提醒
     * @param: [tagCodes, cosWarn, json]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/31 10:58
     */
    @RequestMapping(value = "/addCostWarnByTag",method = RequestMethod.GET)
    public ResultModel addCostWarnByTag(@RequestParam("tagCodes")String tagCodes,
                                        @RequestParam("cosWarn")String cosWarn,
                                        @RequestParam("json")String json,
                                        @RequestParam(value = "url", required = false) String url){

        return adTicketCostService.addCostWarnByTag(tagCodes,cosWarn,json,url);
    }




    @RequestMapping(value = "/syns")
    public ResultModel syns(){
        try {
            adTicketCostService.syns();
        }catch (Exception e){
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return ResultModelFactory.SUCCESS();

    }

}
