package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCode;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsCodeService;
import com.bxm.adsmanager.utils.CouponCodeFileUploadUtil;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.UuidUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;

/**
 * 优惠券code
 * Created by zhengwangeng on 2019/5/22 14:01.
 */
@RestController
@RequestMapping("/adTicketCouponsCode")
public class AdTicketCouponsCodeController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketCouponsCodeController.class);

	@Resource
	private RedisNewClient redisNewClient;
	@Resource
	private AdTicketCouponsCodeService adTicketCouponsCodeService;

	/**
	 * 上传code文件
	 * 只能上传xls或txt后缀的文件
	 * @param request
	 * @param response
	 * @return
	 */
	@LogBefore(operType="/adTicketCouponsCode/uploadCode",keyName="优惠券code文件上传")
	@RequestMapping(value = "/uploadCode", method = RequestMethod.POST)
	public ResultModel uploadCode(HttpServletRequest request, HttpServletResponse response) {
		ResultModel rs = new ResultModel();
		try {
			Set<String> codeSet = CouponCodeFileUploadUtil.upload(request);
			// 本次保存的文件名
			String codeKeyName = UuidUtil.getUuidByJdk(false);

			//临时保存到redis中
			redisNewClient.sadd(RedisKeys.getKeyGeneratorByTempAssetsCouponsCode(codeKeyName).generateKey(), codeSet,
					RedisKeys.getKeyGeneratorByTempAssetsCouponsCodeDBIndex());

			Map<String, Object> map = new HashMap<>(2);
			map.put("codeKeyName", codeKeyName);
			map.put("codeNum", codeSet.size());

			rs.setReturnValue(map);
		}catch (Exception e){
			LOGGER.error("优惠券code文件上传出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("优惠券code文件上传出错");
		}
		return rs;
	}


	@RequestMapping(value = "/exportCode",method = RequestMethod.GET)
	public void findAll(@RequestParam(value = "ticketId")Long ticketId, HttpServletRequest request, HttpServletResponse response){

		try {
			List<AdTicketCouponsCode> exportList = adTicketCouponsCodeService.findByTicketId(ticketId);
			if (CollectionUtils.isEmpty(exportList)){
				exportList = Collections.emptyList();
			}
			ExcelUtil.exportExcel(exportList, null, null, AdTicketCouponsCode.class, "优惠券码记录导出.xls", response);
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException("导出券耗记录出错");
		}
	}

}
