package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.adkeeper.AdTicketNewService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.commons.currency.Money;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;

/**
 * @author tangx
 * @date 2020/8/6 14:01
 */
@RestController
@RequestMapping("/adTicket")
@Slf4j
public class AdTicketNewController extends BaseController {

    @Autowired
    private AdTicketNewService adTicketNewService;

    @Autowired
    private ProdService prodService;


    /**
     *
     * @param id 券id
     * @param budgetDaily 日预算
     * @param price 出价
     * @param adxBudgetDaily 成本日限额
     * @param adxPrice ADX出价
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/adTicket/updateBudgetDaily", keyName = "广告")
    @RequestMapping(value = "/updateBudgetDaily", method = RequestMethod.POST, produces = "application/json")
    public ResultModel updateBudgetDaily(@RequestParam("id")  Long id,
                                         @RequestParam(value = "budgetDaily", required = false) Double budgetDaily,
                                         @RequestParam(value = "price", required = false) Double price,
                                         @RequestParam(value = "adxBudgetDaily", required = false) Double adxBudgetDaily,
                                         @RequestParam(value = "adxPrice", required = false) Double adxPrice,
                                         HttpServletRequest request, HttpServletResponse response) {
        try {
            checkUpdateBudgetDaily(budgetDaily, price, adxBudgetDaily, adxPrice);
        } catch (Exception e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        }

        User user = getUser(request,response);
        Boolean result;
        try {
            result = adTicketNewService.updateBudget(id, budgetDaily, price, adxBudgetDaily, adxPrice, user.getUsername());
            if (result){
                prodService.pushAdTicketToProdPre(id);
            }
        } catch (ValidateException e) {
            log.error("修改日预算错误:"+e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            log.error("修改日预算错误:"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("修改日预算错误");
        }
        if (!result) {
            return ResultModelFactory.FAIL500("修改日预算失败");
        }
        return ResultModelFactory.SUCCESS();
    }

    private void checkUpdateBudgetDaily(Double budgetDaily, Double price, Double adxBudgetDaily, Double adxPrice) {
        if (budgetDaily == null && price == null && adxBudgetDaily == null && adxPrice == null) {
            throw new ValidateException("参数为空");
        }
        if (price != null) {
            if (price < 0.001) {
                throw new ValidateException("出价必须大于等于0.001");
            }
        }
        if (adxBudgetDaily != null) {
            if (adxBudgetDaily < 0.01) {
                throw new ValidateException("ADX日预算必须大于等于0.01");
            }
        }
        if (adxPrice != null) {
            if (adxPrice < 0.01) {
                throw new ValidateException("ADX出价必须大于等于0.01");
            }
        }
    }

}
