package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicketRights;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketRightsDto;
import com.bxm.adsmanager.service.adkeeper.AdTicketRightsService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 权益奖品.</br>
 * Created by zhengwangeng on 2021/4/25.
 */
@RestController
@RequestMapping("/adTicket/rights")
public class AdTicketRightsController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketRightsController.class);

	@Autowired
	private AdTicketRightsService adTicketRightsService;

	@LogBefore(operType = "/adTicketRights/add", keyName = "权益奖品添加")
	@RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
	public ResultModel add(@RequestBody AdTicketRightsDto adTicketRightsDto, HttpServletRequest request, HttpServletResponse response) {
		User user = getUser(request, response);
		try {
			//参数校验
			if (BeanValidator.validateGroup(adTicketRightsDto, AdTicketRightsDto.Add.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketRightsDto, AdTicketRightsDto.Add.class).getMessage());
			}
			adTicketRightsDto.setCreateTime(new Date());
			adTicketRightsDto.setCreateUser(user.getUsername());
			Long positionAssetSizeId = adTicketRightsService.add(adTicketRightsDto);

			return ResultModelFactory.SUCCESS(positionAssetSizeId);
		} catch (Exception e) {
			LOGGER.error("添加权益奖品出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加权益奖品出错");
		}
	}

	@LogBefore(operType = "/adTicketRights/update", keyName = "权益奖品更新")
	@RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
	public ResultModel update(@RequestBody AdTicketRightsDto adTicketRightsDto, HttpServletRequest request, HttpServletResponse response) {
		User user = getUser(request, response);
		ResultModel rs = new ResultModel();
		if (adTicketRightsDto == null || adTicketRightsDto.getId() == null) {
			return ResultModelFactory.FAIL400("权益奖品id不能为空");
		}

		try {
			//参数校验
			if (BeanValidator.validateGroup(adTicketRightsDto, AdTicketRightsDto.Update.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketRightsDto, AdTicketRightsDto.Update.class).getMessage());
			}
			adTicketRightsDto.setModifyTime(new Date());
			adTicketRightsDto.setModifyUser(user.getUsername());
            Integer result = adTicketRightsService.update(adTicketRightsDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("更新权益奖品出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新权益奖品出错");
		}
		return rs;
	}

	/**
	 * 查找所有权益奖品
	 * @param searchDto
	 * @return
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<PageInfo<AdTicketRights>> findAll(AdTicketRightsDto searchDto) {
		ResultModel<PageInfo<AdTicketRights>> rs = new ResultModel<>();

		try {
			PageInfo<AdTicketRights> result = adTicketRightsService.findAll(searchDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找权益奖品出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找权益奖品出错");
		}
		return rs;
	}

	/**
	 * 查找所有权益奖品
	 * @param searchDto
	 * @return
	 */
	@RequestMapping(value = "/findList", method = RequestMethod.GET)
	public ResultModel<List<AdTicketRights>> findList(AdTicketRightsDto searchDto) {
		ResultModel<List<AdTicketRights>> rs = new ResultModel<>();

		try {
			List<AdTicketRights> result = adTicketRightsService.getList(searchDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找所有权益奖品出错" + e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("查找所有权益奖品出错");
		}
		return rs;
	}

}