package com.bxm.adsmanager.web.controller.adkeeper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.bxm.adsmanager.model.dto.AdAssetsStatisticsDto;
import com.bxm.adsmanager.model.vo.AdAssetsStatisticsVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketStatService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

@RestController
@RequestMapping("/adAssets/stat")
public class AdTicketStatController {
    
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketStatController.class);
    
    @Autowired
    private AdTicketStatService adTicketStatService;
    
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    
    /**
    * @Title: findAdAssetsLowClickRateCount  
    * @Description: 查询低于预设点击率的素材记录数
    * @return ResultModel<Long> 
     */
    @RequestMapping(value = "/findLowClickCount", method = RequestMethod.GET)
    public ResultModel<Long> findAdAssetsLowClickRateCount(AdAssetsStatisticsDto param) {

        ResultModel<Long> rs = new ResultModel<Long>();
        Long count = 0L;
        try {
            count = adTicketStatService.queryAdAssetsLowClickRateCount(param);
            rs.setReturnValue(count);
        }catch (Exception e){
            LOGGER.error("查询素材数据出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询素材数据出错");
        }
        return  rs;
    }
    
    /**
     * @Title: findAdAssetsLowClickRateList  
     * @Description: 查询低于预设点击率的素材列表
     * @return ResultModel<Pagination> 
      */
     @RequestMapping(value = "/findAdAssetsList", method = RequestMethod.GET)
     public ResultModel<PageInfo<AdAssetsStatisticsVo>> findAdAssetsLowClickRateList(AdAssetsStatisticsDto param) {
         ResultModel<PageInfo<AdAssetsStatisticsVo>> rs = new ResultModel<PageInfo<AdAssetsStatisticsVo>>();
         if(param == null || StringUtils.isBlank(param.getPvStartTime()) || StringUtils.isBlank(param.getPvEndTime())){
             return ResultModelFactory.FAIL500("查询时间不能为空");
         }
         PageInfo<AdAssetsStatisticsVo> list = null;
         try {
             list = adTicketAssetsService.findAdAssetsLowClickRateList(param);
             rs.setReturnValue(list);
         }catch (Exception e){
             LOGGER.error("查询素材列表数据出错"+e.getMessage(), e);
             return ResultModelFactory.FAIL500("查询素材列表数据出错");
         }
         return  rs;
     }

}
