package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dto.AdTicketThirdPartyCrowdPackageDto;
import com.bxm.adsmanager.model.vo.AdTicketThirdPartyCrowdPackageVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketThirdPartyCrowdPackageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 第三方人群包.</br>
 * @author zhengwangeng
 * @date 2019年08月13日下午04:08:28
 */
@RestController
@RequestMapping("/adTicketThirdPartyCrowdPackage")
public class AdTicketThirdPartyCrowdPackageController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketThirdPartyCrowdPackageController.class);

	@Autowired
	private AdTicketThirdPartyCrowdPackageService adTicketThirdPartyCrowdPackageService;

	@LogBefore(operType = "/adTicketThirdPartyCrowdPackage/add", keyName = "第三方人群包添加")
	@RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
	public ResultModel add(@RequestBody AdTicketThirdPartyCrowdPackageDto adTicketThirdPartyCrowdPackageDto) {
		try {
			//参数校验
			if (BeanValidator.validateGroup(adTicketThirdPartyCrowdPackageDto, AdTicketThirdPartyCrowdPackageDto.Add.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketThirdPartyCrowdPackageDto, AdTicketThirdPartyCrowdPackageDto.Add.class).getMessage());
			}
			Long positionAssetSizeId = adTicketThirdPartyCrowdPackageService.add(adTicketThirdPartyCrowdPackageDto);

			return ResultModelFactory.SUCCESS(positionAssetSizeId);
		} catch (Exception e) {
			LOGGER.error("添加第三方人群包出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加第三方人群包出错");
		}
	}

	@LogBefore(operType = "/adTicketThirdPartyCrowdPackage/update", keyName = "第三方人群包更新")
	@RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
	public ResultModel update(@RequestBody AdTicketThirdPartyCrowdPackageDto adTicketThirdPartyCrowdPackageDto) {
		ResultModel rs = new ResultModel();
		if (adTicketThirdPartyCrowdPackageDto == null || adTicketThirdPartyCrowdPackageDto.getId() == null) {
			return ResultModelFactory.FAIL400("第三方人群包id不能为空");
		}

		try {
			//参数校验
			if (BeanValidator.validateGroup(adTicketThirdPartyCrowdPackageDto, AdTicketThirdPartyCrowdPackageDto.Update.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketThirdPartyCrowdPackageDto, AdTicketThirdPartyCrowdPackageDto.Update.class).getMessage());
			}

            Integer result = adTicketThirdPartyCrowdPackageService.update(adTicketThirdPartyCrowdPackageDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("更新第三方人群包出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新第三方人群包出错");
		}
		return rs;
	}

	/**
	 * 根据ids查询
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/find", method = RequestMethod.GET)
	public ResultModel findByIds(String ids) {
		ResultModel rs = new ResultModel();
		try {
			List<AdTicketThirdPartyCrowdPackageVo> list = adTicketThirdPartyCrowdPackageService.findById(ids);
			if (null == list) {
				rs.setSuccessed(false);
				rs.setErrorCode("5031");
				rs.setErrorDesc("获取数据为空");
			}
			rs.setReturnValue(list);
		} catch (Exception e) {
			LOGGER.error("查找所有第三方人群包出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找所有第三方人群包出错");
		}
		return rs;
	}

	/**
	 * 查找所有第三方人群包
	 * @param searchDto
	 * @return
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<PageInfo<AdTicketThirdPartyCrowdPackageVo>> findAll(AdTicketThirdPartyCrowdPackageDto searchDto) {
		ResultModel<PageInfo<AdTicketThirdPartyCrowdPackageVo>> rs = new ResultModel<>();

		try {
			PageInfo<AdTicketThirdPartyCrowdPackageVo> result = adTicketThirdPartyCrowdPackageService.findAll(searchDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找所有第三方人群包出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找所有第三方人群包出错");
		}
		return rs;
	}

	/**
	 * 删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	public ResultModel delete(Long id) {
		try {
			adTicketThirdPartyCrowdPackageService.delete(id);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			LOGGER.error("删除第三方人群包出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("该人群包已被广告使用，无法删除。");
		}
	}

}