package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsAdxMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.facade.model.adx.AdxMeituanReviewDto;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdPosition;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsAdxDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsAdxService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * ADX美团素材审核
 */
@RestController
@RequestMapping("/adx/meituan")
public class AdxMeituanController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdxMeituanController.class);

    @Autowired
    private AdAssetsAdxMapperExt adAssetsAdxMapperExt;

    @Autowired
    private AdTicketMapper adTicketMapper;

    @Autowired
    private ProdService prodService;



    /**
     * 美团审核回调
     * @throws Exception
     */
    @RequestMapping(value = "/callback", method = RequestMethod.POST)
    public String callback(@Validated @RequestBody meituanDTO dto) throws Exception {
        List<MeituanCallBackParam> params = dto.getParams();
        if (CollectionUtils.isEmpty(params)) {
            return "fail";
        }
        LOGGER.info("【美团审核回调】传入参数：{}", params.toString());
        for (MeituanCallBackParam param : params) {
            Long assetsId = param.getAssetsId();
            Short reviewStatus = param.getReviewStatus();
            String refuseReason = param.getRefuseReason();

            if (AdAssetsAdx.MEITUAN_REVIEW_WAIT.equals(reviewStatus)) {
                continue;
            }
            AdAssetsAdx adAssetsAdx = adAssetsAdxMapperExt.selectByPrimaryKey(assetsId);
            if (null == adAssetsAdx) {
                continue;
            }

            Long adTicketId = adAssetsAdx.getAdTicketId();
            if (AdAssetsAdx.MEITUAN_REVIEW_PASS.equals(reviewStatus)) {
                AdAssetsAdx assetsUpdate = new AdAssetsAdx();
                assetsUpdate.setId(assetsId);
                assetsUpdate.setMeituanReviewStatus(reviewStatus);
                adAssetsAdxMapperExt.updateByPrimaryKeySelective(assetsUpdate);
            }

            if (AdAssetsAdx.MEITUAN_REVIEW_REFUSE.equals(reviewStatus)) {
                AdAssetsAdx assetsUpdate = new AdAssetsAdx();
                assetsUpdate.setId(assetsId);
                assetsUpdate.setMeituanReviewStatus(reviewStatus);
                assetsUpdate.setMeituanRefuseReason(refuseReason);
                adAssetsAdxMapperExt.updateByPrimaryKeySelective(assetsUpdate);

                // 判断素材所在券是不是开启状态，如果是那么关闭券
                AdTicket adTicket = adTicketMapper.selectByPrimaryKey(adTicketId);
                if (adTicket != null) {
                    Short status = adTicket.getStatus();
                    if (status.equals(AdTicket.STATUS_OPEN)) {
                        AdTicket ticketUpdate = new AdTicket();
                        ticketUpdate.setId(adTicketId);
                        ticketUpdate.setStatus(AdTicket.STATUS_CLOSE);
                        adTicketMapper.updateByPrimaryKeySelective(ticketUpdate);
                        prodService.pushAdTicketToProdPre(adTicketId);
                        User user = new User();
                        user.setUsername("系统");
                        addLogs(user, "停止广告券，美团审核修改券状态：" + JSON.toJSONString(params), String.valueOf(adTicketId));
                    }
                }
            }
            LOGGER.info("【美团审核回调】处理完成,assetsId = {}", assetsId);
        }
        return "success";
    }


/*    *//**
     * 数据订正（所有美团的券写入redis）
     * @return
     *//*
    @RequestMapping(value = "/correctData", method = RequestMethod.POST)
    public String correctData(){
        String meituanPostition = "";
        List<Long> allMeituanTicket = adRulesMapper.findAllMeituanTicket(meituanPostition);

        if (CollectionUtils.isEmpty(allMeituanTicket)) {
            for (Long ticketId : allMeituanTicket) {
                jedisUpdater.hupdate(RedisKeys.getMeituanTicketRedisKey(), ticketId.toString(), CommonConstant.CACHE_DEFAULT_VALUE);
            }
            return allMeituanTicket.toString();
        }
        return "meituan ticket not exist!";
    }*/


    @Data
    @ToString
    public static class MeituanCallBackParam implements Serializable {

        @NotNull
        private Long assetsId;

        @NotNull
        private Short reviewStatus;

        private String refuseReason;
    }


    @Data
    public static class meituanDTO {
        private List<MeituanCallBackParam> params;
    }



}
