package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.dto.DirectTicketSearch;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.DirectTicketMaterialService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by wuwenquan on 2018/10/9.
 */
@RestController
@RequestMapping("/directTicketMaterial")
public class DirectTicketMaterialController extends BaseController{
    @Autowired
    private DirectTicketMaterialService directTicketMaterialService;

    private static final Logger LOGGER = LoggerFactory.getLogger(DirectTicketMaterialController.class);

    @RequestMapping(value = "/findMaterials", method = RequestMethod.GET,produces = "application/json")
    public ResultModel<Pagination> findMaterials(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsDto adAssetsDto) {

        ResultModel<Pagination> rs = new ResultModel<Pagination>();

        if(adAssetsDto.getTicketId()==null){
            return ResultModelFactory.FAIL400("礼券id不能为空");
        }
        if(!StringUtil.isNotBlank(adAssetsDto.getAssetSize())){
            return ResultModelFactory.FAIL400("尺寸不能为空");
        }
        if(adAssetsDto.getPvStartTime()==null||adAssetsDto.getPvEndTime()==null){
            return ResultModelFactory.FAIL400("查询时间不能为空");
        }
        try {
            Pagination list = directTicketMaterialService.findDirectAssetsListByParams(adAssetsDto);
            if(list!=null){
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        }catch (Exception e){
            LOGGER.error("根据广告券id和尺寸查找广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id和尺寸查找广告素材出错");
        }
        return  rs;
    }

    @RequestMapping(value = "/findTickets", method = RequestMethod.GET,produces = "application/json")
    public ResultModel<Pagination> findTickets(HttpServletRequest request, HttpServletResponse response,
                                                             DirectTicketSearch directTicketSearch) {

        ResultModel<Pagination> rs = new ResultModel<Pagination>();

        if(directTicketSearch.getPvStartTime()==null||directTicketSearch.getPvEndTime()==null){
            return ResultModelFactory.FAIL400("查询时间不能为空");
        }

        try {
            Pagination list = directTicketMaterialService.findDirectTickets(directTicketSearch);
            if(list!=null){
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        }catch (Exception e){
            LOGGER.error("查询直投广告券X尺寸出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询直投广告券X尺寸出错");
        }
        return  rs;
    }

    @RequestMapping(value = "/add", method = RequestMethod.POST,produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                                       AdAssetsDto AdAssetsDto) {
        ResultModel rs = new ResultModel<Pagination>();
        try {
            String userName =getUser(request,response).getUsername();
            directTicketMaterialService.add(AdAssetsDto,userName);
             return ResultModelFactory.SUCCESS(null);
        }catch (Exception e){
            LOGGER.error("查询直投广告券X尺寸出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询直投广告券X尺寸出错");
        }

    }

    @RequestMapping(value = "/update", method = RequestMethod.POST,produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                                       AdAssetsDto AdAssetsDto) {
        ResultModel  rs = new ResultModel<Pagination>();
        try {
            String userName =getUser(request,response).getUsername();
            directTicketMaterialService.update(AdAssetsDto,userName);
            return ResultModelFactory.SUCCESS(null);
        }catch (Exception e){
            LOGGER.error("更新直投素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("更新直投素材出错");
        }

    }

    @RequestMapping(value = "/get", method = RequestMethod.GET,produces = "application/json")
    public ResultModel get(Long id){
        ResultModel  rs = new ResultModel<AdAssetsVo>();
        try {
            AdAssetsVo adAssetsVo = directTicketMaterialService.get(id);
            rs.setReturnValue(adAssetsVo);
        }catch (Exception e){
            LOGGER.error("查询单个直投素材信息出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询单个直投素材信息出错");
        }
        return rs;
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST,produces = "application/json")
    public ResultModel delete(Long id){
        ResultModel  rs = new ResultModel<AdAssetsVo>();
        try {
            directTicketMaterialService.delete(id);
          return ResultModelFactory.SUCCESS();
        }catch (Exception e){
            LOGGER.error("删除单个直投素材信息出错"+e.getMessage(), e);
            return  ResultModelFactory.FAIL500("删除单个直投素材信息出错");
        }
    }


}
