package com.bxm.adsmanager.web.controller.adkeeper;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.adkeeper.DownloadLandingPage;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.DownloadLandingPageDTO;
import com.bxm.adsmanager.model.dto.DownloadLandingPageSearchDTO;
import com.bxm.adsmanager.service.adkeeper.DownloadLandingPageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * 下载类落地页.</br>
 * Created by zhengwangeng on 2021/9/6.
 */
@RestController
@RequestMapping("/downloadLandingPage")
public class DownloadLandingPageController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(DownloadLandingPageController.class);

	@Autowired
	private DownloadLandingPageService downloadLandingPageService;

	@LogBefore(operType = "/downloadLandingPage/add", keyName = "下载落地页添加")
	@RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
	public ResultModel add(@RequestBody DownloadLandingPageDTO downloadLandingPageDto, HttpServletRequest request, HttpServletResponse response) {
		User user = getUser(request, response);
		try {
			//参数校验
			if (BeanValidator.validateGroup(downloadLandingPageDto, DownloadLandingPageDTO.Add.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(downloadLandingPageDto, DownloadLandingPageDTO.Add.class).getMessage());
			}
			//downloadLandingPageDto.setCreateTime(new Date());
			//downloadLandingPageDto.setCreateUser(user.getUsername());
			Long positionAssetSizeId = downloadLandingPageService.add(downloadLandingPageDto);

			return ResultModelFactory.SUCCESS(positionAssetSizeId);
		} catch (Exception e) {
			LOGGER.error("添加下载落地页出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加下载落地页出错");
		}
	}

	@LogBefore(operType = "/downloadLandingPage/update", keyName = "下载落地页更新")
	@RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
	public ResultModel update(@RequestBody DownloadLandingPageDTO downloadLandingPageDto, HttpServletRequest request, HttpServletResponse response) {
		User user = getUser(request, response);
		ResultModel rs = new ResultModel();
		if (downloadLandingPageDto == null || downloadLandingPageDto.getId() == null) {
			return ResultModelFactory.FAIL400("下载落地页id不能为空");
		}

		try {
			//参数校验
			if (BeanValidator.validateGroup(downloadLandingPageDto, DownloadLandingPageDTO.Update.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(downloadLandingPageDto, DownloadLandingPageDTO.Update.class).getMessage());
			}
			//downloadLandingPageDto.setModifyTime(new Date());
			//downloadLandingPageDto.setModifyUser(user.getUsername());
            Integer result = downloadLandingPageService.update(downloadLandingPageDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("更新下载落地页出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新下载落地页出错");
		}
		return rs;
	}

	/**
	 * 查找所有下载落地页
	 * @param searchDto
	 * @return
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<PageInfo<DownloadLandingPage>> findAll(DownloadLandingPageSearchDTO searchDto) {
		ResultModel<PageInfo<DownloadLandingPage>> rs = new ResultModel<>();

		try {
			PageInfo<DownloadLandingPage> result = downloadLandingPageService.findAll(searchDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找下载落地页出错" + e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找下载落地页出错");
		}
		return rs;
	}

	/**
	 * 查找所有下载落地页
	 * @param searchDto
	 * @return
	 */
	@RequestMapping(value = "/findList", method = RequestMethod.GET)
	public ResultModel<List<DownloadLandingPage>> findList(DownloadLandingPageSearchDTO searchDto) {
		ResultModel<List<DownloadLandingPage>> rs = new ResultModel<>();

		try {
			List<DownloadLandingPage> result = downloadLandingPageService.getList(searchDto);
			rs.setReturnValue(result);
		} catch (Exception e) {
			LOGGER.error("查找所有下载落地页出错" + e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("查找所有下载落地页出错");
		}
		return rs;
	}

}