package com.bxm.adsmanager.web.controller.adkeeper;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.datapark.service.DataparkGetuiTagIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkSspSdkAppDailyIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;
import com.bxm.adsmanager.model.vo.GetuiTagDictListVo;
import com.bxm.adsmanager.service.adkeeper.GetuiTagDictService;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;

/**
 * 个推标签库.</br>
 * Created by zhengwangeng on 2020/11/27.
 */
@RequestMapping("/getuiTagDict")
@RestController
public class GetuiTagDictController {

	private static final Logger LOGGER = LoggerFactory.getLogger(GetuiTagDictController.class);

	@Autowired
	private GetuiTagDictService getuiTagDictService;
	@Autowired
	private DataparkGetuiTagIntegration dataparkGetuiTagIntegration;
	@Autowired
	private DataparkSspSdkAppDailyIntegration dataparkSspSdkAppDailyIntegration;

	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<List<GetuiTagDictListVo>> findAll(HttpServletRequest request, HttpServletResponse response) {
		ResultModel<List<GetuiTagDictListVo>> rs = new ResultModel<>();
		rs.setReturnValue(getuiTagDictService.findAll());
		rs.setSuccessed(true);
		return rs;
	}

	/**
	 * 更加标签得到覆盖率
	 * @param request
	 * @param response
	 * @param personsGrade
	 * @return
	 */
	@RequestMapping(value = "/coverage", method = RequestMethod.GET)
	public ResultModel<String> findAll(HttpServletRequest request, HttpServletResponse response, String personsGrade) {
		String info = "预估覆盖率%s，预估覆盖人数%d";
		if (StringUtils.isNotBlank(personsGrade)) {
			List<AdTicketGetuiTagRef> adTicketGetuiTagRefs = new ArrayList<>();
			String[] split = personsGrade.split(CommonConstant.BaseCharacter.COMMA);
			for (String tagGroupConf : split) {
				if (StringUtils.isNotBlank(tagGroupConf)) {
					String[] tagGroupConfArray = tagGroupConf.split(CommonConstant.BaseCharacter.BAR);
					String tagGroupCode = tagGroupConfArray[0];
					if (StringUtils.isNotBlank(tagGroupCode)) {
						AdTicketGetuiTagRef adTicketGetuiTagRef = new AdTicketGetuiTagRef();
						//adTicketGetuiTagRef.setTicketId(ticketId);
						adTicketGetuiTagRef.setTagGroupCode(tagGroupCode);
						String tagGroupValue = tagGroupConf.replace(tagGroupCode + CommonConstant.BaseCharacter.BAR, "")
								.replace(CommonConstant.BaseCharacter.BAR, CommonConstant.BaseCharacter.COMMA);
						adTicketGetuiTagRef.setTagGroupValue(tagGroupValue);
						adTicketGetuiTagRefs.add(adTicketGetuiTagRef);

					}
				}
			}
			//得到选择的可视化的人群包标签数据
			List<String> tagValues = adTicketGetuiTagRefs.stream().map(AdTicketGetuiTagRef::getTagGroupValue).collect(Collectors.toList());
			List<String> lastTagValues = getuiTagDictService.buildRealTag(tagValues);

			//lastTagValues.clear();
			//lastTagValues.add("010qww00,010qww00_h,010qww00_m,010qwq00,010qwq00_h,010qwq00_m");

			Long coverage = dataparkGetuiTagIntegration.getConverage(lastTagValues);
			Double rate = 0.0;
			if (coverage !=null && coverage > 0) {
				Long dau = dataparkSspSdkAppDailyIntegration.getSspSdkDau(DateUtil.dateTo8String3(DateUtil.getTheDayBefore(new Date())));
				//Long dau = 14669556L; // 个推标签库上线后就用上面的代码，这个数据是2020-11-23日的DAU
				rate = coverage*1.0/dau;
			}
			info = String.format(info, new DecimalFormat("#.##%").format(rate), coverage);
		} else {
			info = String.format(info, 0, 0);
		}
		ResultModel<String> rs = new ResultModel<>();
		rs.setReturnValue(info);
		rs.setSuccessed(true);
		return rs;
	}

}
