package com.bxm.adsmanager.web.controller.adkeeper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.InnerCrowdPackageDto;
import com.bxm.adsmanager.model.dto.InnerCrowdPackageSearchDto;
import com.bxm.adsmanager.service.adkeeper.InnerCrowdPackageService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;

import lombok.extern.slf4j.Slf4j;

/**
 * 内部人群包
 *
 * @author tangx
 * @date 2021/10/28 9:29
 */
@Slf4j
@RequestMapping("/innerCrowdPackage")
@RestController
public class InnerCrowdPackageController extends BaseController {

    @Autowired
    private InnerCrowdPackageService innerCrowdPackageService;

    @GetMapping("/list")
    public ResultModel list(InnerCrowdPackageSearchDto dto) {
        return ResultModelFactory.SUCCESS(innerCrowdPackageService.list(dto));
    }

    @LogBefore(operType = "/innerCrowdPackage/add", keyName = "内部人群包新增")
    @PostMapping("/add")
    public ResultModel add(@Validated InnerCrowdPackageDto dto) {
        try {
            dto.setUserName(RequestUtils.getCurrentUserName());
            innerCrowdPackageService.add(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType = "/innerCrowdPackage/update", keyName = "内部人群包修改")
    @PostMapping("/update")
    public ResultModel update(@Validated InnerCrowdPackageDto dto) {
        try {
            dto.setUserName(RequestUtils.getCurrentUserName());
            innerCrowdPackageService.update(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 修改状态
     *
     * @param id
     * @param status
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/innerCrowdPackage/updateStatus", keyName = "内部人群包状态修改")
    @PutMapping(value = "/updateStatus")
    public ResultModel updateStatus(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Integer id,
                                    @NotNull(message = "状态不能为空！") @RequestParam(value = "status") Short status,
                                    HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            innerCrowdPackageService.updateStatus(id, status, user.getUsername());
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

}
