package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dto.LandingPagePlanDto;
import com.bxm.adsmanager.model.dto.LandingPagePlanSearchDto;
import com.bxm.adsmanager.model.vo.LandingPageConfigVo;
import com.bxm.adsmanager.model.vo.LandingPagePlanVo;
import com.bxm.adsmanager.service.adkeeper.LandingPageService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author tangx
 * @date 2021/3/11 19:43
 */
@RequestMapping("/landingPagePlan")
@RestController
@Slf4j
public class LandingPageController extends BaseController {

    @Autowired
    private LandingPageService landingPageService;

    @GetMapping("/list")
    public ResultModel list(LandingPagePlanSearchDto dto) {
       PageInfo<LandingPagePlanVo> list = landingPageService.list(dto);
       return ResultModelFactory.SUCCESS(list);
    }

    @PostMapping("/add")
    public ResultModel add(@Validated LandingPagePlanDto dto) {
        String landingPageConfigs = dto.getLandingPageConfigs();
        dto.setLandingPageConfigVoList(JSON.parseArray(landingPageConfigs, LandingPageConfigVo.class));
        if (checkParam(dto) != null) {
            return checkParam(dto);
        }
        try {
            landingPageService.add(dto, RequestUtils.getCurrentUserName());
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/update")
    public ResultModel update(@Validated LandingPagePlanDto dto) {
        String landingPageConfigs = dto.getLandingPageConfigs();
        dto.setLandingPageConfigVoList(JSON.parseArray(landingPageConfigs, LandingPageConfigVo.class));

        if (checkParam(dto) != null) {
            return checkParam(dto);
        }
        if (dto.getId() == null) {
            return ResultModelFactory.FAILED400("id 不能为空");
        }
        try {
            landingPageService.update(dto, RequestUtils.getCurrentUserName());
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/updateStatus")
    public ResultModel updateStatus(@RequestParam("id") Long id,
                                    @RequestParam("status") Short status) {
        try {
            landingPageService.updateStatus(id, status);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/enableKylin")
    public ResultModel enableKylin(@RequestParam("id") Long id,
                                         @RequestParam("landPageId") Long landPageId,
                                         @RequestParam("enableKylin") Short enableKylin) {
        try {
            landingPageService.enableKylin(id, landPageId, enableKylin);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }


    private ResultModel checkParam(LandingPagePlanDto dto) {
        List<LandingPageConfigVo> landingPageConfigs = dto.getLandingPageConfigVoList();
        if (landingPageConfigs == null) {
            return ResultModelFactory.FAILED400("落地页流量配置不能为空");
        }
        Set<String> nameSet = new HashSet<>();
        for (LandingPageConfigVo landingPageConfig : landingPageConfigs) {
            Double flowRate = landingPageConfig.getFlowRate();
            if (flowRate == null) {
                return ResultModelFactory.FAILED400("流量占比不能为空");
            }
            if (StringUtils.isBlank(landingPageConfig.getName())) {
                return ResultModelFactory.FAILED400("落地页名称不能为空");
            }
            if (StringUtils.isBlank(landingPageConfig.getUrl())) {
                return ResultModelFactory.FAILED400("落地页URL不能为空");
            }
            nameSet.add(landingPageConfig.getName());
        }
        if (landingPageConfigs.size() != nameSet.size()) {
            return ResultModelFactory.FAILED400("输入的落地页名称不能相同");
        }
        return null;
    }

    @PostMapping("/updateFlowRate")
    public ResultModel updateFlowRate(@RequestParam("ticketId") Long ticketId,
                                       @RequestParam("landingPageConfigId") Long landingPageConfigId,
                                       @RequestParam("flowRate") Double flowRate) {
        try {
            landingPageService.updateFlowRate(ticketId, landingPageConfigId, flowRate);
            return ResultModelFactory.SUCCESS();
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
    }
}
