package com.bxm.adsmanager.web.controller.adkeeper;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreative;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PanguCreativeBatchUpdateStatusDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeBatchUpdateTagDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeSearchDTO;
import com.bxm.adsmanager.model.vo.PanguCreativeListVO;
import com.bxm.adsmanager.model.vo.PanguCreativeUploadResultVO;
import com.bxm.adsmanager.model.vo.UploadResultVO;
import com.bxm.adsmanager.service.adkeeper.PanguCreativeService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.GifDecoder;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;

/**
 * <p>
 * 盘古素材库 前端控制器
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-12-7
 */
@RestController
@RequestMapping("/panguCreative")
public class PanguCreativeController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(PanguCreativeController.class);

    @Autowired
    private PanguCreativeService panguCreativeService;

    // OSS上传文件配置
    // @Value("${oss.bucketName}")
    private String bucketName ="bxm-guide";
    //@Value("${oss.fileHost}")
    private String fileHost ="https://buyimg.bianxianmao.com/";
    // @Value("${oss.accessKeyId}")
    private String accessKeyId ="LTAIdRl4etA0hXJt";
    // @Value("${oss.secret}")
    private String secret ="oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    /**
     * 列表信息-分页
     * @param searchDTO
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel<PageInfo<PanguCreativeListVO>> findAll(PanguCreativeSearchDTO searchDTO, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            PageInfo<PanguCreativeListVO> result = panguCreativeService.findAll(user, searchDTO);
            ResultModel rs = new ResultModel<>();
            rs.setReturnValue(result);
            return rs;
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 所有尺寸信息
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/findSize", method = RequestMethod.GET)
    public ResultModel findSize(HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            List<String> result = panguCreativeService.findSize(user);
            ResultModel rs = new ResultModel<>();
            rs.setReturnValue(result);
            return rs;
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 上传素材
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/upload", method = RequestMethod.POST)
    public ResultModel<UploadResultVO> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        //UserVo user = getUser(request, response);
        Integer maxFileSize = 5000*1024;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();

        //校验文件大小
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            MultipartFile file = entity.getValue();
            if(file.getSize() > maxFileSize){
                // 获得文件名称
                String originalFilename = file.getOriginalFilename();
                throw new BusinessException("上传文件[" + originalFilename +"]大小不能超过5000K！");
            }
        }
        PanguCreativeUploadResultVO uploadResultVO = new PanguCreativeUploadResultVO();
        //上传,只上传第一张图
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            MultipartFile file = entity.getValue();

            if (file == null) {
                break;
            }
            // 取得当前上传文件的文件名称
            String fileName = file.getOriginalFilename();
            byte[] bytes = file.getBytes();

            //文件名后缀
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);

            int width =  0;
            int height = 0;
            if("gif".equalsIgnoreCase(suffix)){
                //识别特定的gif文件时有4096的异常导致上传失败
                GifDecoder.GifImage sourceImg = GifDecoder.read(file.getInputStream());
                width = sourceImg.getWidth();
                height = sourceImg.getHeight();
            } else {
                BufferedImage sourceImg = ImageIO.read(file.getInputStream());
                width = sourceImg.getWidth();
                height = sourceImg.getHeight();
            }

            uploadResultVO.setFileName(file.getOriginalFilename());
            uploadResultVO.setMd5(DigestUtils.md5DigestAsHex(bytes));

            panguCreativeService.fillCreativeInfo(uploadResultVO, width, height);
            if (uploadResultVO.getFileExist() || uploadResultVO.getFileSizeExist() == false) {
                break;
            }
            // 如果名称不为空,说明该文件存在，否则说明该文件不存在
            if (StringUtils.isNotBlank(fileName)) {
                File newFile = new File(fileName);
                try {
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    // 文件输出流用于将数据写入文件
                    FileOutputStream outStream = new FileOutputStream(newFile);
                    outStream.write(bytes);
                    outStream.close(); // 关闭文件输出流
                    file.transferTo(newFile);
                    // 上传到阿里云
                    String uploadUrl = AliOSSUtil.upload(accessKeyId, secret, newFile, bucketName, fileHost, null);

                    uploadResultVO.setUrl(uploadUrl);
                } finally {
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                }
            }
            break;
        }

        return ResultModelFactory.SUCCESS(uploadResultVO);
    }


    /**
     * 新增
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel<ArrayList<PanguCreative>> add(@RequestBody @Validated PanguCreativeDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        try {
            ResultModel rs = new ResultModel();
            rs.setReturnValue(panguCreativeService.add(user, dto));
            return rs;
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        } catch (Exception e) {
            return ResultModelFactory.FAIL500("系统出错");
        }
    }

    /**
     * 批量更新状态
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/panguCreative/batchUpdateStatus", keyName = "批量更新状态")
    @RequestMapping(value = "/batchUpdateStatus", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<Boolean> batchUpdateStatus(@RequestBody PanguCreativeBatchUpdateStatusDTO dto, HttpServletRequest request, HttpServletResponse response) {
        //参数校验
        if (BeanValidator.validateGroup(dto, PanguCreativeBatchUpdateStatusDTO.Update.class) != null) {
            return ResultModelFactory.FAIL400(BeanValidator.validateGroup(dto, PanguCreativeBatchUpdateStatusDTO.Update.class).getMessage());
        }
        User user = getUser(request, response);
        try {
            ResultModel rs = new ResultModel();
            rs.setReturnValue(panguCreativeService.batchUpdateStatus(user, dto));
            return rs;
        } catch (Exception e) {
            LOGGER.error("批量更新状态出错" + e.getMessage(), e);
            if (e instanceof BusinessException){
                return ResultModelFactory.FAIL400(e.getMessage());
            }
            return ResultModelFactory.FAIL500("批量更新状态出错");
        }
    }

    /**
     * 批量更新标签
     * @param dto
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/panguCreative/batchUpdateTag", keyName = "批量更新标签")
    @RequestMapping(value = "/batchUpdateTag", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<Boolean> batchUpdateTag(@RequestBody PanguCreativeBatchUpdateTagDTO dto, HttpServletRequest request, HttpServletResponse response) {
        //参数校验
        if (BeanValidator.validateGroup(dto, PanguCreativeBatchUpdateTagDTO.Update.class) != null) {
            return ResultModelFactory.FAIL400(BeanValidator.validateGroup(dto, PanguCreativeBatchUpdateTagDTO.Update.class).getMessage());
        }
        User user = getUser(request, response);
        try {
            ResultModel rs = new ResultModel();
            rs.setReturnValue(panguCreativeService.batchUpdateTag(user, dto));
            return rs;
        } catch (Exception e) {
            LOGGER.error("批量更新标签出错" + e.getMessage(), e);
            if (e instanceof BusinessException){
                return ResultModelFactory.FAIL400(e.getMessage());
            }
            return ResultModelFactory.FAIL500("批量更新标签出错");
        }
    }

}
