package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.RiskWord;
import com.bxm.adsmanager.model.dto.RiskWordDto;
import com.bxm.adsmanager.model.dto.RiskWordQueryDto;
import com.bxm.adsmanager.model.vo.RiskWordVo;
import com.bxm.adsmanager.service.adkeeper.RiskWordService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author tangx
 * @date 2021/9/13 14:06
 */
@RestController
@Slf4j
@RequestMapping("/riskWord")
public class RiskWordController {
    @Autowired
    private RiskWordService riskWordService;

    @GetMapping("/getPage")
    public ResultModel getPage(RiskWordQueryDto queryDto) {
        PageInfo<RiskWordVo> page = riskWordService.getPage(queryDto);
        return ResultModelFactory.SUCCESS(page);
    }

    @PostMapping("/add")
    public ResultModel add(RiskWordDto dto) {
        if (dto.getKeyword().contains(",")) {
            return ResultModelFactory.FAIL400("敏感词汇不能包含逗号");
        }
        riskWordService.add(dto);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/update")
    public ResultModel update(RiskWordDto dto) {
        if (dto.getKeyword().contains(",")) {
            return ResultModelFactory.FAIL400("敏感词汇不能包含逗号");
        }
        if (null == dto.getId()) {
            return ResultModelFactory.FAIL400("id不能为空");
        }
        riskWordService.update(dto);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/updateStatus")
    public ResultModel updateStatus(@RequestParam("ids") String ids, @RequestParam("status")  Integer status) {
        if (StringUtils.isBlank(ids)) {
            return ResultModelFactory.FAIL400("id不能为空");
        }
        riskWordService.updateStatus(ids, status);
        return ResultModelFactory.SUCCESS();
    }

    @GetMapping("/export")
    public ResultModel export(RiskWordQueryDto dto, HttpServletResponse response) {
        dto.setPageSize(Integer.MAX_VALUE);
        PageInfo<RiskWordVo> page = riskWordService.getPage(dto);
        List<RiskWordVo> list = page.getList();
        for (RiskWordVo riskWordVo : list) {
            if (riskWordVo.getStatus() != null) {
                riskWordVo.setStatusExcel(riskWordVo.getStatus().equals(RiskWord.STATUS_OPEN) ? "开启": "关闭");
//                riskWordVo.setModifyTimeExcel(new DateTime(riskWordVo.getModifyTime()).toString("yyyy-MM-dd HH:mm:ss"));
            }
        }
        ExcelUtil.exportExcel(list, null, "敏感词库", RiskWordVo.class, "敏感词库.xls", response);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/import")
    public ResultModel importAdd(@RequestParam("file") MultipartFile file) {

        List<RiskWordVo> orderVos;
        try {
           orderVos = ExcelUtil.importExcelV2(file, RiskWordVo.class);
        } catch (Exception e) {
            throw new BusinessException("文件解析异常");
        }
        if (CollectionUtils.isEmpty(orderVos)) {
            throw new BusinessException("不能导入空文件");
        }
        log.info(orderVos.toString());
        return ResultModelFactory.SUCCESS(riskWordService.importAdd(orderVos));
    }

}
