package com.bxm.adsmanager.web.controller.admin;

import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: zm
 * @date: 2019-08-16 11:15
 * @Description:
 */
@RestController
@RequestMapping("/admin")
public class AdminController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdminController.class);

    @Autowired
    @Qualifier("loadingCacheFetcher")
    private Fetcher fetcher;


    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    /**
     * 订正媒体标签从严控制缓存数据
     *
     * @return
     */
    @GetMapping("/position/controller/rebuild")
    public ResultModel reBuildPositionControllers() {
        String value = fetcher.fetch(new TargetFactory<String>()
                .keyGenerator(TicketKeyGenerator.Media.getMediaTagHighestPositions())
                .cls(String.class)
                .skipNativeCache(false)
                .build());

        //对数据进行rebuild; hash结构存储
        if (StringUtils.isNotBlank(value)) {
            String[] positionIdArray = StringUtils.split(value, CommonConstant.BaseCharacter.COMMA);
            if (positionIdArray != null && positionIdArray.length > 0) {
                for (String positionId : positionIdArray) {
                    if (StringUtils.isNotBlank(positionId)) {
                        updater.hupdate(TicketKeyGenerator.Media.getMediaTagHighestControllers(), positionId, CommonConstant.CACHE_DEFAULT_VALUE);
                    }
                }
            }
        }
        return ResultModelFactory.SUCCESS("OK");
    }

}
