/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adposition;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.activites.facade.service.ActivityBackService;
import com.bxm.adapi.model.EnhanceResultModel;
import com.bxm.adapi.model.exception.AdApiCodeType;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.position.AuditAdPositionDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.ro.AppEntranceEditRo;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAuditVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;

/**
 * @ClassName AdPositionAuditController.java
 * @Description 功能描述： 广告位审核
 * @author leon 2018年4月2日 下午4:26:18
 * @CopyRight 杭州微财网络科技有限公司
 */
@RestController
@EnableAutoConfiguration
@RefreshScope
@RequestMapping(value = "/adPositionAudit")
public class AdPositionAuditController extends BaseController {

    private final static Logger      LOGGER = LoggerFactory.getLogger(AdPositionAuditController.class);

    @Resource
    private AdPositionAuditService   adPositionAuditService;

    @Resource
    private ActivityBackService      activityBackService;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    /**
     * 业务层自动注入
     */
    @Autowired
    private MediaService mediaService;

    @Autowired
    private TblAdTagService tblAdTagService;

    @Autowired
    private JedisUpdater jedisUpdater;


    /**
     * Description: 运营后台查询审核页面的 广告位列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/25 14:30
     *
     * @param keywords 广告位ID 或 广告位别名
     * @param status   状态
     * @param mjCode   媒介code
     * @param pageNum  页码
     * @param pageSize 页面大小
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmedia.facade.model.appentrance.AppEntranceAuditVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/getAuditPage", method = RequestMethod.GET)
    ResultModel<PageInfo<AppEntranceAuditVO>> getAuditPage(@RequestParam(name = "keywords", required = false) String keywords,
                                                           @RequestParam(name = "status") Byte status,
                                                           @RequestParam(name = "providerId",required = false,defaultValue = "-1") Long providerId,
                                                           @RequestParam(name = "mjCode", required = false) String mjCode,
                                                           @RequestParam(name = "areaType", required = false) Integer areaType,
                                                           @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
                                                           HttpServletRequest request,
                                                           HttpServletResponse response) {
        User user = getUser(request, response);
        if (user.getRoleCodes()==null){
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        //媒介经理和风控可以看到所有的
        Boolean look_all = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()) ;
        if(look_all == false){
            mjCode = user.getUsername();
        }
        return ResultModelFactory.SUCCESS(adPositionAuditService.getAuditPage(keywords, status,providerId, mjCode, areaType, pageNum, pageSize));
    }

    /**
     * Description: 广告位 开启/关闭
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/29 17:03
     *
     * @param positionId 广告位ID
     * @param closeFlag  是否开关， true开，false关
     * @return com.bxm.warcar.utils.response.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @LogBefore(operType = "/adPositionAudit/positionSwitch", keyName = "广告位 开启/关闭")
    @RequestMapping(value = "/positionSwitch", method = RequestMethod.POST)
    ResultModel<Boolean> positionSwitch(@RequestParam("positionId") String positionId,
                                        @RequestParam("closeFlag") Boolean closeFlag,
                                        HttpServletRequest request,
                                        HttpServletResponse response) {
        boolean result = newAppEntranceFacadeIntegration.positionSwitch(positionId, closeFlag, getUser(request, response).getUsername());
        if (!result) {
            throw new BusinessException("开关广告位失败！");
        }
        return ResultModelFactory.SUCCESS(true);
    }


    /**
     * @Description 审核广告位信息
     * @author leon 2018年4月2日 下午3:56:34
     * @CopyRight 杭州微财网络科技有限公司
     * @param dto
     * @return
     * @throws Exception
     */
    @LogBefore(operType = "/adPositionAudit/auditAdPosition", keyName = "审核广告位信息")
    @RequestMapping(value = "/auditAdPosition", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> auditAdPosition(AuditAdPositionDto dto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!dto.getState().equals(1) && !dto.getState().equals(2)) {
            throw new BusinessException("参数不正确！");
        }
        if (CollectionUtils.isEmpty(dto.getIds())) {
            throw new BusinessException("id集合不能为空！");
        }
        String idsStr = Joiner.on(CommonConstant.BaseCharacter.COMMA).skipNulls().join(dto.getIds());

        User user = getUser(request, response);
        if (user.getRoleCodes()==null){
            user.setRoleCodes(Collections.emptyList());
        }
        Boolean isMJ = user.getRoleCodes().contains(RoleEnum.MJ.getCode()) || user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        isMJ=isMJ&&fk?false:isMJ;
        if(!isMJ && !fk){
            throw new BusinessException("只有媒介/媒介经理/风控角色可以操作审核！");
        }

        //媒介/媒介经理是初审，否则就是终审（风控）
        boolean auditPass = dto.getState().equals(1);
        List<Long> successIds = newAppEntranceFacadeIntegration.batchAudit(idsStr, auditPass, isMJ,
                dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
        if (CollectionUtils.isEmpty(successIds)) {
            throw new BusinessException("审核失败！请确认选择的广告位所在的媒体和开发者财务信息是否通过审核。");
        }
        // 若审核拒绝广告位,则修改之后直接返回
        if (auditPass == false) {
            return ResultModelFactory.SUCCESS(true);
        }

        //20210325-风控优化 http://47.110.160.70:8090/pages/viewpage.action?pageId=25993887
        if(isMJ){
            isMJ = false;  //不是媒介那就是风控
            List<Long> fkAuditSuccessIds = newAppEntranceFacadeIntegration.batchAudit(idsStr, auditPass, isMJ,
                    dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
            if (CollectionUtils.isEmpty(fkAuditSuccessIds)) {
                throw new BusinessException("审核失败！请确认选择的广告位所在的媒体和开发者财务信息是否通过审核。");
            }
        }

        //添加广告位标签
        adPositionAuditService.positionAddTag(dto.getIds());

        return ResultModelFactory.SUCCESS(true);
    }

    /**
     * @Description 方法描述：编辑广告位信息
     * @author 拉拉
     * @CopyRight 杭州微财网络科技有限公司
     * @param
     * @return
     * @throws Exception
     */
    @LogBefore(operType = "/adPositionAudit/updateAdPositionInfo", keyName = "编辑广告位信息")
    @RequestMapping(value = "/updateAdPositionInfo", method = RequestMethod.PUT, produces = "application/json")
    public com.bxm.adapi.facade.model.ResultModel<Boolean> updateAdPositionInfo(HttpServletRequest request,
                                                                                AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        com.bxm.adapi.facade.model.ResultModel<Boolean> result = new EnhanceResultModel<>();
        try {
            LOGGER.info("修改广告位信息,请求参数:{}", appEntranceEditRo);
            User user = getUser(request, null);

            if (appEntranceEditRo.getId() != null) {
                AppEntranceAdRO appEntrance = adPositionAuditService.findPositionById(appEntranceEditRo.getId());
                String oldCooperationType = appEntrance.getCooperationType();
                Byte newCooperationType = appEntranceEditRo.getCooperationType();
                Boolean isUpdateCooperationType = StringUtils.isNotBlank(oldCooperationType) && ObjectUtils.notEqual(oldCooperationType, newCooperationType.toString());
                // 只有运营经理有权限修改合作类型
                if (isUpdateCooperationType) {
                    if (UserRoleCodeUtil.isNotMJLeader(user)) {
                        result.setSuccessed(false);
                        result.setErrorDesc("仅媒介经理权限可以修改合作类型");
                        return result;
                    }
                }
            }

            result.setReturnValue(adPositionAuditService.updateAdPositionInfo(appEntranceEditRo, user.getUsername()));
        } catch (ValidateException e) {
            LOGGER.error("修改广告位信息发生异常:", e);
            result = new com.bxm.adapi.facade.model.ResultModel<>();// 应该是用adsmanager的code
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("修改广告位信息发生未知错误:", e);
            result = new EnhanceResultModel<>(AdApiCodeType.SYSTEM_ERROR);// 应该是用adsmanager的code
        }
        return result;
    }
    /**
     * @Description 方法描述：编辑广告位信息
     * @author 拉拉
     * @CopyRight 杭州微财网络科技有限公司
     * @param
     * @return
     * @throws Exception
     */
    @LogBefore(operType = "/adPositionAudit/batchsaveOrUpdate", keyName = "编辑广告位信息")
    @RequestMapping(value = "/batchsaveOrUpdate",  produces = "application/json")
    public ResultModel<Boolean> batchsaveOrUpdate(HttpServletRequest request,
                                                                             AppEntranceEditRo appEntranceEditRo
                                                                             ) throws ValidateException {
        ResultModel<Boolean> result = new ResultModel<>();
        try {
            result.setReturnValue(adPositionAuditService.batchsaveOrUpdate(appEntranceEditRo));
        }  catch (Exception e) {
            LOGGER.error("批量修改前置发生异常:", e);
        }
        return result;
    }
    @RequestMapping(value = "/updateOldKf", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Boolean> updateOldKf(HttpServletRequest request) throws ValidateException {
        ResultModel<Boolean> result = new ResultModel<>();
        try {
            LOGGER.info("开始订正客服数据默认配置");
            result.setReturnValue(adPositionAuditService.updateOldKf());
        }  catch (Exception e) {
            LOGGER.error("订正客服数据默认配置发生未知错误:", e);
            result.setSuccessed(false);
        }
        return result;
    }

    /**
     * @Description 方法描述：订正广告位激励券默认配置
     * @author zhengwangeng
     * @CopyRight 杭州微财网络科技有限公司
     * @param
     * @return
     * @throws Exception
     */
    @LogBefore(operType = "/adPositionAudit/updateAdPositionRewardConfigForExist", keyName = "订正广告位激励券默认配置")
    @RequestMapping(value = "/updateAdPositionRewardConfigForExist", method = RequestMethod.GET, produces = "application/json")
    public com.bxm.adapi.facade.model.ResultModel<Boolean> updateAdPositionRewardConfigForExist(HttpServletRequest request) throws ValidateException {
        com.bxm.adapi.facade.model.ResultModel<Boolean> result = new EnhanceResultModel<>();
        try {
            LOGGER.info("开始订正广告位激励券默认配置");
            result.setReturnValue(adPositionAuditService.saveOrUpdateAdPositionInfoForExist());
        } catch (ValidateException e) {
            LOGGER.error("订正广告位激励券默认配置发生异常:", e);
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("订正广告位激励券默认配置发生未知错误:", e);
            result.setSuccessed(false);
        }
        return result;
    }

    /**
     * @param positionId,广告位id ;status 状态 0开启  1 关闭
     * @return
     * @throws Exception
     * @Description 方法描述：审核广告位信息
     * @author leon 2018年4月2日 下午3:56:34
     * @CopyRight 杭州微财网络科技有限公司
     */
    @LogBefore(operType = "/adPositionAudit/updatePositionDomainCode", keyName = "管理广告位行业标签")
    @RequestMapping(value = "/updatePositionDomainCode", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<String> updatePositionDomainCode(HttpServletRequest request, HttpServletResponse response,
                                                         @RequestParam("positionId") String positionId,
                                                         @RequestParam("status") Integer status
                                                         ) throws Exception {
        ResultModel<String>  resultModel=new ResultModel<>();
        //开始判断是否有权限，只有媒介经理有权限
        User user = getUser(request, null);
        if(user.getRoleCodes()!=null &&( user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())
                || user.getRoleCodes().contains(RoleEnum.RTB_LEADER.getCode()) )){
            if(status == 0){
                //如果广告位开关开启,则移除(只要redis没有的数据 都是广告位行业开启的)
                jedisUpdater.hremove(CommonConstant.getKeyGeneratorByPositionDomainiCode(), positionId);
            }else{
                //如果广告位开关关闭,则添加一条数据
                jedisUpdater.hupdate(CommonConstant.getKeyGeneratorByPositionDomainiCode(), positionId, DateUtil.dateTo8String(new Date()));
            }
             resultModel.setReturnValue("开启或者关闭成功");

        }else{
              resultModel.setReturnValue("只有媒介经理/RTB运营经理 有权限添加");;
        }
        return resultModel;
    }

    /**
     * 修改广告位票券信息
     * @param request
     * @param appEntranceEditRo
     * @return
     * @throws ValidateException
     */
    @LogBefore(operType = "/adPositionAudit/updateCouponsInfo", keyName = "修改广告位票券信息")
    @RequestMapping(value = "/updateCouponsInfo", method = RequestMethod.PUT, produces = "application/json")
    public com.bxm.adapi.facade.model.ResultModel<Boolean> updateCouponsInfo(HttpServletRequest request,
                                                                                AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        com.bxm.adapi.facade.model.ResultModel<Boolean> result = new EnhanceResultModel<>();
        try {
            User user = getUser(request, null);
            result.setReturnValue(adPositionAuditService.updateCouponsInfo(appEntranceEditRo, user.getUsername()));
        } catch (ValidateException e) {
            LOGGER.error("修改广告位票券信息发生异常:", e);
            result = new com.bxm.adapi.facade.model.ResultModel<>();// 应该是用adsmanager的code
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("修改广告位票券信息发生未知错误:", e);
            result = new EnhanceResultModel<>(AdApiCodeType.SYSTEM_ERROR);// 应该是用adsmanager的code
        }
        return result;
    }

    /**
     * 修改广告位投放信息
     * @param request
     * @param appEntranceEditRo
     * @return
     * @throws ValidateException
     */
    @LogBefore(operType = "/adPositionAudit/updatePutinTypeInfo", keyName = "修改广告位投放信息")
    @RequestMapping(value = "/updatePutinTypeInfo", method = RequestMethod.PUT, produces = "application/json")
    public com.bxm.adapi.facade.model.ResultModel<Boolean> updatePutinTypeInfo(HttpServletRequest request,
                                                                                AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        com.bxm.adapi.facade.model.ResultModel<Boolean> result = new EnhanceResultModel<>();
        try {
            User user = getUser(request, null);
            result.setReturnValue(adPositionAuditService.updatePutinTypeInfo(appEntranceEditRo, user.getUsername()));
        } catch (ValidateException e) {
            LOGGER.error("修改广告位投放信息发生异常:", e);
            result = new com.bxm.adapi.facade.model.ResultModel<>();// 应该是用adsmanager的code
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("修改广告位投放信息发生未知错误:", e);
            result = new EnhanceResultModel<>(AdApiCodeType.SYSTEM_ERROR);// 应该是用adsmanager的code
        }
        return result;
    }

    /**
     * 修改广告位上小程序投放
     * @param request
     * @param appEntranceEditRo:
     * {
     * 	appKey:1111111111111,
     * 	business:5,
     * 	wechatMiniAppPutFlag:1   //小程序投放0:关闭，1:开启
     * }
     * @return
     * @throws ValidateException
     */
    @LogBefore(operType = "/adPositionAudit/updateWechatMiniAppPutInfo", keyName = "修改广告位小程序投放信息")
    @RequestMapping(value = "/updateWechatMiniAppPutInfo", method = RequestMethod.PUT, produces = "application/json")
    public com.bxm.adapi.facade.model.ResultModel<Boolean> updateWechatMiniAppPutInfo(HttpServletRequest request,
                                                                                AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        com.bxm.adapi.facade.model.ResultModel<Boolean> result = new EnhanceResultModel<>();
        try {
            User user = getUser(request, null);
            if (StringUtils.isEmpty(appEntranceEditRo.getAppKey()) || StringUtils.isEmpty(appEntranceEditRo.getBusiness())){
                throw new ValidateException("appkey或者business为空");
            }
            String adPositionId = appEntranceEditRo.getAppKey().concat("-").concat(appEntranceEditRo.getBusiness());
            result.setReturnValue(adPositionAuditService.updateWechatMiniAppPutInfo(adPositionId, appEntranceEditRo.getWechatMiniAppPutFlag(), user.getUsername()));
        } catch (ValidateException e) {
            LOGGER.error("修改广告位小程序投放信息发生异常:", e);
            result = new com.bxm.adapi.facade.model.ResultModel<>();// 应该是用adsmanager的code
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("修改广告位小程序投放信息发生未知错误:", e);
            result = new EnhanceResultModel<>(AdApiCodeType.SYSTEM_ERROR);// 应该是用adsmanager的code
        }
        return result;
    }
}
