    package com.bxm.adsmanager.web.controller.adprofit;

    import com.alibaba.fastjson.JSON;
    import com.alibaba.fastjson.JSONObject;
    import com.bxm.adsmanager.ecxeption.ProfitException;
    import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
    import com.bxm.adsmanager.model.dao.adprofit.LocalCache;
    import com.bxm.adsmanager.model.dao.position.PositionDefaultPercent;
    import com.bxm.adsmanager.model.dao.position.PositionDefaultPercentVo;
    import com.bxm.adsmanager.model.dao.report.InfoAppMsg;
    import com.bxm.adsmanager.model.dao.user.User;
    import com.bxm.adsmanager.model.dto.AdMediaPositionProfitSearchDto;
    import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
    import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
    import com.bxm.adsmanager.model.enums.RoleEnum;
    import com.bxm.adsmanager.model.vo.Pagination;
    import com.bxm.adsmanager.model.vo.adprofit.AdProfitAllVo;
    import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
    import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
    import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
    import com.bxm.adsmanager.service.adprofit.impl.AdProfitMediaPositionCheckServiceImpl;
    import com.bxm.adsmanager.utils.*;
    import com.bxm.adsmanager.web.controller.base.BaseController;
    import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
    import com.bxm.util.StringUtil;
    import com.bxm.util.dto.ResultModel;
    import com.bxm.warcar.aspect.before.LogBefore;
    import com.github.pagehelper.PageInfo;
    import org.apache.commons.lang.StringUtils;
	import org.slf4j.Logger;
	import org.slf4j.LoggerFactory;
	import org.springframework.beans.factory.annotation.Autowired;
    import org.springframework.web.bind.annotation.*;
    import org.springframework.web.multipart.MultipartFile;
    import org.springframework.web.multipart.MultipartHttpServletRequest;

    import javax.servlet.http.HttpServletRequest;
    import javax.servlet.http.HttpServletResponse;
    import java.util.ArrayList;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;

/**
 * @Title: AdProfitMediaPositionController
 * @Description: 媒体广告位收益信息
 * @author xavier
 * @date 2018年3月10日
 */
@RequestMapping("/adProfitMediaPosition")
@RestController
public class AdProfitMediaPositionController extends BaseController{

	private static final Logger LOGGER 		= LoggerFactory.getLogger(AdProfitMediaPositionController.class);

	private static final int DEFULT_ONE = 1;

	@Autowired
	private AdProfitMediaPositionService adProfitMediaPositionService;

	//新增媒体、广告位的校验类
	@Autowired
	private AdProfitMediaPositionCheckServiceImpl adProfitMediaPositionCheckService;
	
	//app提供接口
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    
	/**
	 * @Title: findAll
	 * @Description:  开发者收益信息
	 * @author xavier
	 * @date 2018年3月10日
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<List<AdProfitAllVo>> findAll(HttpServletRequest request,
													HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<List<AdProfitAllVo>> rs = new ResultModel<List<AdProfitAllVo>>();
		try {
			List<AdProfitAllVo> lists = adProfitMediaPositionService.findAll(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			LOGGER.error("开发者总收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("开发者总收益查询错误");
		}
		return rs;
	}

	/**
	 * @Title: findMediaProfit
	 * @Description:  查询媒体收益列表分页
	 * @author xavier
	 * @date 2018年3月10日
	 */
	@RequestMapping(value = "/findMediaProfit", method = RequestMethod.GET)
	public ResultModel<Pagination> findMediaProfit(HttpServletRequest request,
												   HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {
			Pagination lists = adProfitMediaPositionService.findMediaProfit(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			LOGGER.error("开发者收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("开发者收益查询错误");
		}
		return rs;
	}

	/**
	 * @Title: findPositionProfit
	 * @Description:  查询广告位收益列表分页
	 * @author xavier
	 * @date 2018年3月10日
	 */
	@RequestMapping(value = "/findPositionProfit", method = RequestMethod.GET)
	public ResultModel<Pagination> findPositionProfit(HttpServletRequest request,
													  HttpServletResponse response,AdMediaPositionProfitSearchDto search){
	    // 注意，运营后台调用的是：adssettlement的接口18512
		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {
			Pagination lists = adProfitMediaPositionService.findPositionProfit(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			LOGGER.error("广告位收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("广告位收益查询错误");
		}
		return rs;
	}

	/**
	 * @description  导入收益Excel表格 //todo 此接口为了配合前端的参数校验，迁到excel包下面
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/importProfit")
	@RequestMapping(value = "/importProfit", method = RequestMethod.POST)
	@Deprecated
	public ResultModel<Pagination> importProfitExcel(HttpServletRequest request,
													 HttpServletResponse response){
		try {
			MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
			Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
			User user = getUser(request, response);
			for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
				MultipartFile file = entity.getValue();// 获取上传文件对象
				// 获得文件名称
				String originalFilename = file.getOriginalFilename();
				if (originalFilename.indexOf("媒体收益")!=-1) {
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("实际收益", "profitActual");
					fieldMap.put("备注", "remark");
					List<AdProfitMediaDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"媒体收益", AdProfitMediaDto.class, fieldMap, DEFULT_ONE);
					//ExcelUtil.importExcel(file,DEFULT_ONE,DEFULT_ONE,AdProfitMediaVo.class);
					adProfitMediaPositionService.importAdProfitMediaExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}else if(originalFilename.indexOf("广告位收益")!=-1){
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("广告位ID", "positionId");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("扣量金额", "profitDeduct");
					fieldMap.put("备注", "remark");
					List<AdProfitPositionDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"广告位收益", AdProfitPositionDto.class, fieldMap, DEFULT_ONE);
					adProfitMediaPositionService.importAdProfitPositionExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}else {
					return ResultModelFactory.FAIL500("导入失败(表格名称不识别)");
				}
			}
		} catch (ProfitException pe) {
			return ResultModelFactory.FAIL500(pe.getMessage());
		}catch (Exception e) {
			LOGGER.error("导入媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("导入媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 下载媒体收益Excel表格  //todo 此接口为了配合前端的参数校验，迁到excel包下面
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/downLoadMedia")
	@RequestMapping(value = "/downLoadMedia", method = RequestMethod.GET)
	@Deprecated
	public ResultModel downLoadMediaExcel(HttpServletRequest request,
										  HttpServletResponse response,
										  @RequestParam(required = true, name = "datetime") String datetime){
		try {
			List<AdProfitMediaVo> list = adProfitMediaPositionService.downLoadMedia(datetime);
			//导出操作
			ExcelUtil.exportExcel(list, null, "媒体收益", AdProfitMediaVo.class, "媒体收益"+datetime+".xls", response);
		} catch (Exception e) {
			LOGGER.error("下载媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("下载媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 下载广告位收益Excel表格 //todo 此接口为了配合前端的参数校验，迁到excel包下面
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/downLoadPosition")
	@RequestMapping(value = "/downLoadPosition", method = RequestMethod.GET)
	@Deprecated
	public ResultModel downLoadPositionExcel(HttpServletRequest request,
											 HttpServletResponse response,
											 @RequestParam(required = true, name = "datetime") String datetime,
											 @RequestParam(required = false, name = "appId") String appId){
		try {
			List<AdProfitPositionVo> list = adProfitMediaPositionService.downLoadPosition( datetime,appId);
			//导出操作
			ExcelUtil.exportExcel(list, null, "广告位收益", AdProfitPositionVo.class, "广告位收益"+datetime+".xls", response);
		} catch (Exception e) {
			LOGGER.error("下载广告位收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("下载广告位收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 导入
	 * @author hcmony
	 * @time 2018/3/16
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/entering")
	@RequestMapping(value = "/entering", method = RequestMethod.POST)
	public ResultModel entering(HttpServletRequest request, HttpServletResponse response,
								@RequestParam(required = true, name = "datetime") String datetime){

		try {
			synchronized (this){
				Boolean flag = LocalCache.map.get(datetime);
				if(flag!=null&&flag){
					LOGGER.info("数据在录入中，请稍候再试,datetime:"+datetime);
					return ResultModelFactory.FAIL400("数据在录入中，请稍候再试");
				}
				LocalCache.map.put(datetime,true);
			}
			User user = getUser(request, response);
			adProfitMediaPositionService.entering(user,datetime);
			LocalCache.map.remove(datetime);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			LocalCache.map.remove(datetime);
			LOGGER.error("礼券收益收益录入错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	//新增加的接口20180612
	/**
	 * @Title: findMediaProfitByTime
	 * @Description: 查询媒体收益列表-无分页
	 * @date 2018年6月12日
	 */
	@RequestMapping(value = "/mediaProfitByTime", method = RequestMethod.GET)
	public ResultModel<List<AdProfitMediaVo>> findMediaProfitByTime(HttpServletRequest request,
																	HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<List<AdProfitMediaVo>> rs = new ResultModel<List<AdProfitMediaVo>>();
		if(null == search || ( search != null && StringUtil.isBlank(search.getDatetime()))){
			LOGGER.error("开发者收益查询时间不能为空");
			rs.setSuccessed(false);
			rs.setErrorDesc("查询时间不能为空");
			return rs;
		}
		User user = getUser(request, response);
		/*//如果用户只为普通媒介角色CODE 则加上限制
		if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
				user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
			search.setUserName(user.getUsername());
		}*/
		//登录角色是mj时
		if (StringUtils.isNotBlank(UserRoleCodeUtil.isMj(user))){
			search.setUserName(user.getUsername());
		}
		//登录角色是bd时
		if (StringUtils.isNotBlank(UserRoleCodeUtil.isBd(user))){
			search.setBd(user.getUsername());
		}

		List<AdProfitMediaVo> lists = null;
		try {
			lists = adProfitMediaPositionService.selectMediaProfitByTime(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			LOGGER.error("开发者收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("开发者收益查询错误");
		}
		return rs;
	}

	/**
	 * 根据权限查询 媒体
	 *
	 * @param httpServletRequest
   * @param httpServletResponse
   * @param keyWord
	 * @return java.util.List<java.lang.String>
	 * @throws
	 * @author kk.xie
	 * @date 2018/7/6 10:04
	 */
	@RequestMapping(value = "/findAllMediaByRole", method = RequestMethod.GET)
	public ResultModel<List<InfoAppMsg>> findAllMediaByRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String keyWord){
		ResultModel<List<InfoAppMsg>> resultModel = new ResultModel<>();
		User user = getUser(httpServletRequest, httpServletResponse);
		ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
		//如果用户只findDefaultPercent为普通媒介角色CODE 则加上限制
		if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
				user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
		    //设置媒介code
		    providerAppAdDto.setMedium(user.getUsername());
		}
		if(StringUtils.isNotEmpty(keyWord)){
		    //设置媒体名称或者appKey
			providerAppAdDto.setKeywords(keyWord.trim());
		}
		resultModel.setReturnValue(AppEntityConvertHelper.appListConvertToInfoAppMsgList(providerFacadeIntegration.getProviderAppList(providerAppAdDto)));
		//resultModel.setReturnValue(adProfitMediaPositionService.findAllByRole(param));
		return resultModel;
	}

	/**
	 * @Title: findPositionProfitByTime
	 * @Description: 查询广告位收益列表-无分页
	 * @date 2018年6月12日
	 */
	@RequestMapping(value = "/positionProfitByTime", method = RequestMethod.GET)
	public ResultModel<List<AdProfitPositionVo>> findPositionProfitByTime(HttpServletRequest request,
																		  HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<List<AdProfitPositionVo>> rs = new ResultModel<List<AdProfitPositionVo>>();
		if(null == search || ( search != null && StringUtil.isBlank(search.getDatetime()))){
			LOGGER.error("广告位收益查询时间不能为空");
			rs.setSuccessed(false);
			rs.setErrorDesc("查询时间不能为空");
			return rs;
		}
		User user = getUser(request, response);
		/*//如果用户只为普通媒介角色CODE 则加上限制
		if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
				user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
			search.setUserName(user.getUsername());
		}*/
		//登录角色是mj时
		if (StringUtils.isNotBlank(UserRoleCodeUtil.isMj(user))){
			search.setUserName(user.getUsername());
		}
		//登录角色是bd时
		if (StringUtils.isNotBlank(UserRoleCodeUtil.isBd(user))){
			search.setBd(user.getUsername());
		}
		List<AdProfitPositionVo> lists = null;
		try {
			lists = adProfitMediaPositionService.selectPositionProfitByTime(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			LOGGER.error("广告位收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("广告位收益查询错误");
		}
		return rs;
	}


	/**
	 * @Title: updateMediaProfitByTime
	 * @Description: 修改媒体收益列表
	 * @date 2018年6月12日
	 */
	@LogBefore(keyName = "媒体",operType = "/adProfitMediaPosition/mediaProfitByTime")
	@RequestMapping(value = "/mediaProfitByTime", method = RequestMethod.PUT)
	public ResultModel<String> updateMediaProfitByTime(HttpServletRequest request,
													   HttpServletResponse response,@RequestBody String params,
													   @RequestParam(required = true, name = "datetime") String datetime,
													   @RequestParam(required = false, name = "token") String token){
		List<AdProfitMediaDto> lists = null;
		ResultModel<String> rs = new ResultModel<String>();
		JSONObject jsonObject = null;
		try {
			jsonObject = JSONObject.parseObject(params);
			if(null != jsonObject){
				lists = JSON.parseArray(jsonObject.getString("data"), AdProfitMediaDto.class);
			}
			else{
				lists = new ArrayList<AdProfitMediaDto>();
			}
		} catch (Exception e) {
			rs.setSuccessed(false);
			rs.setErrorDesc("json解析异常");
			return rs;
		}
		User user = getUser(request, response);
		//如果用户只为普通媒介角色CODE 则加上限制
		//媒介修改的权限控制-媒介在13:00点之后不能修改昨日的媒体录入数据,媒介经理无限制
		if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
				user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
			ResultModel<String> checkAuth = adProfitMediaPositionCheckService.checkAuth(datetime);
			if(checkAuth.isSuccessed() == false){
				return checkAuth;
			}
		}
		//参数校验
		ResultModel<String> checkMediaProfit = adProfitMediaPositionCheckService.checkMediaProfit(lists);
		if(checkMediaProfit.isSuccessed() == false){
			return checkMediaProfit;
		}
		try {
			adProfitMediaPositionService.updateAdProfitMedia(user,lists);
		} catch (ProfitException e) {
            LOGGER.error("修改开发者收益错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("修改开发者收益错误");
		}
		return rs;
	}

	/**
	 * @Title: updatePositionProfitByTime
	 * @Description: 修改广告位收益列表
	 * @date 2018年6月12日
	 */
	@LogBefore(keyName = "广告位",operType = "/adProfitMediaPosition/positionProfitByTime")
	@RequestMapping(value = "/positionProfitByTime", method = RequestMethod.PUT)
	public ResultModel<String> updatePositionProfitByTime(HttpServletRequest request,
														  HttpServletResponse response,@RequestBody String params,
														  @RequestParam(required = true, name = "datetime") String datetime,
														  @RequestParam(required = false, name = "token") String token){
		List<AdProfitPositionDto> lists= null;
		ResultModel<String> rs = new ResultModel<String>();
		JSONObject jsonObject = null;
		try {
			jsonObject = JSONObject.parseObject(params);
			if(null != jsonObject){
				lists = JSON.parseArray(jsonObject.getString("data"), AdProfitPositionDto.class);
			}
			else{
				lists = new ArrayList<AdProfitPositionDto>();
			}
		} catch (Exception e) {
			rs.setSuccessed(false);
			rs.setErrorDesc("json解析异常");
			return rs;
		}

		User user = getUser(request, response);
		//如果用户只为普通媒介角色CODE 则加上限制
		//媒介修改的权限控制-媒介在13:00点之后不能修改昨日的媒体录入数据,媒介经理无限制
		if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
				user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
			ResultModel<String> checkAuth = adProfitMediaPositionCheckService.checkAuth(datetime);
			if(checkAuth.isSuccessed() == false){
				return checkAuth;
			}
		}
		//参数校验
		ResultModel<String> checkPositionProfit = adProfitMediaPositionCheckService.checkPositionProfit(lists);
		if(checkPositionProfit.isSuccessed() == false){
			return checkPositionProfit;
		}
		try {
			adProfitMediaPositionService.updateAdProfitPosition(user,lists);
		} catch (ProfitException e) {
            LOGGER.error("修改广告位收益错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("修改广告位收益错误");
		}
		return rs;
	}

	/**
	 *
	 * 功能描述: 获取广告位默认分成比例列表
	 * @fileName:
	 * @param: [appkeyName, positionName, pageNum, pageSize, request, response]
	 * @return: com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmanager.model.dao.position.PositionDefaultPercentVo>>
	 * @auther: sunzs
	 * @date: 2018/11/22 10:51
	 */
    @RequestMapping(value = "/findDefaultPercent", method = RequestMethod.GET)
    public ResultModel<PageInfo<PositionDefaultPercentVo>> findDefaultPercent(@RequestParam("appkeyName")String appkeyName,
																			  @RequestParam("positionName")String positionName,
																			  @RequestParam(value = "pageNum",defaultValue = "1")Integer pageNum,
																			  @RequestParam(value = "pageSize",defaultValue = "20")Integer pageSize,
																			  HttpServletRequest request, HttpServletResponse response){
        ResultModel rs = new ResultModel<>();
        User user = getUser(request, response);
        try {

			rs.setReturnValue(adProfitMediaPositionService.findDefaultPercent(user,appkeyName,positionName,pageNum,pageSize));
		}catch (Exception e){
			e.printStackTrace();
			LOGGER.error("广告位默认分成比例列表获取失败");
		}
        return rs;
    }

	/**
	 *
	 * 功能描述:根据多个广告位id获取广告位默认分成比例
	 * @fileName:
	 * @param: [positionIds]
	 * @return: com.bxm.util.dto.ResultModel
	 * @auther: sunzs
	 * @date: 2018/11/22 10:52
	 */
    @RequestMapping(value = "/findPercentByPositionIds",method = RequestMethod.POST)
	public ResultModel findPercentByPositionIds(@RequestParam("positionIds")String positionIds){
		ResultModel rs = new ResultModel<>();
		try {
			rs.setReturnValue(adProfitMediaPositionService.findPercentByPositionId(positionIds));
		}catch (Exception e){
			rs.setSuccessed(false);
			LOGGER.error("广告位默认分成比例获取失败"+e.getMessage(),e);
		}
		return rs;
	}

	/**
	 *
	 * 功能描述: 修改默认分成比例
	 * @fileName:
	 * @param: [positionDefaultPercent]
	 * @return: com.bxm.util.dto.ResultModel
	 * @auther: sunzs
	 * @date: 2018/11/22 11:19
	 */
	@RequestMapping(value = "/updatePercentByPositionId",method = RequestMethod.POST)
	public ResultModel updatePercentByPositionId(PositionDefaultPercent positionDefaultPercent){
		ResultModel rs = new ResultModel<>();
		rs.setReturnValue(adProfitMediaPositionService.updatePercentByPositionId(positionDefaultPercent));
		return rs;
	}


}
