package com.bxm.adsmanager.web.controller.adprofit;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.adprofit.DeveloperProfitDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo;
import com.bxm.adsmanager.service.adprofit.DeveloperProfitService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * <p>媒体结算功能中，开发者收益相关信息</p>
 *
 * @Description:开发者收益信息
 * @Author: JandMin
 * @Date: 2018/6/11
 */
@RestController
@RequestMapping("/developer")
public class DeveloperProfitController extends BaseController {
    private final static Logger LOG = LoggerFactory.getLogger(DeveloperProfitController.class);
    @Autowired
    private DeveloperProfitService developerProfitService;

    private static boolean isSettled = false;

    /**
     * @description: 获取开发者收益汇总金额数据
     * @author: JandMin
     * @time: 2018/6/12 10:38
     * @param request
     * @param response
     * @param search
     * @return java.lang.String
     */
    @RequestMapping(value = "/getTotalProfit",method = RequestMethod.GET)
    public String getTotalProfit(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search){
        ResultModel<DeveloperProfitVo> rs = new ResultModel<DeveloperProfitVo>();
        try {
            DeveloperProfitVo profit = developerProfitService.getTotalProfit(search);
            rs.setReturnValue(profit);
        } catch(ProfitException e){
            LOG.error("获取开发者收益列表异常："+e.getMessage(), e);
            return JSONObject.toJSONString(ResultModelFactory.FAIL400("获取开发者收益列表异常:"+e.getMessage()));
        } catch(Exception e){
            LOG.error("获取开发者收益列表错误："+e.getMessage(), e);
            return JSONObject.toJSONString(ResultModelFactory.FAIL500("获取开发者收益列表错误:"+e.getMessage()));
        }
        return JSONObject.toJSONString(rs);
    }

    /**
     * @description:  获取开发者收益列表数据
     * @author: JandMin
     * @time: 2018/6/13 17:52
     * @param request
     * @param response
     * @param search
     * @return java.lang.String
     */
    @RequestMapping(value = "/findProfitList",method = RequestMethod.GET)
    public String findProfitList(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search){
        ResultModel<Pagination> rs = new ResultModel<Pagination>();
        try {
            Pagination resultList = developerProfitService.findProfitList(search);
            rs.setReturnValue(resultList);
        } catch(ProfitException e){
            LOG.error("获取开发者日结算列表异常："+e.getMessage(), e);
            return JSONObject.toJSONString(ResultModelFactory.FAIL400("获取开发者日结算列表异常："+e.getMessage()));
        } catch(Exception e){
            LOG.error("获取开发者日结算列表错误："+e.getMessage(), e);
            return JSONObject.toJSONString(ResultModelFactory.FAIL500("获取开发者日结算列表错误："+e.getMessage()));
        }
        return JSONObject.toJSONString(rs);
    }

    /**
     * @description: 获取某个时段内的开发者信息和结算信息列表
     * @author: JandMin
     * @time: 2018/6/13 17:43
     * @param request
     * @param response
     * @param search
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
     */
    @RequestMapping(value = "/findProfitByDate",method = RequestMethod.GET)
    public ResultModel<Pagination> findProfitByDate(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search){
        ResultModel<Pagination> rs = new ResultModel<Pagination>();
        try {
            Pagination resultList = developerProfitService.findProfitByDate(search);
            rs.setReturnValue(resultList);
        } catch(ProfitException e){
            LOG.error("获取开发者信息和结算信息列表异常："+e.getMessage(), e);
            return ResultModelFactory.FAIL400("获取开发者信息和结算信息列表异常："+e.getMessage());
        } catch(Exception e){
            LOG.error("获取开发者信息和结算信息列表出错："+e.getMessage(), e);
            return ResultModelFactory.FAIL500("获取开发者信息和结算信息列表出错："+e.getMessage());
        }
        return rs;
    }

    /**
     * @description: 根据时间和appkey获取可以结算的信息（单个+批量分页）
     * @author: JandMin
     * @time: 2018/6/14 10:30
     * @param request
     * @param response
     * @param search
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
     */
    @RequestMapping(value = "/findInfoForSettle",method = RequestMethod.GET)
    public ResultModel<Pagination> findInfoForSettle(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search){
        ResultModel<Pagination> rs = new ResultModel<Pagination>();
        try {
            Pagination resultList = developerProfitService.findInfoForSettle(search);
            rs.setReturnValue(resultList);
        } catch(ProfitException e){
            LOG.error("根据时间和appkey获取可以结算的信息异常："+e.getMessage(), e);
            return ResultModelFactory.FAIL400("根据时间和appkey获取可以结算的信息异常："+e.getMessage());
        } catch(Exception e){
            LOG.error("根据时间和appkey获取可以结算的信息出错："+e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据时间和appkey获取可以结算的信息出错："+e.getMessage());
        }
        return rs;
    }

    /**
     * @description: 对开发者可结算金额进行结算操作
     * @author: JandMin
     * @time: 2018/6/14 15:39
     * @param request
     * @param response
     * @param search
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(keyName = "广告",operType = "/developer/settleAccount")
    @RequestMapping(value = "/settleAccount", method = RequestMethod.POST)
    public ResultModel settleAccount(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search){
        try {
            if (isSettled){
                LOG.error("结算中请稍后再试：");
                return ResultModelFactory.FAIL500("结算中请稍后再试：");
            }
            isSettled = true;
            //把appkey转成list参数
            String[] keys = search.getKeywords().split(",");
            search.setKeywordList(Arrays.asList(keys));
            User user = getUser(request, response);
            int result = developerProfitService.settleAccount(search,user.getUsername());
            LOG.info(user.getUsername()+"结算操作结束，共结算成功："+result+" 个开发者(应成功个数为"+keys.length+")------");
            isSettled = false;
            return ResultModelFactory.SUCCESS();
        } catch(ProfitException e){
            isSettled = false;
            LOG.error("进行结算时异常："+e.getMessage(), e);
            return ResultModelFactory.FAIL400("进行结算时异常："+e.getMessage());
        } catch(Exception e){
            isSettled = false;
            LOG.error("进行结算时出错："+e.getMessage(), e);
            return ResultModelFactory.FAIL500("进行结算时出错："+e.getMessage());
        }
    }
}
