package com.bxm.adsmanager.web.controller.adsmedia;

import java.math.BigDecimal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.position.AppEntranceCaleRateConfigQueryDto;
import com.bxm.adsmanager.service.adsmedia.AppEntranceCalcRateConfigService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.income.AppEntrancePvUvVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCalcRateConfigDTO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

/**
 * 广告位计算比率配置.</br>
 * Created by zhengwangeng on 2021/2/25.
 */
@RestController
@RequestMapping("/appEntranceCalcRateConfig")
public class AppEntranceCalcRateConfigController extends BaseController {

    @Autowired
    private AppEntranceCalcRateConfigService appEntranceCalcRateConfigService;

    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public ResultModel<PageInfo<AppEntrancePvUvVO>> getPage(AppEntranceCaleRateConfigQueryDto dto) {
        ResultModel<PageInfo<AppEntrancePvUvVO>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(appEntranceCalcRateConfigService.getPage(dto));
        return resultModel;
    }

    @RequestMapping(value = "/updateRate", method = RequestMethod.POST)
    public ResultModel<Boolean> updateReviewRefuseConfig(@RequestBody AppEntranceCalcRateConfigDTO dto,
                                                         HttpServletRequest request, HttpServletResponse response) {
        String positionId = dto.getPositionId();
        BigDecimal pvuvRate = dto.getPvuvRate();
        if (StringUtils.isBlank(positionId)) {
            return ResultModelFactory.FAIL400("广告位ID不能为空！");
        }
        BigDecimal zero = new BigDecimal("0");
        BigDecimal hundred = new BigDecimal("100");
        if (pvuvRate == null || zero.compareTo(pvuvRate) > 0 || pvuvRate.compareTo(hundred) > 0) {
            return ResultModelFactory.FAIL400("比率不能为空，且必须在0-100之间！");
        }
        ResultModel<Boolean> resultModel = new ResultModel<>();
        User user = getUser(request, response);
        dto.setCreateUser(user.getUsername());
        appEntranceCalcRateConfigService.updateRate(dto);
        resultModel.setReturnValue(true);
        return resultModel;
    }


}
