package com.bxm.adsmanager.web.controller.adsmedia;

import com.bxm.adsmanager.service.adsmedia.ArticleService;
import com.bxm.adsmedia.facade.model.article.ArticleDto;
import com.bxm.adsmedia.facade.model.article.ArticleRo;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @FileName com.bxm.bxmmanage.controllers.OperateController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @Creator 代拉拉
 * @Created 2018-05-22 10:10:00
 * @Modifier 代拉拉
 * @Updated 2018-05-22 10:10:00
 * @Description
 * @Version BUILD1001
 */
@RefreshScope
@RestController
@Api(description = "文章管理")
@RequestMapping(value = "/article")
public class ArticleController {

    @Autowired
    private ArticleService articleService;

    /**
     * 获取查询文章列表
     * 
     * @return
     */
    @ApiOperation(value = "查询文章", notes = "查询文章列表")
    @RequestMapping(value = "/getArticleList", method = RequestMethod.GET)
    public ResultModel<PageInfo<ArticleRo>> getArticleList(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        ResultModel<PageInfo<ArticleRo>> resultModel = new ResultModel<PageInfo<ArticleRo>>();
        resultModel.setReturnValue(articleService.getAppList(pageSize,pageNum));
        return resultModel;
    }

    /**
     * 新增文章
     * 
     * @param
     * @return
     */
    @ApiOperation(value = "新增文章", notes = "新增文章")
    @RequestMapping(value = "/addArticle", method = RequestMethod.POST)
    public ResultModel<Boolean> addArticle(@RequestParam(value = "title") String title,
                                           @RequestParam(value = "messageLink") String messageLink,
                                           @RequestParam(value = "inserTime") String inserTime,
                                           @RequestParam(value = "message") String message,
                                           @RequestParam(value = "image") String image) {
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        ArticleDto article = new ArticleDto();
        article.setArticleTime(inserTime);
        article.setMessageLink(messageLink);
        article.setTitle(title);
        article.setMessage(message); 
        article.setImage(image);
        articleService.addArticle(article);
        resultModel.setReturnValue(true);
        return resultModel;
    }

    /**
     * 修改
     * 
     * @param
     * @return
     */
    @ApiOperation(value = "修改文章", notes = "修改文章")
    @RequestMapping(value = "/updateArticle", method = RequestMethod.POST)
    public ResultModel<Boolean> updateArticle(ArticleDto articleDto,
                                              @RequestParam(value = "inserTime", required = false) String inserTime) {
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        if (StringUtil.isNotBlank(inserTime)) {
            articleDto.setArticleTime(inserTime);
        }
        articleService.updateArticle(articleDto);
        resultModel.setReturnValue(true);
        return resultModel;
    }

    /**
     * 删除
     * 
     * @param
     * @return
     */
    @ApiOperation(value = "删除文章", notes = "删除文章")
    @RequestMapping(value = "/deleteArticle", method = RequestMethod.GET)
    public ResultModel<Boolean> deleteArticle(@RequestParam(value = "id") String id) {
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        articleService.deleteArticle(Long.parseLong(id));
        resultModel.setReturnValue(true);
        return resultModel;
    }
    /**
     * 上下移动
     * 
     * @param
     * @return
     */
    @ApiOperation(value = "移动文章", notes = "移动文章")
    @RequestMapping(value = "/moveArticle", method = RequestMethod.GET)
    public ResultModel<Boolean> moveArticle(@RequestParam(value = "id") String id,
                                            @RequestParam(value = "type") String type) {
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
         
        articleService.moveArticle(id,type);
        resultModel.setReturnValue(true);
        return resultModel;
    }
}
