package com.bxm.adsmanager.web.controller.adsmedia;

import com.bxm.adsmanager.integration.adsmedia.appentrance.InspireVideoFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.enumdata.InspireVideoChannelEnum;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceInspireVideoConfigDTO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceInspireVideoConfigVO;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author tangx
 * @date 2019/9/24 14:43
 */
@Slf4j
@RestController
@RequestMapping("/inspireVideoConfig")
public class InspireVideoConfigController extends BaseController {

    @Autowired
    private InspireVideoFacadeIntegration inspireVideoFacadeIntegration;


    /**
     * 保存配置
     * @param appEntranceInspireVideoConfigDTO
     * @return
     */
    @RequestMapping(value = "/addConfig",method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE )
    public ResultModel<Boolean> addConfig(@RequestBody AppEntranceInspireVideoConfigDTO appEntranceInspireVideoConfigDTO, HttpServletRequest request, HttpServletResponse response){
        User user = getUser(request, response);
        try {
            appEntranceInspireVideoConfigDTO.setModifier(user.getUsername());
            List<AppEntranceInspireVideoConfigVO> configs = appEntranceInspireVideoConfigDTO.getConfigs();
            if(!validateConfigArgs(appEntranceInspireVideoConfigDTO)){
                return ResultModelFactory.FAIL400("请检查参数规则正确");
            }
            return inspireVideoFacadeIntegration.addConfig(appEntranceInspireVideoConfigDTO);
        } catch (Exception e) {
            log.error("保存激励激励视频投放配置时出错！", e);
            return ResultModelFactory.FAIL500("保存激励激励视频投放配置时出错");
        }
    }

    /**
     * 根据positionId获取配置List
     * @param
     * @return
     */
    @RequestMapping(value = "/getConfigList",method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel<List<AppEntranceInspireVideoConfigVO>> getConfigList(@RequestParam("positionId") String positionId){
        return inspireVideoFacadeIntegration.getConfigList(positionId);
    }

    /**
     * 验证参数
     * @param dto
     * @return
     */
    boolean validateConfigArgs(AppEntranceInspireVideoConfigDTO dto) {
        String positionId = dto.getPositionId();
        List<AppEntranceInspireVideoConfigVO> configs = dto.getConfigs();
        if (CollectionUtils.isEmpty(configs)) {
            return false;
        }
        if (StringUtils.isBlank(positionId)){
            return false;
        }
        for (AppEntranceInspireVideoConfigVO c : configs) {
            if (c.getSort() == null) {
                return false;
            }
            if (StringUtil.isBlank(c.getChannelType())) {
                return false;
            }
            if(!InspireVideoChannelEnum.BXM.getCode().equalsIgnoreCase(c.getChannelType())
                    && ( StringUtil.isBlank(c.getChannelApplicationId())
                    || StringUtil.isBlank(c.getChannelPositionId())
                    || c.getStatus() == null)){
                return false;
            }
        }

        // 渠道类型重复判断 ios android分别判断
        List<String> androidList = configs.stream().filter(c -> c.getOsType() == 1).map(c -> c.getChannelType()).collect(Collectors.toList());
        Set<String> androidSet = new HashSet<>(androidList);
        List<String> iosList = configs.stream().filter(c -> c.getOsType() == 2).map(c -> c.getChannelType()).collect(Collectors.toList());
        Set<String> iosSet = new HashSet<>(iosList);
        if (androidList.size() != androidSet.size() || iosList.size() != iosSet.size()){
            return false;
        }

        return true;
    }

}
