package com.bxm.adsmanager.web.controller.adsmedia;

import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmedia.facade.model.provider.*;
import com.bxm.util.MD5Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.activites.facade.service.ActivityBackService;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.ProvideLastLoginIpVo;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.adsmedia.ProviderFinanceService;
import com.bxm.adsmanager.service.adsmedia.ProviderService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.github.pagehelper.PageInfo;

/**
 * 开发者，开发者财务相关信息的配置，审核
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/25 10:24
 */
@RestController
@RequestMapping("/provider")
@Slf4j
public class ProviderController extends BaseController {

    @Autowired
    private ProviderService providerService;
    @Autowired
    private ProviderFinanceService providerFinanceService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Autowired
    private ActivityBackService activityBackService;
    @Autowired
    private AdPositionAuditService adPositionAuditService;

    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Autowired
    private JedisUpdater jedisUpdater;

    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;


    /**
     * Description: 运营后台开发者财务管理列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/24 21:19
     *
     * @param keywords 邮箱/手机/公司名称/应用名称
     * @param mjCode   媒介code
     * @param status   状态， 0：待审核，1：审核通过，2：审核拒绝
     * @param pageNum  页码
     * @param pageSize 页面大小
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmedia.facade.model.provider.ProviderFinanceListRO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/getAuditPage", method = RequestMethod.GET)
    public ResultModel<PageInfo<ProviderFinanceListRO>> getAuditPage(@RequestParam(name = "keywords", required = false) String keywords,
                                                                     @RequestParam(name = "mjCode", required = false) String mjCode,
                                                                     @RequestParam(name = "id", required = false,defaultValue ="-1") long providerId,
                                                                     @RequestParam(name = "status", required = false) Byte status,
                                                                     @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
                                                                     @RequestParam(name = "areaType", required = false) Integer areaType,
                                                                     HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        boolean isFk = user.getRoleCodes() != null && user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        return ResultModelFactory.SUCCESS(providerFinanceService.getAuditPage(isFk, keywords, mjCode, null, providerId,
                status, areaType, pageNum, pageSize));
    }


    /**
     * Description: 审核开发者财务信息
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/24 21:03
     *
     * @param providerId   开发者ID
     * @param auditPass    是否审核通过, TRUE通过， FALSE拒绝
     * @param refuseReason 拒绝原因
     * @param reviewRefuseIds 拒绝原因ID列表
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/audit", method = RequestMethod.POST)
    public ResultModel<Boolean> audit(@RequestParam(name = "providerId") Long providerId,
                                      @RequestParam(name = "auditPass") Boolean auditPass,
                                      @RequestParam(name = "refuseReason") String refuseReason,
                                      @RequestParam(name = "reviewRefuseIds",required = false, defaultValue = "") String reviewRefuseIds,
                                      HttpServletRequest request, HttpServletResponse response) {
        if (auditPass == null) {
            throw new BusinessException("请选择通过或拒绝");
        }
        User user = getUser(request, response);
        List<String> roleCodes = user.getRoleCodes();
        //判断是否具备审核权限
        if (CollectionUtils.isEmpty(roleCodes)) {
            throw new BusinessException("暂无审核权限");
        }
        boolean isRiskController;
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.MJ.getCode()) || roleCodes.contains(RoleEnum.MJLEADER.getCode())) {
            isRiskController = false;
        } else {
            throw new BusinessException("暂无审核权限");
        }
        return ResultModelFactory.SUCCESS(providerFinanceService.audit(isRiskController, providerId, auditPass,
                refuseReason, reviewRefuseIds, getUser(request, response).getUsername()));
    }

    /**
     * Description: 设置媒介
     * JDK version used:<JDK1.8>
     * Create Date：2019/2/14 14:38

     * @param providerId 开发者ID
     * @param mjCode 媒介CODE
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/setMj", method = RequestMethod.POST)
    public ResultModel<Boolean> setMj(@RequestParam(name = "providerId") Long providerId,
                                      @RequestParam(name = "mjCode") String mjCode,
                                      HttpServletRequest request, HttpServletResponse response) {
        return ResultModelFactory.SUCCESS(providerService.setMj(providerId, mjCode, getUser(request, response).getUsername()));
    }


    /**
     * 运营后台开发者分配列表
     * @param providerName 开发者名称
     * @param email 电子邮件
     * @param financeStatus 财务信息状态
     * @param mediaStatus 媒体状态
     * @param appEntranceStatus 广告位状态
     * @param mjCode 媒介code
     * @param bdCode bdCode
     * @param isOrderByDateDesc 是否按提交时间降序
     * @param code 开发者代号
     * @param pageNum 页码
     * @param pageSize 页面大小
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/getAuditStatusPage", method = RequestMethod.GET)
    public ResultModel<PageInfo<ProviderStatusListRO>> getAuditStatusPage(@RequestParam(name = "providerName", required = false) String providerName,
                                                                          @RequestParam(name = "email", required = false) String email,
                                                                          @RequestParam(name = "financeStatus", required = false) Byte financeStatus,
                                                                          @RequestParam(name = "mediaStatus", required = false) Byte mediaStatus,
                                                                          @RequestParam(name = "appEntranceStatus", required = false) Byte appEntranceStatus,
                                                                          @RequestParam(name = "mjCode", required = false) String mjCode,
                                                                          @RequestParam(name = "bdCode", required = false) String bdCode,
                                                                          @RequestParam(name = "isOrderByDateDesc", required = false) Boolean isOrderByDateDesc,
                                                                          @RequestParam(name = "code", required = false,defaultValue = "") String code,
                                                                          @RequestParam(name = "areaType", required = false) Integer areaType,
                                                                          @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
                                                                          HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        if (user.getRoleCodes() == null){
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        //媒介经理和风控可以看到所有的
        Boolean look_all = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())
                || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()) ;
        if(!look_all){
            mjCode = user.getUsername();
        }

        return ResultModelFactory.SUCCESS(providerFinanceService.getAuditStatusPage(user,providerName, email, financeStatus,
                mediaStatus, appEntranceStatus, mjCode, bdCode,isOrderByDateDesc, code, areaType,pageNum, pageSize));
    }

    /**
     * Description: 运营后台开发者分配列表中媒介leader初审 (媒介/媒介leader与风控都可以审核)
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/24 21:03
     *
     * @param providerId   开发者ID
     * @param auditPass    是否审核通过, TRUE通过， FALSE拒绝
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/firstAudit", method = RequestMethod.POST)
    public ResultModel<Boolean> firstAudit(@RequestParam(name = "providerId") Long providerId,
                                      @RequestParam(name = "auditPass") Boolean auditPass,
                                      HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (auditPass == null) {
            throw new BusinessException("请选择通过或拒绝");
        }
        //判断当前用户身份
        User user = getUser(request, response);
        List<String> roleCodes = user.getRoleCodes();
        //判断是否具备审核权限
        if (roleCodes == null || roleCodes.size() == 0) {
            throw new BusinessException("暂无审核权限");
        }
        //是否为风控 (若同时存在风控与媒介,以风控最高权限为准)
        boolean isRiskController;
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.MJ.getCode()) || roleCodes.contains(RoleEnum.MJLEADER.getCode())) {
            isRiskController = false;
        } else {
            throw new BusinessException("暂无审核权限");
        }

        FirstProviderAuditDto firstProviderAuditDto = providerFinanceService.firstAudit(providerId, auditPass,
                getUser(request, response).getUsername(), isRiskController);

        return ResultModelFactory.SUCCESS(adPositionAuditService.auditPassDataHandle(firstProviderAuditDto, isRiskController, auditPass));
    }


    /**
     * Description: 获取开发者最后登录IP相同的媒体信息
     * JDK version used:<JDK1.8>
     * Create Date：2019/7/12 10:54

     * @param appKey 开发者appKey
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author zhengwangeng
     */
    @RequestMapping(value = "/getProvideLastLoginIpInfo", method = RequestMethod.POST)
    public ResultModel<List<ProvideLastLoginIpVo>> getProvideLastLoginIpInfo(@RequestParam(name = "appKey") String appKey,
                                                         HttpServletRequest request,
                                                         HttpServletResponse response) {
        ResultModel<List<ProvideLastLoginIpVo>> resultModel = new ResultModel<>();
        resultModel.setSuccessed(true);
        resultModel.setErrorDesc("成功");
        resultModel.setReturnValue(providerService.getProvideLastLoginIpInfo(appKey));
        return resultModel;
    }


    /**
     * Description: 分配媒介和BD
     * @param providerId 开发者ID
     * @param mjCode 媒介CODE
     * @param bdCode  bdcode
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author zm
     */
    @RequestMapping(value = "/set/mj-bd", method = RequestMethod.POST)
    public ResultModel<Boolean> setMjAndBd(@RequestParam(name = "providerId") Long providerId,
                                      @RequestParam(name = "mjCode",required = false) String mjCode,
                                      @RequestParam(name = "bdCode",required = false) String bdCode,
                                      HttpServletRequest request,
                                      HttpServletResponse response) {
        User user = getUser(request, response);
        if (user.getRoleCodes()==null){
            user.setRoleCodes(Collections.emptyList());
        }
        // 媒介经理/风控可看到操作字段
        if (!(user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())
                || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))){
            throw new BusinessException("暂无操作权限！");
        }
        if (StringUtils.isBlank(mjCode)&&StringUtils.isBlank(bdCode)){
            return ResultModelFactory.FAIL400("请选择需要修改的选项");
        }
        return ResultModelFactory.SUCCESS(providerService.setMjAndBd(providerId, mjCode, bdCode,user.getUsername()));
    }

    /**
     * Description: 设置开发者标签
     * @param providerId 开发者ID
     * @param tags 开发者标签
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author zm
     */
    @RequestMapping(value = "/set/tags", method = RequestMethod.POST)
    public ResultModel<Boolean> setTags(@RequestParam(name = "providerId") Long providerId,
                                        @RequestParam(name = "tags") String tags,
                                         HttpServletRequest request,
                                         HttpServletResponse response) {
        if (tags==null){
            return ResultModelFactory.FAIL400("请选择需要修改的标签");
        }
        // tags传空串代表置为""
        User user = getUser(request, response);
        if (user.getRoleCodes()==null){
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        // 平台运营/风控可操作字段
        if (!(user.getRoleCodes().contains(RoleEnum.PING_TAI_YUN_YING_LEADER.getCode())
                || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))){
            throw new BusinessException("暂无操作权限！");
        }
      return ResultModelFactory.SUCCESS(providerService.setTags(providerId, tags,user.getUsername()));
    }


    @RequestMapping(value = "/findProviders", method = RequestMethod.GET)
    public ResultModel findProviders(@RequestParam("appKeys") String appKeys) {

        if (StringUtils.isBlank(appKeys)){
            return ResultModelFactory.FAIL400("请填写参数");
        }
        List<AdMedia> adMedia = mediaService.queryMediaByAppKeys(appKeys);
        ResultModel<List<AdMedia>> resultModel = new ResultModel<>();
        resultModel.setSuccessed(true);
        resultModel.setErrorDesc("成功");
        resultModel.setReturnValue(adMedia);
        return resultModel;
    }

    /**
     * 模拟登录开发者后台
     * @return
     */
    @RequestMapping(value = "/simulateLogin", method = RequestMethod.GET)
    public ResultModel simulateLogin(@RequestParam("developerId") Long developerId) {
        if (null == developerId) {
            return ResultModelFactory.FAIL400("请填写参数");
        }

        SimulateLoginVo simulateLoginVo = providerFacadeIntegration.simulateLogin(developerId);

        if (simulateLoginVo != null) {
            ResultModel<SimulateLoginVo> resultModel = new ResultModel<>();
            resultModel.setSuccessed(true);
            resultModel.setErrorDesc("成功");
            resultModel.setReturnValue(simulateLoginVo);
            return resultModel;
        }
        return ResultModelFactory.FAIL500("登陆异常");
    }


    @RequestMapping(value = "/simulateRegister", method = RequestMethod.POST)
    public ResultModel simulateRegister(SimulateRegisterDTO simulateRegisterDTO) throws Exception{
        if (null == simulateRegisterDTO) {
            return ResultModelFactory.FAIL400("请填写参数");
        }
        simulateRegisterDTO.setPwd(MD5Util.md5(simulateRegisterDTO.getPwd()));
        ResultModel resultModel = providerFacadeIntegration.simulateRegister(simulateRegisterDTO);
        if (resultModel == null) {
            return ResultModelFactory.FAIL500("添加异常");
        }
        return resultModel;
    }

    @RequestMapping(value = "/getAdvanceProviderList", method = RequestMethod.GET)
    public ResultModel<PageInfo<ProviderFinanceListRO>> getAdvanceProviderList(@RequestParam(name = "keywords", required = false) String keywords,
                                                                     @RequestParam(name = "mjCode", required = false) String mjCode,
                                                                     @RequestParam(name = "id", required = false,defaultValue ="-1") long providerId,
                                                                     @RequestParam(name = "status", required = false) Byte status,
                                                                     @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(name = "areaType", required = false) Integer areaType,
                                                                     @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,

                                                                     HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        String bdCode = null;
        // 媒介经理可以查看所有，bd查看所属开发者
        if (user.getRoleCodes().contains(RoleEnum.BD.getCode()) && !user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())) {
            bdCode = user.getUsername();
        }

        return ResultModelFactory.SUCCESS(providerFinanceService.getAuditPage(true, keywords, mjCode, bdCode, providerId,
                status, areaType, pageNum, pageSize));
    }

}
