package com.bxm.adsmanager.web.controller.adticketgroup;

import com.bxm.adsmanager.model.dao.adticketgroup.AppkeyGroupConfig;
import com.bxm.adsmanager.model.dao.adticketgroup.TicketGroupMutex;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.adticketgroup.AppkeyGroupService;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupMutexService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * 开发者广告组
 */
@Slf4j
@RestController
public class AppkeyGroupController extends BaseController {

    @Autowired
    AppkeyGroupService appkeyGroupService;

    /**
     * 查找列表
     *
     * @return
     */
    @RequestMapping(value = "/appkeyGroup/findByAppkey", produces = "application/json")
    public ResultModel<AppkeyGroupConfig> findByAppkey(@RequestParam(value = "appkey") String appkey) {
        ResultModel<AppkeyGroupConfig> rs = new ResultModel<>();
        try {
            //调用服务层
            rs.setReturnValue(appkeyGroupService.findByAppkey(appkey));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            log.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组开发者查找出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }


    /**
     * 新增或者修改
     *
     * @param id
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/appkeyGroup/saveOrUpdate", produces = "application/json")
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value = "id", required = false) Long id,
                                             @RequestParam(value = "groupIds") String groupIds,
                                             @RequestParam(value = "appkey") String appkey,
                                             HttpServletRequest request, HttpServletResponse response) {
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            User user = getUser(request, response);
            appkeyGroupService.saveOrUpdate(id, groupIds,appkey, user.getUsername());
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            log.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组开发者查找 新增或者修改出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }
}
