package com.bxm.adsmanager.web.controller.adticketgroup;

import com.bxm.adsmanager.model.dao.adticketgroup.TicketGroupMutex;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupMutexService;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * 广告组互斥券
 */
@RestController
public class TicketGroupMutexController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGroupMutexController.class);

    @Autowired
    TicketGroupMutexService ticketGroupMutexService;

    /**
     * 查找列表
     *
     * @param keyword
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "/ticketgroupmutex/findAll", produces = "application/json")
    public ResultModel<PageInfo<TicketGroupMutex>> findAll(@RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        ResultModel<PageInfo<TicketGroupMutex>> rs = new ResultModel<>();
        try {
            //调用服务层
            rs.setReturnValue(ticketGroupMutexService.findAll(keyword, pageNum, pageSize));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组互斥券 查找列表出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }


    /**
     * 新增或者修改
     * @param id
     * @param json
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/ticketgroupmutex/saveOrUpdate", produces = "application/json")
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value = "id", required = false) Integer id,
                                             @RequestParam(value = "json") String json,
                                             HttpServletRequest request, HttpServletResponse response) {
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            User user = getUser(request, response);
            ticketGroupMutexService.saveOrUpdate(id, json, user.getUsername());
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组互斥券 新增或者修改出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }



    @RequestMapping(value = "/ticketgroupmutex/delete", produces = "application/json")
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value = "id") Integer id) {
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            ticketGroupMutexService.delete(id);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组互斥券 删除出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }
}
