package com.bxm.adsmanager.web.controller.adticketgroup;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupWhiteVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupService;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupWhiteService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;


@Slf4j
@RestController
public class TicketGroupWhiteController extends BaseController {

    @Autowired
    TicketGroupWhiteService ticketGroupWhiteService;


    @GetMapping(value = "/whitegroup", produces = "application/json")
    public ResultModel<PageInfo<TicketGroupWhiteVo>> findWhiteGroup(@RequestParam(value = "keywords", required = false) String keywords,
                                                                    @RequestParam(value = "isShare", required = false) Integer isShare,
                                                                    @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        ResultModel<PageInfo<TicketGroupWhiteVo>> rs = new ResultModel<>();
        try {
            //调用服务层
            rs.setReturnValue(ticketGroupWhiteService.findWhiteGroup(keywords, isShare, pageNum, pageSize));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            log.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        //返回
        return rs;
    }


    /**
     * 分页
     *
     * @param groupIds
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/whitegroup/findByIds", produces = "application/json")
    public ResultModel<PageInfo<TicketGroupWhiteVo>> findWhitegroupByIds(@RequestParam(value = "groupIds", required = false) String groupIds,
                                                                         @RequestParam(value = "keywords", required = false) String keywords,
                                                                         @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        //声明结果
        ResultModel<PageInfo<TicketGroupWhiteVo>> rs = new ResultModel<>();
        try {
            //调用服务层
            rs.setReturnValue(ticketGroupWhiteService.findByIds(groupIds, pageNum, pageSize, keywords));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            log.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        //返回
        return rs;
    }

    /**
     * 新增或者修改
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/whitegroup/saveOrUpdate", produces = "application/json")
    public ResultModel<Boolean> saveOrUpdate(TicketGroupWhiteVo ticketGroupWhiteVo,
            HttpServletRequest request, HttpServletResponse response) {
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            User user = getUser(request, response);
            ticketGroupWhiteService.saveOrUpdate(ticketGroupWhiteVo, user.getUsername());
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            log.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组开发者查找 新增或者修改出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }

    @RequestMapping(value = "/whitegroup/delete", produces = "application/json")
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value = "ids", required = false) String ids,
                                             HttpServletRequest request, HttpServletResponse response) {
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            User user = getUser(request, response);
            ticketGroupWhiteService.delete(ids, user.getUsername());
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            log.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告组开发者查找 新增或者修改出错system error" + e.getMessage());
        }
        //返回
        return rs;
    }
}
