package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.advertiserdata.TicketDataOptimized;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AdTicketDataOptimizedVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import com.bxm.adsmanager.service.advertiser.AdvertiserDataOptimizedService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/advertiserDataOptimized")
@Slf4j
public class AdvertiserDataOptimizedController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserDataOptimizedController.class);

    @Autowired
    private AdvertiserDataOptimizedService advertiserDataOptimizedService;

    /**
     * @param request
     * @param response
     * @return com.bxm.util.dto.ResultModel
     * @description 添加广告主后台消耗数据修饰
     * @author 拉拉
     * @time 2019/7/17
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/advertiserDataOptimized/add", keyName = "添加广告主后台消耗数据修饰")
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam("rptDate") String rptDate,
                           @RequestParam("ticketId") Long ticketId,
                           @RequestParam(value = "showNum", required = false, defaultValue = "0") Long showNum,
                           @RequestParam(value = "clickNum", required = false, defaultValue = "0") Long clickNum,
                           @RequestParam(value = "effectNum", required = false, defaultValue = "0") Long effectNum,
                           @RequestParam(value = "consumeNum", required = false, defaultValue = "0") Long consumeNum) {

        if (consumeNum < 0) {
            return ResultModelFactory.FAIL500("金额不能小于0 ");
        }

        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            TicketDataOptimized ticketDataOptimized = new TicketDataOptimized();
            ticketDataOptimized.setClickNum(clickNum);
            ticketDataOptimized.setRptDate(rptDate);
            ticketDataOptimized.setConsumeNum(consumeNum);
            ticketDataOptimized.setEffectNum(effectNum);
            ticketDataOptimized.setShowNum(showNum);
            ticketDataOptimized.setTicketId(ticketId);
            ticketDataOptimized.setDeductStatus(0);
            ticketDataOptimized.setCreateTime(new Date());
            ticketDataOptimized.setCreateUser(userName);
            advertiserDataOptimizedService.add(ticketDataOptimized);
            return ResultModelFactory.SUCCESS(true);
        } catch (Exception e) {
            LOGGER.error("添加广告主后台消耗数据修饰" + e.getMessage(), e);
            if (e instanceof BusinessException){
                return ResultModelFactory.FAIL500(e.getMessage());
            } else {
                return ResultModelFactory.FAIL500("发生系统错误");
            }
        }
    }

    /**
     * @param request
     * @param response
     * @return com.bxm.util.dto.ResultModel
     * @description 删除广告主后台消耗数据修饰
     * @author 拉拉
     * @time 2019/7/17
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/advertiserDataOptimized/delete", keyName = "删除广告主后台消耗数据修饰")
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam("id") Long id) {
        try {
            advertiserDataOptimizedService.delete(id);
            return ResultModelFactory.SUCCESS(true);
        } catch (Exception e) {
            LOGGER.error("删除广告主后台消耗数据修饰" + e.getMessage(), e);
            if (e instanceof BusinessException){
                return ResultModelFactory.FAIL500(e.getMessage());
            } else {
                return ResultModelFactory.FAIL500("发生系统错误");
            }
        }
    }

    /**
     * @param request
     * @param response
     * @return com.bxm.util.dto.ResultModel
     * @description 修改广告主后台消耗数据修饰
     * @author 拉拉
     * @time 2019/7/17
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/advertiserDataOptimized/update", keyName = "修改广告主后台消耗数据修饰")
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam("id") Long id,
                           @RequestParam("rptDate") String rptDate,
                           @RequestParam("ticketId") Long ticketId,
                           @RequestParam(value = "showNum", required = false) Long showNum,
                           @RequestParam(value = "clickNum", required = false) Long clickNum,
                           @RequestParam(value = "effectNum", required = false) Long effectNum,
                           @RequestParam(value = "consumeNum", required = false) Long consumeNum) {

        if (consumeNum < 0) {
            return ResultModelFactory.FAIL500("金额不能小于0 ");
        }
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            TicketDataOptimized ticketDataOptimized = new TicketDataOptimized();
            ticketDataOptimized.setClickNum(clickNum);
            ticketDataOptimized.setRptDate(rptDate);
            ticketDataOptimized.setConsumeNum(consumeNum);
            ticketDataOptimized.setEffectNum(effectNum);
            ticketDataOptimized.setShowNum(showNum);
            ticketDataOptimized.setTicketId(ticketId);
            ticketDataOptimized.setId(id);
            ticketDataOptimized.setModifyUser(userName);
            ticketDataOptimized.setModifyTime(new Date());
            advertiserDataOptimizedService.update(ticketDataOptimized);
            return ResultModelFactory.SUCCESS(true);
        } catch (Exception e) {
            LOGGER.error("修改广告主后台消耗数据修饰" + e.getMessage(), e);
            if (e instanceof BusinessException){
                return ResultModelFactory.FAIL500(e.getMessage());
            } else {
                return ResultModelFactory.FAIL500("发生系统错误");
            }
        }
    }

    /**
     * 查找广告主后台消耗数据修饰
     *
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo < com.bxm.adsmanager.model.dao.advertiserdata.TicketDataOptimized>>
     * @author tangx
     * @DATE 2019/8/5 18:04
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<AdTicketDataOptimizedVo>> getAdvertiserDataOptimizedList(@RequestParam(value = "startTime", required = false) String startTime,
                                                                                         @RequestParam(value = "endTime", required = false) String endTime,
                                                                                         @RequestParam(value = "ticketId", required = false) String ticketId,
                                                                                         @RequestParam(value = "dimension",required = false) String dimension,
                                                                                         @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize) {

        ResultModel<PageInfo<AdTicketDataOptimizedVo>> pageInfoResultModel = new ResultModel<>();
        try {
            PageInfo<AdTicketDataOptimizedVo> page = advertiserDataOptimizedService.findAll(startTime, endTime, ticketId,dimension, pageNum, pageSize);
            pageInfoResultModel.setReturnValue(page);
        } catch (Exception e) {
            LOGGER.error("查找广告主后台消耗数据修饰" + e.getMessage(), e);
            pageInfoResultModel.setErrorCode("500");
            pageInfoResultModel.setErrorDesc("查找出错");
            return pageInfoResultModel;
        }
        return pageInfoResultModel;
    }

    /**
     * 根据Id获取广告主消耗数据修饰
     *
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.AdTicketDataOptimizedVo>
     * @author tangx
     * @DATE 2019/8/6 10:04
     */
/*    @GetMapping(value = "/findById" , produces = "application/json")
    public ResultModel<AdTicketDataOptimizedVo> getAdvertiserDataOptimizedById(@RequestParam("id") Long id) {
        ResultModel<AdTicketDataOptimizedVo> resultModel = new ResultModel<>();
        try {
            AdTicketDataOptimizedVo adTicketDataOptimizedVo = advertiserDataOptimizedService.getAdvertiserDataOptimizedById(id);
            resultModel.setReturnValue(adTicketDataOptimizedVo);
        } catch (Exception e) {
            LOGGER.error("根据Id获取广告主消耗数据修饰" + e.getMessage(), e);
            resultModel.setErrorDesc(e.getMessage());
            return resultModel;
        }
        return resultModel;
    }*/

    /**
     * 广告主消耗扣款
     *
     * @return com.bxm.util.dto.ResultModel
     * @author tangx
     * @DATE 2019/8/6 11:41
     */
    @LogBefore(operType = "/advertiserDataOptimized/deductFinance", keyName = "广告主后台消耗数据扣款")
    @PostMapping(value = "/deductFinance", produces = "application/json")
    public ResultModel addAdvertiserFinanceById(@RequestParam("id") Long id,
                                                HttpServletRequest request,
                                                HttpServletResponse response) {
        try {
            // 获取当前操作用户
            User currentUser = getUser(request, response);
            advertiserDataOptimizedService.addAdvertiserFinanceById(id, currentUser);
        } catch (Exception e) {
            LOGGER.error("广告主后台消耗扣款" + e.getMessage(), e);
            if (e instanceof BusinessException){
                return ResultModelFactory.FAIL500(e.getMessage());
            } else {
                return ResultModelFactory.FAIL500("发生系统错误");
            }
        }
        return ResultModelFactory.SUCCESS(true);
    }

    /**
     * 根据id或券名获取已关闭的广告券列表
     *
     * @return com.bxm.util.dto.ResultModel
     * @author tangx
     * @DATE 2019/8/6 16:10
     */
    @GetMapping(value = "/findTicket" , produces = "application/json")
    public ResultModel<List<TicketVo>> findTicket(@RequestParam("keyword") String keyword) {
        ResultModel<List<TicketVo>> resultModel = new ResultModel<>();
        try {
            List<TicketVo> ticketVo = advertiserDataOptimizedService.findTicket(keyword);
            resultModel.setReturnValue(ticketVo);
        } catch (Exception e) {
            LOGGER.error("根据Id获取广告券信息" + e.getMessage(), e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc("查找出错");
            return resultModel;
        }
        return resultModel;
    }

}
