package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceNewDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceVo;
import com.bxm.adsmanager.integration.advertiser.service.AdFinanceIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.vo.AdvertiserTicketConsumeInfoVO;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.google.common.base.Splitter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping("/adFinance")
public class AdvertiserFinanceController extends BaseController{

    @Autowired
    private AdFinanceIntegration adFinanceIntegration;
    @Autowired
    private AdIncomeTicketService adIncomeTicketService;

    /**
     * @description 获取广告主资金流水列表
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "queryAdFinance", method = RequestMethod.GET)
    public ResultModel<com.bxm.adsmanager.integration.advertiser.model.Pagination> queryAdvertiserFinance(
            HttpServletRequest request, HttpServletResponse response,
            @RequestParam(value = "advertiserId", required = true) Integer advertiserId,
            @RequestParam(value = "startTime", required = false) String startTime,
            @RequestParam(value = "endTime", required = false) String endTime,
            @RequestParam(value = "pageSize", required = false) Integer pageSize,
            @RequestParam(value = "pageNum", required = false) Integer pageNum
           ) {
        ResultModel<com.bxm.adsmanager.integration.advertiser.model.Pagination> rs = new ResultModel<>();

        AdvertiserFinanceNewDto advertiserFinanceNewDto = new AdvertiserFinanceNewDto();
        advertiserFinanceNewDto.setPageNum(pageNum);
        advertiserFinanceNewDto.setPageSize(pageSize);
        advertiserFinanceNewDto.setAdvertiserId(advertiserId);
        if (StringUtils.isEmpty(startTime) && StringUtils.isEmpty(endTime)) {
            advertiserFinanceNewDto.setStartTime(DateUtil.dateTo8String3(new Date()));
            advertiserFinanceNewDto.setEndTime(DateUtil.dateTo8String3(new Date()));
        } else {
            advertiserFinanceNewDto.setStartTime(startTime);
            advertiserFinanceNewDto.setEndTime(endTime);
        }

        try {
            com.bxm.adsmanager.integration.advertiser.model.Pagination pageBean = adFinanceIntegration
                    .getAdShopFinanceOnlyList(advertiserFinanceNewDto);
            rs.setReturnValue(pageBean);
        } catch (Exception e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }

    /**
     * @description 导出广告主资金流水列表
     * @CopyRight 杭州微财网络科技有限公司
     */
    @LogBefore(operType="/adFinance/exportAdFinance",keyName="广告")
    @RequestMapping(value = "exportAdFinance", method = RequestMethod.GET)
    public void exportAdvertiserFinance(HttpServletRequest request, HttpServletResponse response,
            @RequestParam(value = "startTime", required = false) String startTime,
            @RequestParam(value = "endTime", required = false) String endTime,
            @RequestParam(value = "advertiserId", required = true) Integer advertiserId) {

        AdvertiserFinanceNewDto advertiserFinanceNewDto = new AdvertiserFinanceNewDto();
        advertiserFinanceNewDto.setAdvertiserId(advertiserId);
        if (StringUtils.isEmpty(startTime) && StringUtils.isEmpty(endTime)) {
            advertiserFinanceNewDto.setStartTime(DateUtil.dateTo8String3(new Date()));
            advertiserFinanceNewDto.setEndTime(DateUtil.dateTo8String3(new Date()));
        } else {
            advertiserFinanceNewDto.setStartTime(startTime);
            advertiserFinanceNewDto.setEndTime(endTime);
        }

        List<AdvertiserFinanceVo> lists = null;
        try {
            lists = adFinanceIntegration.exportAdvertiserFinanceOnly(advertiserFinanceNewDto);
            if (null != lists) {
                for (AdvertiserFinanceVo record : lists) {
                    record.setStrCreated(DateUtil.dateTo14String(record.getCreated()));
                }
            } else {
                lists = new ArrayList<AdvertiserFinanceVo>();
            }

        } catch (Exception e) {
            lists = new ArrayList<AdvertiserFinanceVo>();
        }
        //导出数据
        ExcelUtil.exportExcel(lists, null, "财务流水数据", AdvertiserFinanceVo.class, "财务流水数据.xls", response);
    }


    /**
     * Description: 根据广告主ID， 获取他一段时间内所有的券消耗值
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/3 10:03
     *
     * @param advertiserIdsStr 广告主ID
     * @param beginDate        开始时间
     * @param endDate          结束时间
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.AdvertiserTicketConsumeInfoVO>
     * @author hxpeng
     */
    @RequestMapping(value = "/getTicketConsumeInfoByAdvertiserId")
    public ResultModel<AdvertiserTicketConsumeInfoVO> getTicketConsumeInfoByAdvertiserId(@RequestParam(name = "advertiserIdsStr") String advertiserIdsStr,
                                                                                        @RequestParam(name = "beginDate") @DateTimeFormat(pattern = "yyyy-MM-dd") Date beginDate,
                                                                                        @RequestParam(name = "endDate") @DateTimeFormat(pattern = "yyyy-MM-dd") Date endDate) {
        try {
            List<Long> advertiserIds = Splitter.on(CommonConstant.BaseCharacter.COMMA).omitEmptyStrings().splitToList(advertiserIdsStr)
                    .stream().map(Long::valueOf).collect(Collectors.toList());
            return ResultModelFactory.SUCCESS(adIncomeTicketService.getTicketConsumeInfoByAdvertiserIds(advertiserIds, beginDate, endDate));
        } catch (Exception e) {
            log.error("获取广告主某段时间内的券消耗详情失败！！！", e);
            return ResultModelFactory.FAIL400(e.getMessage());
        }
    }
}
