package com.bxm.adsmanager.web.controller.advertiser;
import java.util.*;

import javax.servlet.http.HttpServletRequest;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dto.TblAdQualifyDto;
import com.bxm.adsmanager.model.enums.AdvertiserQualifyEnum;
import com.bxm.adsmanager.model.vo.TblAdQualifyVo;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.advertiser.AdvertiserQualifyService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @Title:AdvertiserQualifyAuditController.java
* @Package:com.bxm.adsmanager.web.controller.advertiser
* @Description: 广告主资质审核类
 */
@RestController
@RequestMapping("/advertiser")
public class AdvertiserQualifyAuditController {
    
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserQualifyAuditController.class);

    /**
     * 广告主资质操作接口
     */
    @Autowired
    private AdvertiserQualifyService advertiserQualifyService;
    
    /**
     * 调用广告主服务
     */
    @Autowired
    private AdShopIntegration adShopIntegration;
    
    /**
     * 标签服务接口
     */
    @Autowired
    private TblAdTagService tblAdTagService;
    
    /**
     * 广告主的标识
     */
    public static final String ADVERTISER_FLAG = "advertiser"; 
    
    /**
     *   查询标签,区分广告主后台和运营后台 1-运营后台
     */
    public static final String QUERYFLAG = "1"; 
    
    /**
     * @Title: getAdQualifyList  
     * @Description: 查询广告主资质审核信息
     * @return ResultModel<TblAdQualify> 
      */
      @RequestMapping(value = "/getAdQualifyAuditList",method = RequestMethod.GET)
      @Deprecated
      public ResultModel<PageInfo<TblAdQualifyVo>> getAdQualifyList( HttpServletRequest request,TblAdQualifyDto param){
          ResultModel<PageInfo<TblAdQualifyVo>> resultModel = new ResultModel<PageInfo<TblAdQualifyVo>>();
          if(null == param){
              param = new TblAdQualifyDto();
          }
          //查询标签区分广告主后台和运营后台
          param.setQueryFlag(QUERYFLAG);
          PageInfo<TblAdQualify> adQualifyPageInfo = null;
          //返回结果的list集合
          List<TblAdQualifyVo> adQualifyVoList = new ArrayList<TblAdQualifyVo>();
          Map<String,Object> advertiserMap = null;
          Map<Integer,String> tagNameMap = null;
          try {
                  //查询广告主的基本信息,获取广告主名称
                  advertiserMap = getAllAdvertiser(param);
                  if(advertiserMap == null){
                      advertiserMap = new HashMap<String,Object>();
                  }
                  //查找标签信息，获取标签名称
                  //查询标签
                  tagNameMap = getTagName(1, 9999, null,3);
                  if(tagNameMap == null){
                      tagNameMap = new HashMap<Integer,String>();
                  }
                  //根据广告主名称过滤
                  if(StringUtil.isNotBlank(param.getKeywords()) && !StringUtil.isNumeric(param.getKeywords())){
                      //查询广告主的基本信息,获取广告主名称
                      List<Long> advertiserList = (List<Long>) advertiserMap.get("ids");
                      if(CollectionUtils.isEmpty(advertiserList)){
                          advertiserList = new ArrayList<Long>();
                      }
                      param.setAdvertiserList(advertiserList);
                  }
                  if(StringUtil.isNotBlank(param.getKeywords()) && StringUtil.isNumeric(param.getKeywords())){
                      //广告主ID
                      param.setAdvertiserId(Long.valueOf(param.getKeywords()));
                  }
                  adQualifyPageInfo = advertiserQualifyService.getAdQualifyList(param);
                  if(adQualifyPageInfo != null && !CollectionUtils.isEmpty(adQualifyPageInfo.getList())){
                      List<TblAdQualify> list = adQualifyPageInfo.getList();
                      TblAdQualifyVo adQualifyVo = null;
                      for(TblAdQualify record : list){
                          adQualifyVo = new TblAdQualifyVo();
                          //对象复制
                          BeanUtils.copyProperties(record, adQualifyVo);
                          if(record.getAdvertiserId() != null){
                              Object object = advertiserMap.get(String.valueOf(record.getAdvertiserId()));
                              if(object != null){
                                  adQualifyVo.setAdvertiserName(String.valueOf(object));
                              }
                          }
                          //行业类别
                          adQualifyVo.setAdvertiserTypeStr(tagNameMap.get(record.getAdvertiserType()));
                          //资质名称
                          adQualifyVo.setQualifyNameStr(tagNameMap.get(record.getQualifyName()));
                          if (StringUtils.isNotBlank(record.getImage())){
                             List<String> imgList = Arrays.asList(record.getImage().split(",")) ;
                              adQualifyVo.setImgList(imgList);
                          }
                          adQualifyVoList.add(adQualifyVo);
                      }
                  }
         } catch (Exception e) {
             LOGGER.error("查询资质列表信息出错"+ e.getMessage(), e);
             return ResultModelFactory.FAIL500("查询资质列表信息出错");
         }
          //结果封装
          PageInfo<TblAdQualifyVo> newPageInfo = new PageInfo<TblAdQualifyVo>();
          if(adQualifyPageInfo == null){
              adQualifyPageInfo = new PageInfo<TblAdQualify>();
          }
          BeanUtils.copyProperties(adQualifyPageInfo, newPageInfo);
          newPageInfo.setList(adQualifyVoList);
          resultModel.setReturnValue(newPageInfo);
          return resultModel;
      }
      
      /**
       * @Title: getAdQualifyById  
       * @Description: 根据ID查询广告主资质信息
       * @param Integer id
       * @return ResultModel<TblAdQualify> 
        */
        @RequestMapping(value = "/adQualifyById",method = RequestMethod.GET)
        public ResultModel<TblAdQualify> getAdQualifyById(HttpServletRequest request,@RequestParam(name = "id",required = true) Integer id){
            ResultModel<TblAdQualify> resultModel = new ResultModel<TblAdQualify>();
            try {
               resultModel.setReturnValue(advertiserQualifyService.getAdQualifyById(id));
           } catch (Exception e) {
               LOGGER.error("查询资质信息出错"+ e.getMessage(), e);
               return ResultModelFactory.FAIL500("查询资质信息出错");
           }
            return resultModel;
        }
      
      /**
       * @Title: auditAdQualifyById  
       * @Description: 审核广告主的资质信息
       * @param TblAdQualify param
       * @return ResultModel<TblAdQualify> 
        */
        @LogBefore(operType="/advertiser/auditAdQualifyById",keyName="广告主资质审核")
        @RequestMapping(value = "/auditAdQualifyById",method = RequestMethod.POST)
        public ResultModel<Boolean> auditAdQualifyById(HttpServletRequest request ,TblAdQualify param){
            ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
            if (param == null || param.getId() == null){
                return ResultModelFactory.FAIL500("id不能为空");
            }
            
            if (param.getAuditStatus() == null){
                return ResultModelFactory.FAIL500("审核状态不能为空");
            }
            //审核拒绝填写拒绝原因
            if (param.getAuditStatus().equals(AdvertiserQualifyEnum.REFUSE.getAuditStatus()) && StringUtils.isBlank(param.getRefuseReason())){
                return ResultModelFactory.FAIL500("请填写审核拒绝原因");
            }
            try {
                TblAdQualify record = new TblAdQualify();
                record.setId(param.getId());
                record.setAuditStatus(param.getAuditStatus());
                record.setRefuseReason(param.getRefuseReason());
                record.setRefuseRemark(param.getRefuseRemark());
                advertiserQualifyService.updateAdQualifyById(record);
           } catch (Exception e) {
               LOGGER.error("审核资质信息出错"+ e.getMessage(), e);
               return ResultModelFactory.FAIL500("审核资质信息出错");
           }
            resultModel.setReturnValue(true);
            return resultModel;
        }
        
          /**
          * @Title: auditAdQualifySuccess  
          * @Description: 一键审核通过广告主的资质
          * @return ResultModel<Boolean> 
           */
          @LogBefore(operType="/advertiser/auditAdQualifySuccess",keyName="广告主资质批量审核通过")
          @RequestMapping(value = "/auditAdQualifySuccess",method = RequestMethod.POST)
          public ResultModel<Boolean> auditAdQualifySuccess(HttpServletRequest request ,@RequestParam(name = "ids",required = true) String ids){
              ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
                  try {
                      //资质ID集合
                      List<Integer> parseArray = JSON.parseArray(ids, Integer.class);
                      if(!CollectionUtils.isEmpty(parseArray)){
                          advertiserQualifyService.updateAuditStatusByIds(parseArray);
                      }
                 } catch (Exception e) {
                     LOGGER.error("审核资质信息出错"+ e.getMessage(), e);
                     return ResultModelFactory.FAIL500("审核资质信息出错");
                 }
              resultModel.setReturnValue(true);
              return resultModel;
          }
          
            /**
            * @Title: auditAdQualifyRefuse  
            * @Description: 批量审核拒绝广告主的资质
            * @return ResultModel<Boolean> 
             */
            @LogBefore(operType="/advertiser/auditAdQualifyRefuse",keyName="广告主资质批量审核拒绝")
            @RequestMapping(value = "/auditAdQualifyRefuse",method = RequestMethod.POST)
            public ResultModel<Boolean> auditAdQualifyRefuse(HttpServletRequest request ,@RequestParam(name = "ids",required = true) String ids,
                    @RequestParam(name = "refuseReason",required = true) String refuseReason){
                    ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
                    try {
                        //资质ID集合
                        List<Integer> idList = JSON.parseArray(ids, Integer.class);
                        //资质信息集合
                        List<TblAdQualify> paramList = null;
                        TblAdQualify record = null;
                        if(!CollectionUtils.isEmpty(idList)){
                            paramList = new ArrayList<TblAdQualify>(); 
                            for(Integer id :idList){
                                record = new TblAdQualify();
                                record.setId(id);
                                record.setAuditStatus(AdvertiserQualifyEnum.REFUSE.getAuditStatus());
                                record.setRefuseReason(refuseReason);
                                paramList.add(record);
                            }
                        }
                        if(!CollectionUtils.isEmpty(paramList)){
                            advertiserQualifyService.updateAuditStatusBatch(paramList);
                        }
                   } catch (Exception e) {
                       LOGGER.error("审核资质信息出错"+ e.getMessage(), e);
                       return ResultModelFactory.FAIL500("审核资质信息出错");
                   }
                resultModel.setReturnValue(true);
                return resultModel;
            }
            
            
            /**
            * @Title: getAllAdvertiser  
            * @Description: 封装广告ID和名称
            * @return Map<Integer,String> 
            * @throws Exception 异常
             */
            public Map<String,Object> getAllAdvertiser(TblAdQualifyDto param) throws Exception {
                AdvertiserDto search = new AdvertiserDto();
                //是数字
                if (StringUtil.isNotBlank(param.getKeywords()) && StringUtil.isNumeric(param.getKeywords())) {
                    //防止数字转换异常
                    try {
                        search.setId(Integer.valueOf(param.getKeywords()));
                    } catch (NumberFormatException e) {
                        search.setCompany(param.getKeywords());
                    }
                }else {
                    search.setCompany(param.getKeywords());
                }
                List<AdvertiserDto> list = adShopIntegration.getAdShopList(search);
                List<Long> advertiserIdList = new ArrayList<Long>();
                Map<String,Object> resultMap = new HashMap<String,Object>();
                if(!CollectionUtils.isEmpty(list)){
                    for(AdvertiserDto record : list){
                        if(record.getId() != null){
                            resultMap.put(String.valueOf(record.getId()), record.getCompany());
                            advertiserIdList.add(record.getId().longValue());
                        }
                    }
                    //获取广告主ID
                    resultMap.put("ids",advertiserIdList);
                }
                return resultMap;
            }
            
            
            /**
             * 
            * @Title: getTagName  
            * @Description: 获取标签的id和name的map集合
            * @return Map<String,Object>
             */
            public Map<Integer, String> getTagName(Integer pageNum,Integer pageSize,String name,Integer type){
                PageInfo<TblAdTagVo> tagPageInfo = tblAdTagService.findNewAll(pageNum, pageSize, name,type);
                //广告主名称封装,包括代理和其下的子账号
                Map<Integer, String> tagMap = new HashMap<Integer,String>();
                if(tagPageInfo != null && !CollectionUtils.isEmpty(tagPageInfo.getList())){
                        List<TblAdTagVo> tagList = tagPageInfo.getList();
                        for(TblAdTagVo record : tagList){
                            tagMap.put(record.getId(), record.getName());
                        }
                    }
                return tagMap;
            }

}
