package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.model.dto.advertiser.UpdateStationUserWeightDTO;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightDetailVO;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightVO;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.service.advertiser.TblStationUserWeightService;
import com.bxm.adsmanager.service.advertiser.context.StationUserWeightContext;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;

/**
 * Description 站内户权重业务控制层
 *
 * @author hxpeng
 * <p>
 * Date 2018/12/13 10:38
 */
@Slf4j
@RestController
@RequestMapping("/stationUserWeight")
public class StationUserWeightController extends BaseController {

    @Autowired
    private TblStationUserWeightService tblStationUserWeightService;
    @Autowired
    private AdIncomeTicketService adIncomeTicketService;

    @RequestMapping(value = "/test", method = RequestMethod.GET)
    public void test(@RequestParam(name = "ticketId", required = false) Long ticketId) {
        adIncomeTicketService.updatePositionTicketWeight(ticketId, ticketId);
    }

    @RequestMapping(value = "/check", method = RequestMethod.GET)
    public void check() {
        tblStationUserWeightService.check();
    }


    /**
     * Description: 获取站内户权重列表
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/13 10:56
     *
     * @param advertiserNameOrId 广告主名称或ID
     * @param saleCode           销售
     * @param pageNum            页码
     * @param pageSize           页面大小
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public ResultModel<PageInfo<TblStationUserWeightVO>> getList(@RequestParam(name = "advertiserNameOrId", required = false) String advertiserNameOrId,
                                                                 @RequestParam(name = "saleCode", required = false) String saleCode,
                                                                 @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        return ResultModelFactory.SUCCESS(tblStationUserWeightService.getPage(advertiserNameOrId, saleCode, pageNum, pageSize));
    }


    /**
     * Description: 详情
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/13 15:10
     *
     * @param id 站内户权重计划ID
     * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightDetailVO>
     * @author hxpeng
     */
    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    public ResultModel<TblStationUserWeightDetailVO> detail(@RequestParam(name = "id") Long id) {
        return ResultModelFactory.SUCCESS(tblStationUserWeightService.detail(id));
    }


    /**
     * Description: 增加站内户权重计划
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/13 15:29
     *
     * @param dto      站内户权重
     * @param request  request
     * @param response response
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @LogBefore(operType = "/stationUserWeight/add", keyName = "增加站内户权重")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(UpdateStationUserWeightDTO dto, HttpServletRequest request, HttpServletResponse response) {
        // 校验
        ConstraintViolation constraintViolation = BeanValidator.validateGroup(dto, UpdateStationUserWeightDTO.Add.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAIL400(constraintViolation.getMessage());
        }
        dto.setOperationUserName(super.getUser(request, response).getUsername());
        try {
            return ResultModelFactory.SUCCESS(tblStationUserWeightService.add(dto));
        } finally {
            StationUserWeightContext.remove();
        }
    }

    /**
     * Description: 修改站内户权重计划
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/14 10:07
     *
     * @param dto      站内户权重
     * @param request  request
     * @param response response
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @LogBefore(operType = "/stationUserWeight/update", keyName = "修改站内户权重")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultModel<Boolean> update(UpdateStationUserWeightDTO dto, HttpServletRequest request, HttpServletResponse response) {
        // 校验
        ConstraintViolation constraintViolation = BeanValidator.validateGroup(dto, UpdateStationUserWeightDTO.Update.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAIL400(constraintViolation.getMessage());
        }
        dto.setOperationUserName(super.getUser(request, response).getUsername());
        try {
            return ResultModelFactory.SUCCESS(tblStationUserWeightService.update(dto));
        } finally {
            StationUserWeightContext.remove();
        }
    }
}
