package com.bxm.adsmanager.web.controller.adxadvertiserinfo;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfo;
import com.bxm.adsmanager.model.dto.bes.AuthHeader;
import com.bxm.adsmanager.model.dto.bes.AdxAdvertiserSearchDTO;
import com.bxm.adsmanager.model.dto.bes.MeiTuanAdvertiserAuditDTO;
import com.bxm.adsmanager.model.enums.BesStatusEnum;
import com.bxm.adsmanager.model.vo.bes.BesAdvertiserInfoDetailVO;
import com.bxm.adsmanager.model.vo.bes.BesAdvertiserInfoListVO;
import com.bxm.adsmanager.service.adxadvertiserinfo.AdxAdvertiserInfoService;
import com.bxm.adsmanager.service.review.ReviewRequest;
import com.bxm.adsmanager.service.review.ReviewResult;
import com.bxm.adsmanager.service.review.meituan.MeiTuanCreative;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;

/**
 * 美团广告主信息.</br>
 * Created by zhengwangeng on 2022/3/16
 */
@RestController
@RequestMapping("/meituanAdvertiserInfo")
public class MeiTuanAdvertiserInfoController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MeiTuanAdvertiserInfoController.class);

    @Autowired
    private AdxAdvertiserInfoService adxAdvertiserInfoService;

    @Autowired
    private AuthHeader authHeader;

    @Autowired
    private AdShopIntegration adShopIntegration;

    @Autowired
    private MeiTuanCreative meiTuanCreative;


    /**
     * 根据条件查询
     *
     * @param request
     * @param response
     * @param adxAdvertiserSearchDTO
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel<PageInfo> findAll(HttpServletRequest request, HttpServletResponse response,
                                                 AdxAdvertiserSearchDTO adxAdvertiserSearchDTO) {
        ResultModel<PageInfo> rs = new ResultModel<>();
        try {
            adxAdvertiserSearchDTO.setAdxAdvertiserType(BesAdvertiserInfo.ADX_ADVERTISER_TYPE_MEITUAN);
            PageInfo<BesAdvertiserInfoListVO> page = adxAdvertiserInfoService.findPage(adxAdvertiserSearchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue(page);
        } catch (Exception e) {
            LOGGER.error("根据条件查找美团广告主信息出错" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据条件查找美团广告主信息出错");
        }
        return rs;
    }

    /**
     * 获取详情
     *
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/get", method = RequestMethod.GET)
    public ResultModel<BesAdvertiserInfoDetailVO> get(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Integer id) throws Exception {
        ResultModel<BesAdvertiserInfoDetailVO> rs = new ResultModel<>();
        BesAdvertiserInfoDetailVO besAdvertiserInfoDetailVO = adxAdvertiserInfoService.getDetail(id);
        rs.setSuccessed(true);
        rs.setReturnValue(besAdvertiserInfoDetailVO);

        return rs;
    }

    ///**
    // * 获取最新的审核状态
    // *
    // * @param id
    // * @return
    // */
    //@RequestMapping(value = "/getBesAuditStatus", method = RequestMethod.GET)
    //public ResultModel<Integer> getBesAuditStatus(@NotNull(message = "Id不能为空！") @RequestParam(value = "id") Integer id) throws Exception {
    //    ResultModel<Integer> rs = new ResultModel<>();
    //    rs.setSuccessed(true);
    //    rs.setReturnValue(besAdvertiserService.getBesAuditStatus(id));
    //
    //    return rs;
    //}

    /**
     * 新增
     * @param besAdvertiserInfo
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(@RequestBody BesAdvertiserInfo besAdvertiserInfo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        //User user = getUser(request, response);
        besAdvertiserInfo.setAdxAdvertiserType(BesAdvertiserInfo.ADX_ADVERTISER_TYPE_MEITUAN);
        adxAdvertiserInfoService.add(besAdvertiserInfo);
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 提交审核
     * @param meiTuanAdvertiserAuditDTO
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/audit", method = RequestMethod.POST)
    public ResultModel audit(@RequestBody MeiTuanAdvertiserAuditDTO meiTuanAdvertiserAuditDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        //User user = getUser(request, response);
        BesAdvertiserInfo entity = adxAdvertiserInfoService.get(meiTuanAdvertiserAuditDTO.getId());
        if (BesAdvertiserInfo.ADX_ADVERTISER_TYPE_MEITUAN != entity.getAdxAdvertiserType()) {
            throw new ValidateException("该接口只能提交审核美团广告主！");
        }

        List<AdvertiserDto> adShopMsgs = adShopIntegration.findAdShopMsgs(String.valueOf(meiTuanAdvertiserAuditDTO.getAdvertiserId()));
        if (CollectionUtils.isEmpty(adShopMsgs)) {
            throw new ValidateException("没有找到广告主数据！");
        }
        AdvertiserDto advertiserDto = adShopMsgs.get(0);

        ReviewRequest reviewRequest = ReviewRequest.builder()
                .meiTuanAdvertiserAuditDTO(meiTuanAdvertiserAuditDTO)
                .advertiserDto(advertiserDto)
                .build();

        ReviewResult reviewResult = meiTuanCreative.submitAdv(reviewRequest);
        if (Objects.isNull(reviewResult)) {
            throw new BusinessException("ADX审核结果为空");
        }
        Map<String, Long> submitAdvResultMap = reviewResult.getResult();
        Long adxAdvertiserId = submitAdvResultMap.get(String.valueOf(meiTuanAdvertiserAuditDTO.getAdvertiserId()));
        if (Objects.nonNull(adxAdvertiserId)) {
            entity.setAdxAdvertiserId(String.valueOf(adxAdvertiserId));
            entity.setAuditState(BesStatusEnum.PASS.getLogicStatus());
        } else {
            entity.setAdxAdvertiserId(null);
            entity.setAuditState(BesStatusEnum.REFUSE.getLogicStatus());
        }
        adxAdvertiserInfoService.update(entity);
        return ResultModelFactory.SUCCESS();
    }


}
