package com.bxm.adsmanager.web.controller.agencychannel;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannel;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelSearchDTO;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.List;

/**
 * .</br>
 * Created by daill on 2021/12/13.
 */
@RestController
@RequestMapping("/facade/dpprofit")
public class AgencyChannelDPProfitController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyChannelDPProfitController.class);

    @Autowired
    private AgencyChannelService agencyChannelService;


    /**
     * 查找根据时间所有数据
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/getDPList", method = RequestMethod.GET)
    public ResultModel<List<AgencyChannel>> getDPList(HttpServletRequest request, HttpServletResponse response,
                                                    @RequestParam(name = "dateTime") String dateTime) {
        ResultModel<List<AgencyChannel>> rs = new ResultModel<>();
        try {
            rs.setReturnValue(agencyChannelService.getDPList(dateTime));
        } catch (Exception e) {
            LOGGER.error("查找DP收益录入出错" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("查找DP收益录入出错" + e.getMessage());
        }
        return rs;
    }

}