package com.bxm.adsmanager.web.controller.alipayred;

import com.bxm.adsmanager.model.vo.alipay.AlipayMobileVo;
import com.bxm.adsmanager.service.alipay.AlipayService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket 
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/alipay")
public class AlipayRedController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AlipayRedController.class);
    
    @Autowired
    private AlipayService alipayService;
    
    /**
     * @description
     * @author 拉拉
     * @time 2019/1/4
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response 
     * @return com.bxm.util.dto.ResultModel
     */ 
    @RequestMapping(value = "/findAllByParams", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<AlipayMobileVo>> findAll(HttpServletRequest request, HttpServletResponse response,
                                                        @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                        @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                        @RequestParam(value = "appKey",required = false ) String appKey,
                                                        @RequestParam(value = "positionId",required = false ) String positionId) {
        try {
            ResultModel<PageInfo<AlipayMobileVo>> rs = new ResultModel<PageInfo<AlipayMobileVo>>();
            PageInfo<AlipayMobileVo> result = alipayService.findAllByParams(appKey, positionId, pageNum, pageSize);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (Exception e) {
            LOGGER.error("查找支付宝红包列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找支付宝红包列表出错");
        }
    }
    

}
