package com.bxm.adsmanager.web.controller.audit;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketTagConfMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.AdAuditRecordDto;
import com.bxm.adsmanager.model.vo.AdAuditRecordVo;
import com.bxm.adsmanager.service.audit.AdAuditRecordService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

/**
 * @author tangx
 * @date 2020/10/12 14:52
 */
@RestController
@RequestMapping("/audit/record")
public class AdAuditRecordController {

    @Autowired
    private AdAuditRecordService adAuditRecordService;

    @Autowired
    private AdTicketTagConfMapper adTicketTagConfMapper;



    /**
     * 审核记录列表
     *
     * @return
     */
    @GetMapping("/getPage")
    public ResultModel<PageInfo<AdAuditRecordVo>> getPage(AdAuditRecordDto adAuditRecordDto) {
        // 标签搜索的ticketId
        if (null != adAuditRecordDto.getTag()) {
            List<Long> targetTagTicketIds = adTicketTagConfMapper.findTicketIdByTagCode(adAuditRecordDto.getTag());
            if (targetTagTicketIds == null) {
                targetTagTicketIds = new ArrayList<>();
            }
            adAuditRecordDto.setTicketIds(targetTagTicketIds);
        }
        if (StringUtils.isNotBlank(adAuditRecordDto.getStartTime()) && StringUtils.isNotBlank(adAuditRecordDto.getEndTime())) {
            adAuditRecordDto.setStartTime(adAuditRecordDto.getStartTime() + " 00:00:00");
            adAuditRecordDto.setEndTime(adAuditRecordDto.getEndTime() + " 23:59:59");
        }

        PageInfo<AdAuditRecordVo> pageInfo = adAuditRecordService.getPage(adAuditRecordDto);
        return ResultModelFactory.SUCCESS(pageInfo);
    }

    @GetMapping("/export")
    public ResultModel<PageInfo<AdAuditRecordVo>> export(AdAuditRecordDto adAuditRecordDto, HttpServletResponse response) {
        adAuditRecordDto.setPageNum(1);
        adAuditRecordDto.setPageSize(Integer.MAX_VALUE);

        // 标签搜索的ticketId
        if (null != adAuditRecordDto.getTag()) {
            List<Long> targetTagTicketIds = adTicketTagConfMapper.findTicketIdByTagCode(adAuditRecordDto.getTag());
            if (targetTagTicketIds == null) {
                targetTagTicketIds = new ArrayList<>();
            }
            adAuditRecordDto.setTicketIds(targetTagTicketIds);
        }
        String exportStartDate = adAuditRecordDto.getStartTime();
        String exportEndDate = adAuditRecordDto.getEndTime();
        if (StringUtils.isNotBlank(adAuditRecordDto.getStartTime()) && StringUtils.isNotBlank(adAuditRecordDto.getEndTime())) {
            adAuditRecordDto.setStartTime(adAuditRecordDto.getStartTime() + " 00:00:00");
            adAuditRecordDto.setEndTime(adAuditRecordDto.getEndTime() + " 23:59:59");
        }
        PageInfo<AdAuditRecordVo> pageInfo = adAuditRecordService.getPage(adAuditRecordDto);
        List<AdAuditRecordVo> list = pageInfo.getList();
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        if (CollectionUtils.isNotEmpty(list)) {
            list.stream().forEach(l -> {
//                l.setAuditTimeStr(l.getAuditTime() == null ? null : new DateTime(l.getAuditTime()).toString(dateFormat));
//                l.setSubmitTimeStr(l.getSubmitTime() == null ? null : new DateTime(l.getSubmitTime()).toString(dateFormat));
                l.setAuditTimeStr(l.getAuditTime());
                l.setSubmitTimeStr(l.getSubmitTime());
                l.setTicketTypeStr(AdTicket.AdTicketType.getName(l.getTicketType()));
                if (l.getTicketAuditStatus() != null) {
                    l.setTicketAuditStatusStr(l.getTicketAuditStatus() == 1 ? "通过" : "拒绝");
                }
                if (l.getAssetsAuditStatus() != null) {
                    l.setAssetsAuditStatusStr(l.getAssetsAuditStatus() == 1 ? "通过" : "拒绝");
                }
            });
        }

        ExcelUtil.exportExcel(pageInfo.getList(), null, "审核日志", AdAuditRecordVo.class,
                "审核日志"+exportStartDate+ "-" + exportEndDate + ".xls", response);
        return ResultModelFactory.SUCCESS(pageInfo);
    }

    public static void main(String[] args) {
        System.out.println(new DateTime("2022-04-30"));

    }

}
