package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.model.dto.adarpu.AdDoMainArpuDto;
import com.bxm.adsmanager.model.vo.alipay.AlipayMobileVo;
import com.bxm.adsmanager.model.vo.audit.IndustryAuditVo;
import com.bxm.adsmanager.service.audit.IndustryService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/audit")
public class IndustryAuditController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(IndustryAuditController.class);

    @Autowired
    IndustryService industryService;

    @RequestMapping(value = "/industry/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "code") String code) {
        try {
             // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            industryService.add(code,userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增审核标签出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }
    @RequestMapping(value = "/industry/delete", produces = "application/json")
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "id") Long id) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            industryService.delete(id,userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("删除审核标签出错", e);
            return ResultModelFactory.FAIL500("删除审核标签出错");
        }
    }

    @RequestMapping(value = "/industry/getList", produces = "application/json")
    public ResultModel<List<IndustryAuditVo>> getList(HttpServletRequest request, HttpServletResponse response) {
        ResultModel<List<IndustryAuditVo>> resultModel =new ResultModel<>();
        try {
            resultModel.setReturnValue(industryService.getList());
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            LOGGER.error("查找标签审核列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找标签审核列表出错");
        }
        return resultModel;
    }
    @RequestMapping(value = "/industry/getPageList", produces = "application/json")
    public ResultModel<PageInfo<IndustryAuditVo>> getPageList( @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
                                                           HttpServletRequest request, HttpServletResponse response) {
        ResultModel<PageInfo<IndustryAuditVo>> resultModel =new ResultModel<>();
        try {
            resultModel.setReturnValue(industryService.getPageList(pageNum,pageSize));
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            LOGGER.error("查找标签审核列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找标签审核列表出错");
        }
        return resultModel;
    }
}
