package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dto.LandingPagePlanSearchDto;
import com.bxm.adsmanager.model.vo.LandingPagePlanVo;
import com.bxm.adsmanager.service.adkeeper.LandingPageService;
import com.bxm.adsmanager.service.audit.LandingPageAuditService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author tangx
 * @date 2021/3/16 10:12
 */
@RestController
@RequestMapping("/audit/landingPage")
@Slf4j
public class LandingPageAuditController extends BaseController {

    @Autowired
    private LandingPageService landingPageService;
    @Autowired
    private LandingPageAuditService landingPageAuditService;

    @GetMapping("/list")
    public ResultModel getList(LandingPagePlanSearchDto dto) {
        PageInfo<LandingPagePlanVo> list = landingPageService.list(dto);
        return ResultModelFactory.SUCCESS(list);
    }

    /**
     * 素材审核审核
     *
     * @param id
     * @param auditStatus
     * @return
     */
    @LogBefore(operType = "/audit/landingPage/updateAudit", keyName = "落地页ab计划审核")
    @PostMapping("/updateAudit")
    public ResultModel<Boolean> landingPageAudit(@RequestParam("id") Long id,
                                                 @RequestParam("auditStatus") Short auditStatus,
                                                 @RequestParam("refuseReason") String refuseReason) {
        try {
            landingPageAuditService.landingPageAudit(id, auditStatus, refuseReason);
        } catch (BusinessException e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

}
